/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.ui.actions.MacroTraceHoverSingleClickListener;
import ro.amiq.dvt.ui.editor.DVTMultipleHyperlinkPresenter;
import ro.amiq.dvt.ui.editor.ExternalToolsAnnotationClickListener;
import ro.amiq.dvt.ui.editor.hover.AnnotationExpandHover;
import ro.amiq.dvt.ui.editor.hover.DVTDefaultAnnotationHover;
import ro.amiq.dvt.ui.editor.hover.ISingleClickListener;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixConstants;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.spelling.WordQuickFixProcessor;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.debug.ui.editor.hover.EDebugTextHoverParticipant;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.EAutoEditStrategy;
import ro.amiq.edt.base.ui.editor.EDoubleClickStrategy;
import ro.amiq.edt.base.ui.editor.ENonRuleBasedDamagerRepairer;
import ro.amiq.edt.base.ui.editor.EReconcilingStrategy;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfigurationCommon;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistProcessorManager;
import ro.amiq.edt.base.ui.editor.contentassist.EKeyphraseContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.EKeywordContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.EStringContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.ETemplateContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.hover.ETextHover;
import ro.amiq.edt.base.ui.editor.hover.ETextHoverParticipant;
import ro.amiq.edt.base.ui.editor.hyperlink.CommentHyperlinkDetector;
import ro.amiq.edt.base.ui.editor.hyperlink.ImportHyperlinkDetector;
import ro.amiq.edt.base.ui.editor.hyperlink.RfHyperlinkDetector;
import ro.amiq.edt.base.ui.editor.quickfix.EEditorQuickFixProcessor;
import ro.amiq.edt.base.ui.macroexpansion.MacroExpansionMarkerClickListener;

public class ESourceViewerConfiguration
extends ESourceViewerConfigurationCommon {
    protected final String[] fConfiguredContentType = new String[]{"__e_sv_ml_comment", "__e_ml_comment", "__e_sl_comment", "__dftl_partition_content_type", "__e_expansion", "__e_string", "__e_sl_comment_in_expansion", "__e_string_in_code_replacement_in_expansion", "__e_string_in_code_section_in_expansion"};
    private ITextHover fTextHover;
    private AnnotationExpandHover fAnnotationHover;
    private DVTDefaultAnnotationHover fAnnotationHover2;
    ITextDoubleClickStrategy fDoubleClickStrategy;
    private EAutoEditStrategy fAutoIndentStrategy = null;
    private IDialogSettings fDialogSettings;
    private static String[] fDefaultPrefixes = new String[]{"//", "--"};
    private boolean fResetCommentFormatterIndent;
    private EReconcilingStrategy fReconcilingStrategy;

    public ESourceViewerConfiguration(IEPluginConfig pluginConfig, AbstractEEditor editor) {
        super(pluginConfig, editor);
    }

    public static IPreferenceStore getCombinedPreferenceStore(IEPluginConfig pluginConfig) {
        return pluginConfig.getCombinedPreferenceStore();
    }

    public AbstractEEditor getEditor() {
        return this.fEditor;
    }

    public void refreshLineDelimiter() {
        this.fLineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.fEditor);
    }

    protected void setProjectionAnnotationModel(ProjectionAnnotationModel model) {
        this.fPresentationReconciler.setProjectionAnnotationModel(model);
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return new DVTMultipleHyperlinkPresenter(new RGB(0, 0, 255));
        }
        return new DVTMultipleHyperlinkPresenter(this.fPreferenceStore);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.fConfiguredContentType;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new EDoubleClickStrategy(this.fBracketMatcher);
        }
        return this.fDoubleClickStrategy;
    }

    public static void updatePresentationReconciler(IEPluginConfig pluginConfig, IPresentationReconciler reconciler) {
        IToken token = pluginConfig.getEStyle().getToken("highlight.string");
        ((ENonRuleBasedDamagerRepairer)reconciler.getDamager("__e_string")).setAttribute(token);
        ((ENonRuleBasedDamagerRepairer)reconciler.getRepairer("__e_string")).setAttribute(token);
        ((ENonRuleBasedDamagerRepairer)reconciler.getDamager("__e_string_in_code_replacement_in_expansion")).setAttribute(token);
        ((ENonRuleBasedDamagerRepairer)reconciler.getRepairer("__e_string_in_code_replacement_in_expansion")).setAttribute(token);
        ((ENonRuleBasedDamagerRepairer)reconciler.getDamager("__e_string_in_code_section_in_expansion")).setAttribute(token);
        ((ENonRuleBasedDamagerRepairer)reconciler.getRepairer("__e_string_in_code_section_in_expansion")).setAttribute(token);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationExpandHover(new CompositeRuler(), (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), null, (ISingleClickListener)new MacroTraceHoverSingleClickListener());
            MacroExpansionMarkerClickListener macroListener = new MacroExpansionMarkerClickListener(this.fEditor);
            this.fAnnotationHover.addCustomClickListener(this.fPluginConfig.getMacroMarkerID(), (ISingleClickListener)macroListener);
            ExternalToolsAnnotationClickListener externalToolsListener = new ExternalToolsAnnotationClickListener();
            this.fAnnotationHover.addCustomClickListener(DVTProblemCategories.EXTERNALTOOLS.getMarkerId(), (ISingleClickListener)externalToolsListener);
        }
        return this.fAnnotationHover;
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover2 == null) {
            this.fAnnotationHover2 = new DVTDefaultAnnotationHover();
        }
        return this.fAnnotationHover2;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fEditor == null) {
            return null;
        }
        if (this.fTextHover == null) {
            this.fTextHover = new ETextHover((ITextEditor)this.fEditor);
            ((ETextHover)this.fTextHover).addTextHoverParticipant(new ETextHoverParticipant(this.fPluginConfig));
            ((ETextHover)this.fTextHover).addTextHoverParticipant(new EDebugTextHoverParticipant());
        }
        return this.fTextHover;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        IInformationPresenter presenter = super.getInformationPresenter(sourceViewer);
        ITextHover textHover = this.getTextHover(sourceViewer, null);
        InformationProvider provider = new InformationProvider(textHover);
        ((InformationPresenter)presenter).setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        Point location = sourceViewer.getTextWidget().getSelectionRange();
        ((InformationPresenter)presenter).setMargins(location.x, location.y);
        return presenter;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        final WordQuickFixProcessor spellingQuickFix = new WordQuickFixProcessor((ITextEditor)this.fEditor);
        IQuickAssistProcessor processor = new IQuickAssistProcessor(){

            public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
                return false;
            }

            public boolean canFix(Annotation annotation) {
                if (annotation == null) {
                    return false;
                }
                String annotationType = annotation.getType();
                boolean spellingAssist = "org.eclipse.ui.workbench.texteditor.spelling".equals(annotationType);
                if (spellingAssist) {
                    return true;
                }
                if (annotation instanceof MarkerAnnotation) {
                    int quickFixKind;
                    block10: {
                        IMarker marker;
                        block9: {
                            marker = ((MarkerAnnotation)annotation).getMarker();
                            try {
                                if (EProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) break block9;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        String elementName = marker.getAttribute("QUICKFIX_ELEMENT_NAME", "");
                        int scopeOffset = marker.getAttribute("charStart", -1);
                        if (scopeOffset == -1) {
                            int line = marker.getAttribute("lineNumber", 1);
                            scopeOffset = ESourceViewerConfiguration.this.fEditor.getDocument().getLineOffset(line - 1);
                        }
                        quickFixKind = marker.getAttribute("QUICKFIX_KIND", -1);
                        if (elementName != null && scopeOffset != -1 && quickFixKind != -1) break block10;
                        return false;
                    }
                    if (QuickFixConstants.IMPLEMENTED_QUICK_FIXES.contains(quickFixKind)) {
                        return true;
                    }
                }
                return false;
            }

            public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
                ICompletionProposal[] result = new EEditorQuickFixProcessor(ESourceViewerConfiguration.this.fPluginConfig, (ITextEditor)ESourceViewerConfiguration.this.fEditor).computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                result = spellingQuickFix.computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                return new ICompletionProposal[]{DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE};
            }

            public String getErrorMessage() {
                return null;
            }
        };
        assistant.setQuickAssistProcessor(processor);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fContentAssistant != null) {
            return this.fContentAssistant;
        }
        if (this.fEditor == null) {
            return null;
        }
        this.fContentAssistant = new ContentAssistant();
        this.fContentAssistant.enableColoredLabels(true);
        this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fContentAssistant.setRepeatedInvocationMode(true);
        this.fContentAssistant.setStatusLineVisible(true);
        this.fContentAssistant.setStatusMessage("Press 'Ctrl+Space' to show Template proposals");
        this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fSourceProcessorManager = new EContentAssistProcessorManager(this.fPluginConfig, this.fEditor, this.fContentAssistant);
        this.fContentAssistant.addCompletionListener((ICompletionListener)this.fSourceProcessorManager);
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor != null) {
            this.fSourceProcessorManager.addContentAssistProcessor((IContentAssistProcessor)aiHostContributor.getCodeCompletionProcessorAndListener());
            this.fContentAssistant.addCompletionListener((ICompletionListener)aiHostContributor.getCodeCompletionProcessorAndListener());
        }
        this.fSourceProcessorManager.addContentAssistProcessor(new RfContentAssistProcessor(this.fPluginConfig, this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor(new EKeyphraseContentAssistProcessor(this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor(new EKeywordContentAssistProcessor(this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor((IContentAssistProcessor)new ETemplateContentAssistProcessor(this.fPluginConfig, (TextEditor)this.fEditor, this.fSourceProcessorManager));
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fSourceProcessorManager, "__dftl_partition_content_type");
        this.fStringProcessorManager = new EContentAssistProcessorManager(this.fPluginConfig, this.fEditor, this.fContentAssistant);
        this.fContentAssistant.addCompletionListener((ICompletionListener)this.fStringProcessorManager);
        this.fStringProcessorManager.addContentAssistProcessor((IContentAssistProcessor)new EStringContentAssistProcessor(this.fStringProcessorManager));
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fStringProcessorManager, "__e_string");
        this.fCommentProcessorManager = new EContentAssistProcessorManager(this.fPluginConfig, this.fEditor, this.fContentAssistant);
        this.fContentAssistant.addCompletionListener((ICompletionListener)this.fCommentProcessorManager);
        this.fCommentProcessorManager.addContentAssistProcessor((IContentAssistProcessor)new ETemplateContentAssistProcessor(this.fPluginConfig, (TextEditor)this.fEditor, this.fCommentProcessorManager));
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fCommentProcessorManager, "__e_ml_comment");
        this.fContentAssistant.setContextInformationPopupOrientation(20);
        this.fContentAssistant.enableAutoActivation(true);
        this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.fDialogSettings = new DialogSettings("dvt.contentAssist");
        this.fContentAssistant.setRestoreCompletionProposalSize(this.fDialogSettings);
        return this.fContentAssistant;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 3];
        detectors[0] = new ImportHyperlinkDetector(this.fPluginConfig, (ITextEditor)this.fEditor);
        detectors[1] = new RfHyperlinkDetector(this.fPluginConfig, (ITextEditor)this.fEditor);
        detectors[2] = new CommentHyperlinkDetector(this.fPluginConfig, this.fEditor);
        if (inheritedDetectors != null) {
            int i = 0;
            while (i < inheritedDetectorsLength) {
                detectors[i + 3] = inheritedDetectors[i];
                ++i;
            }
        }
        return detectors;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent _event) {
        this.fPluginConfig.getEStyle().adaptToPreferenceChange(_event);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.fAutoIndentStrategy == null) {
            this.fAutoIndentStrategy = new EAutoEditStrategy(this.fPluginConfig, sourceViewer, this);
        }
        if (contentType.equals("__dftl_partition_content_type")) {
            return new IAutoEditStrategy[]{this.fAutoIndentStrategy};
        }
        if (contentType.equals("__e_expansion")) {
            return new IAutoEditStrategy[]{new EAutoEditStrategy(this.fPluginConfig, sourceViewer, this)};
        }
        if (contentType.equals("__e_sl_comment")) {
            return new IAutoEditStrategy[]{new EAutoEditStrategy(this.fPluginConfig, sourceViewer, this)};
        }
        if (contentType.equals("__e_string")) {
            return new IAutoEditStrategy[]{this.fAutoIndentStrategy};
        }
        if (contentType.equals("__e_sl_comment_in_expansion")) {
            return new IAutoEditStrategy[]{new EAutoEditStrategy(this.fPluginConfig, sourceViewer, this)};
        }
        if (contentType.equals("__e_string_in_code_replacement_in_expansion")) {
            return new IAutoEditStrategy[]{this.fAutoIndentStrategy};
        }
        if (contentType.equals("__e_string_in_code_section_in_expansion")) {
            return new IAutoEditStrategy[]{this.fAutoIndentStrategy};
        }
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return fDefaultPrefixes;
    }

    public static void switchDefaultPrefixes() {
        String prefix0 = fDefaultPrefixes[0];
        ESourceViewerConfiguration.fDefaultPrefixes[0] = fDefaultPrefixes[1];
        ESourceViewerConfiguration.fDefaultPrefixes[1] = prefix0;
    }

    public String getPrefixZero() {
        return fDefaultPrefixes[0];
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        this.fReconcilingStrategy = new EReconcilingStrategy(sourceViewer, EditorsUI.getSpellingService());
        IDocument document = sourceViewer.getDocument();
        this.fReconcilingStrategy.setDocument(document);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)this.fReconcilingStrategy, false);
        reconciler.setDelay(500);
        this.setReconciler(reconciler);
        return reconciler;
    }

    public void resetCommentFormatterIndent(boolean reset) {
        this.fResetCommentFormatterIndent = reset;
    }

    public boolean getResetFormatterIndent() {
        return this.fResetCommentFormatterIndent;
    }

    public IInformationPresenter getQuickViewerPresenter(ISourceViewer sourceViewer, IInformationControlCreator controlCreator) {
        QuickViewInfoProvider provider = new QuickViewInfoProvider();
        InformationPresenter presenter = new InformationPresenter(controlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_expansion");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_sv_ml_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_ml_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_sl_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_sl_comment_in_expansion");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_string_in_code_replacement_in_expansion");
        presenter.setInformationProvider((IInformationProvider)provider, "__e_string_in_code_section_in_expansion");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fReconcilingStrategy != null) {
            this.fReconcilingStrategy.setDocument(null);
            this.fReconcilingStrategy = null;
        }
        if (this.fPrefListener != null) {
            this.fPluginConfig.getPlugin().getPreferenceStore().removePropertyChangeListener(this.fPrefListener);
        }
        this.fPrefListener = null;
        this.fTextHover = null;
        this.fAutoIndentStrategy = null;
        if (this.fContentAssistant != null) {
            if (this.fSourceProcessorManager != null) {
                this.fContentAssistant.removeCompletionListener((ICompletionListener)this.fSourceProcessorManager);
                this.fSourceProcessorManager = null;
            }
            if (this.fCommentProcessorManager != null) {
                this.fContentAssistant.removeCompletionListener((ICompletionListener)this.fCommentProcessorManager);
                this.fCommentProcessorManager = null;
            }
            this.fContentAssistant = null;
        }
    }

    public EContentAssistProcessorManager getSourceProcessorManager() {
        return this.fSourceProcessorManager;
    }

    @Override
    public ESourceViewerConfiguration getConfig() {
        return this;
    }

    private static class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private final ITextHover textHover;

        private InformationProvider(ITextHover textHover) {
            this.textHover = textHover;
        }

        public IRegion getSubject(ITextViewer textViewer, final int offset) {
            return new IRegion(){

                public int getOffset() {
                    return offset;
                }

                public int getLength() {
                    return 1;
                }
            };
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.textHover.getHoverInfo(textViewer, subject);
        }

        public Object getInformation2(ITextViewer textViewer, IRegion hoverRegion) {
            return this.textHover instanceof ETextHover ? ((ETextHover)this.textHover).getHoverInfo2(textViewer, hoverRegion) : this.textHover.getHoverInfo(textViewer, hoverRegion);
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.textHover instanceof ETextHover ? ((ETextHover)this.textHover).getHoverControlCreator() : null;
        }
    }

    static class QuickViewInfoProvider
    implements IInformationProvider,
    IInformationProviderExtension {
        private Object fData;

        QuickViewInfoProvider() {
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return null;
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            return new Region(0, 1);
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fData;
        }

        public void setDataToShow(Object data) {
            this.fData = data;
        }
    }
}

