/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.ECodeScanner;
import ro.amiq.edt.base.ui.editor.ECommentScanner;
import ro.amiq.edt.base.ui.editor.EExpansionScanner;
import ro.amiq.edt.base.ui.editor.EFastPartitionScanner;
import ro.amiq.edt.base.ui.editor.ENonRuleBasedDamagerRepairer;
import ro.amiq.edt.base.ui.editor.EReconciler;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfiguration;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistProcessorManager;
import ro.amiq.edt.base.ui.editor.formatter.ECodeFormattingStrategy;
import ro.amiq.edt.base.ui.editor.formatter.EContentFormatter;
import ro.amiq.edt.base.ui.editor.formatter.EExpansionFormattingStrategy;
import ro.amiq.edt.base.ui.editor.formatter.ELiteralFormattingStrategy;
import ro.amiq.edt.base.ui.editor.formatter.EMLCommentFormattingStrategy;
import ro.amiq.edt.base.ui.editor.formatter.ESLCommentFormattingStrategy;
import ro.amiq.edt.base.ui.preferences.PrefConst;

public abstract class ESourceViewerConfigurationCommon
extends DVTSourceViewerConfiguration {
    protected ECodeScanner fCodeScanner;
    protected EExpansionScanner fExpansionScanner;
    protected ECommentScanner fCommentScanner;
    protected AbstractEEditor fEditor;
    protected IEPluginConfig fPluginConfig;
    protected IPropertyChangeListener fPrefListener;
    protected DVTPresentationReconciler fPresentationReconciler;
    protected ECodeFormattingStrategy fCodeStrategy;
    protected ESLCommentFormattingStrategy fSLCommentStrategy;
    protected EMLCommentFormattingStrategy fMLCommentStrategy;
    protected ELiteralFormattingStrategy fLiteralStrategy;
    protected EExpansionFormattingStrategy fExpansionStrategy;
    protected ContentAssistant fContentAssistant;
    protected DVTContentFormatter fFormatter;
    protected EContentAssistProcessorManager fSourceProcessorManager;
    protected EContentAssistProcessorManager fCommentProcessorManager;
    protected EContentAssistProcessorManager fStringProcessorManager;

    protected ESourceViewerConfigurationCommon(IEPluginConfig pluginConfig, AbstractEEditor editor) {
        super(ESourceViewerConfiguration.getCombinedPreferenceStore(pluginConfig));
        this.fEditor = editor;
        this.fPluginConfig = pluginConfig;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__e_partitioning";
    }

    protected ECodeScanner getECodeScanner(int nofLines) {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = this.createECodeScanner(nofLines);
            this.fCodeScanner.setDefaultReturnToken(this.fPluginConfig.getEStyle().getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected ECodeScanner createECodeScanner(int nofLines) {
        return new ECodeScanner(this.fPluginConfig, this.fPluginConfig.getEStyle(), nofLines);
    }

    protected EExpansionScanner getEExpansionScanner() {
        if (this.fExpansionScanner == null) {
            this.fExpansionScanner = new EExpansionScanner(this.fPluginConfig, this.fPluginConfig.getEStyle(), true);
            this.fExpansionScanner.setDefaultReturnToken(this.fPluginConfig.getEStyle().getToken("highlight.exp_literal"));
        }
        return this.fExpansionScanner;
    }

    private ITokenScanner getECommentScanner(int nofLines) {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new ECommentScanner(this.fPluginConfig.getEStyle(), true, nofLines, false, this.fEditor != null ? this.fEditor.getProject() : null);
            this.fCommentScanner.setDefaultReturnToken(this.fPluginConfig.getEStyle().getToken("highlight.comment"));
        }
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.fPresentationReconciler == null) {
            int foldingEnabled;
            this.fPresentationReconciler = new DVTPresentationReconciler();
            this.fPresentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            int nofLines = PrefConst.getCodeFoldingNofLines(this.fPluginConfig.getPlugin());
            boolean enable = PrefConst.isCodeFoldingEnabled(this.fPluginConfig.getPlugin());
            boolean manualEnable = PrefConst.isManualCodeFoldingEnabled(this.fPluginConfig.getPlugin());
            int n = foldingEnabled = !enable ? 0 : nofLines;
            int manualFoldingEnabled = !manualEnable ? 0 : (!enable ? 0 : nofLines);
            this.fPresentationReconciler.setNofLinesFolding(foldingEnabled);
            EReconciler dr1 = new EReconciler((ITokenScanner)this.getECodeScanner(foldingEnabled), false, (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
            EReconciler dr2 = new EReconciler((ITokenScanner)this.getEExpansionScanner(), false, (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr2, "__e_expansion");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr2, "__e_expansion");
            EReconciler dr3 = new EReconciler(this.getECommentScanner(manualFoldingEnabled), true, (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr3, "__e_ml_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr3, "__e_ml_comment");
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr3, "__e_sv_ml_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr3, "__e_sv_ml_comment");
            EReconciler dr4 = new EReconciler(this.getECommentScanner(manualFoldingEnabled), true, (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr4, "__e_sl_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr4, "__e_sl_comment");
            IToken token = this.fPluginConfig.getEStyle().getToken("highlight.string");
            ENonRuleBasedDamagerRepairer ndr = new ENonRuleBasedDamagerRepairer(token);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr, "__e_string");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr, "__e_string");
            EReconciler dr7 = new EReconciler(this.getECommentScanner(manualFoldingEnabled), true, (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr7, "__e_sl_comment_in_expansion");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr7, "__e_sl_comment_in_expansion");
            ENonRuleBasedDamagerRepairer ndr2 = new ENonRuleBasedDamagerRepairer(token);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr2, "__e_string_in_code_replacement_in_expansion");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr2, "__e_string_in_code_replacement_in_expansion");
            ENonRuleBasedDamagerRepairer ndr3 = new ENonRuleBasedDamagerRepairer(token);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr3, "__e_string_in_code_section_in_expansion");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr3, "__e_string_in_code_section_in_expansion");
            this.fPrefListener = Utils.setUpFoldingPreferencesListener((IPreferenceStore)this.fPluginConfig.getPlugin().getPreferenceStore(), (String)"editor.codeFolding", (String)"editor.manualCodeFolding", (String)"editor.numberOfLines", (DVTPresentationReconciler)this.fPresentationReconciler, (DVTBaseScanner)this.fCodeScanner, (DVTBaseScanner)this.fCommentScanner, null);
        }
        return this.fPresentationReconciler;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
        }
        this.fFormatter = new EContentFormatter(this);
        this.fFormatter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        CFPreferences formatPreferences = this.fPluginConfig.getFormattingPreferences();
        this.fCodeStrategy = new ECodeFormattingStrategy(this.getConfig(), formatPreferences);
        this.fSLCommentStrategy = new ESLCommentFormattingStrategy(this, formatPreferences);
        this.fMLCommentStrategy = new EMLCommentFormattingStrategy(this, formatPreferences);
        this.fLiteralStrategy = new ELiteralFormattingStrategy(this, formatPreferences);
        this.fExpansionStrategy = new EExpansionFormattingStrategy(this, formatPreferences);
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fCodeStrategy, "__dftl_partition_content_type");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fSLCommentStrategy, "__e_sl_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fMLCommentStrategy, "__e_ml_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fMLCommentStrategy, "__e_sv_ml_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fLiteralStrategy, "__e_string");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fExpansionStrategy, "__e_expansion");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fExpansionStrategy, "__e_sl_comment_in_expansion");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fExpansionStrategy, "__e_string_in_code_replacement_in_expansion");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fExpansionStrategy, "__e_string_in_code_section_in_expansion");
        return this.fFormatter;
    }

    public DVTBaseCodeFormattingStrategy getCodeFormattingStrategy() {
        return this.fCodeStrategy;
    }

    public DVTBaseFormattingStrategy getSLCommentFormattingStrategy() {
        return this.fSLCommentStrategy;
    }

    protected void setupDocumentPartitioner(IDocument document, String partitioning) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new EFastPartitionScanner(this.fPluginConfig), new String[]{"__dftl_partition_content_type", "__e_expansion", "__e_sl_comment", "__e_sv_ml_comment", "__e_ml_comment", "__e_string", "__e_sl_comment_in_expansion", "__e_string_in_code_replacement_in_expansion", "__e_string_in_code_section_in_expansion"});
            extension3.setDocumentPartitioner(partitioning, (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    public void setupDocumentPartitioner(IDocument document) {
        this.setupDocumentPartitioner(document, "__e_partitioning");
    }

    public void connectCFDocumentPartitioner(IDocument document) {
        this.setupDocumentPartitioner(document, "__cf_partitioning");
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.E;
    }

    public void dispose() {
        super.dispose();
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.setDamager(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setDamager(null, "__e_expansion");
            this.fPresentationReconciler.setRepairer(null, "__e_expansion");
            this.fPresentationReconciler.setDamager(null, "__e_ml_comment");
            this.fPresentationReconciler.setRepairer(null, "__e_ml_comment");
            this.fPresentationReconciler.setDamager(null, "__e_sv_ml_comment");
            this.fPresentationReconciler.setRepairer(null, "__e_sv_ml_comment");
            this.fPresentationReconciler.setDamager(null, "__e_sl_comment");
            this.fPresentationReconciler.setRepairer(null, "__e_sl_comment");
            this.fPresentationReconciler.setDamager(null, "__e_string");
            this.fPresentationReconciler.setRepairer(null, "__e_string");
            this.fPresentationReconciler.setDamager(null, "__e_sl_comment_in_expansion");
            this.fPresentationReconciler.setRepairer(null, "__e_sl_comment_in_expansion");
            this.fPresentationReconciler.setDamager(null, "__e_string_in_code_replacement_in_expansion");
            this.fPresentationReconciler.setRepairer(null, "__e_string_in_code_replacement_in_expansion");
            this.fPresentationReconciler.setDamager(null, "__e_string_in_code_section_in_expansion");
            this.fPresentationReconciler.setRepairer(null, "__e_string_in_code_section_in_expansion");
            this.fPresentationReconciler = null;
        }
        if (this.fCodeScanner != null) {
            this.fCodeScanner.dispose();
            this.fCodeScanner = null;
        }
        if (this.fCommentScanner != null) {
            this.fCommentScanner.dispose();
            this.fCommentScanner = null;
        }
        if (this.fLiteralStrategy != null) {
            this.fLiteralStrategy.dispose();
            this.fLiteralStrategy = null;
        }
        if (this.fCodeStrategy != null) {
            this.fCodeStrategy.dispose();
            this.fCodeStrategy = null;
        }
        if (this.fSLCommentStrategy != null) {
            this.fSLCommentStrategy.dispose();
            this.fSLCommentStrategy = null;
        }
        this.fEditor = null;
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
            this.fFormatter = null;
        }
    }

    public abstract ESourceViewerConfiguration getConfig();
}

