/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTWordFinder;

public class EWordFinder
extends DVTWordFinder {
    private static EWordFinder eWordFinder;

    public static EWordFinder getDefault() {
        if (eWordFinder == null) {
            eWordFinder = new EWordFinder();
        }
        return eWordFinder;
    }

    public IRegion getWordAtOffset(IDocument document, int offset) {
        return this.getWordAtOffset(document, offset, false);
    }

    public IRegion getWordAtOffset(IDocument document, int offset, boolean enableNumerics) {
        return this.getWordAtOffset(document, offset, enableNumerics, "");
    }

    public IRegion getWordAtOffset(IDocument document, int offset, String customChars) {
        return this.getWordAtOffset(document, offset, false, customChars);
    }

    public IRegion getWordAtOffset(IDocument document, int offset, boolean enableNumerics, String customChars) {
        if (customChars == null) {
            customChars = "";
        }
        int start = -1;
        int end = -1;
        try {
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new Region(0, 0);
            }
            int ch = this.getChar(document, pos - 1);
            if (!Character.isJavaIdentifierPart((char)ch) && customChars.indexOf((char)ch) == -1) {
                ch = this.getChar(document, pos);
                if (!Character.isJavaIdentifierPart((char)ch) && customChars.indexOf((char)ch) == -1) {
                    return new Region(0, 0);
                }
                ++pos;
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            int pch = 0;
            while (pos >= 0) {
                ch = scanner.read();
                if ((!Character.isJavaIdentifierPart(ch) || pos == 0) && (ch != 39 || pch != 111 && pch != 79 && pch != 98 && pch != 66 && pch != 104 && pch != 72 && pch != 100 && pch != 68 || !enableNumerics) && customChars.indexOf(ch) == -1) break;
                --pos;
                pch = ch;
            }
            ch = this.getChar(document, pos);
            if (!Character.isJavaIdentifierStart(ch) && !enableNumerics && customChars.indexOf(ch) == -1) {
                return new Region(0, 0);
            }
            start = pos;
            pos = offset;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            while (ch != -1) {
                ch = scanner.read();
                if (!Character.isJavaIdentifierPart(ch) && customChars.indexOf(ch) == -1) break;
                ++pos;
            }
            end = pos;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            return new Region(start, end - start);
        }
        return new Region(0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion getExpressionAtOffset(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new Region(0, 0);
            }
            int ch = this.getChar(document, pos - 1);
            if (!Character.isJavaIdentifierPart((char)ch)) {
                ch = this.getChar(document, pos);
                if (!Character.isJavaIdentifierPart((char)ch)) {
                    return new Region(0, 0);
                }
                ++pos;
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            EXPRESSION_STATE state = EXPRESSION_STATE.CODE;
            int nested = 0;
            block11: while (pos > 0) {
                ch = scanner.read();
                switch (state) {
                    case CODE: {
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_START;
                            break;
                        }
                        if ((char)ch == '.') {
                            state = EXPRESSION_STATE.DOT;
                            break;
                        }
                        if (((char)ch == '{' || (char)ch == '[' || (char)ch == '(') && nested == 0) break block11;
                        if ((char)ch == '(' || (char)ch == '{' || (char)ch == '[') {
                            --nested;
                            break;
                        }
                        if ((char)ch == ')' || (char)ch == '}' || (char)ch == ']') {
                            ++nested;
                            break;
                        }
                        if (Character.isWhitespace((char)ch)) {
                            state = EXPRESSION_STATE.WS_CODE;
                            break;
                        }
                        if (Character.isJavaIdentifierPart((char)ch) || (char)ch == '.' || (char)ch == '$' || nested != 0) break;
                        break block11;
                    }
                    case LITERAL_START: {
                        if ((char)ch == '\\') {
                            state = EXPRESSION_STATE.CODE;
                            break;
                        }
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_END;
                            break;
                        }
                        state = EXPRESSION_STATE.LITERAL;
                        break;
                    }
                    case LITERAL: {
                        if ((char)ch != '\"') break;
                        state = EXPRESSION_STATE.LITERAL_END;
                        break;
                    }
                    case LITERAL_END: {
                        if ((char)ch == '\\') {
                            state = EXPRESSION_STATE.LITERAL;
                            break;
                        }
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_START;
                            break;
                        }
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case DOT: {
                        if (Character.isWhitespace((char)ch)) {
                            state = EXPRESSION_STATE.WS_DOT;
                        } else if (((char)ch == '{' || (char)ch == '[' || (char)ch == '(') && nested == 0) break block11;
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case WS_DOT: {
                        if (((char)ch == '{' || (char)ch == '[' || (char)ch == '(') && nested == 0) break block11;
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case WS_CODE: {
                        if ((char)ch == '.') {
                            state = EXPRESSION_STATE.DOT;
                        } else if (Character.isWhitespace((char)ch)) {
                            state = EXPRESSION_STATE.WS_CODE;
                        } else if (nested == 0) break block11;
                        state = EXPRESSION_STATE.CODE;
                    }
                }
                --pos;
            }
            start = pos;
            pos = offset;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            while (ch != -1 && (Character.isJavaIdentifierPart((char)(ch = scanner.read())) || (char)ch == '$')) {
                ++pos;
            }
            end = pos;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            return new Region(start, end - start);
        }
        return new Region(0, 0);
    }

    private static enum EXPRESSION_STATE {
        SL_COMMENT,
        LITERAL,
        LITERAL_START,
        LITERAL_END,
        CODE,
        DOT,
        WS_CODE,
        WS_DOT;

    }
}

