/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.actions;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class BaseRfAction
extends TextEditorAction {
    protected IEPluginConfig fPluginConfig;

    public BaseRfAction(ResourceBundle bundle, String prefix, ITextEditor editor, IEPluginConfig pluginConfig) {
        super(bundle, prefix, editor);
        this.fPluginConfig = pluginConfig;
    }

    protected List<RfNamedElementActionHyperlink> getRfNamedElementActionHyperlink(boolean allowMultiple) {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return null;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return null;
        }
        if (!(textEditor instanceof AbstractEEditor)) {
            return null;
        }
        int offset = ((AbstractEEditor)textEditor).getCursor();
        if (!(textEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)textEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return RfUtils.getRfNamedElementActionHyperlink(this.fPluginConfig, textEditor, project, document, offset, allowMultiple);
    }
}

