/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.actions;

import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.quickassist.EQuickAssistExtractMethodProcessor;

public class ERefactorExtractToMethodAction
extends TextEditorAction {
    public static final String EXTRACT_TO_METHOD = "Extract to method";
    public static final String EXTRACT_TO_TCM = "Extract to TCM";
    protected static final Pattern WS = Pattern.compile("\\R");
    protected ITextViewer fViewer;
    protected IEPluginConfig fPluginConfig;

    public ERefactorExtractToMethodAction(ResourceBundle bundle, String prefix, ITextEditor editor, IEPluginConfig pluginConfig) {
        super(bundle, prefix, editor);
        this.fPluginConfig = pluginConfig;
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null || !(textEditor instanceof DVTEditor)) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        this.fViewer = ((DVTEditor)textEditor).getTextViewer();
        if (this.fViewer.getSelectionProvider() == null) {
            return;
        }
        ISelection selection = this.fViewer.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            this.popEmptySelection();
            return;
        }
        String selectionText = ((ITextSelection)selection).getText();
        if (selectionText == null || selectionText.isEmpty()) {
            this.popEmptySelection();
            return;
        }
        EQuickAssistExtractMethodProcessor extractMethodProcessor = new EQuickAssistExtractMethodProcessor(this.fPluginConfig, this.fViewer, textEditor);
        DVTAbstractQuickAssistProposal[] proposals = extractMethodProcessor.getProposals(false);
        if (proposals == null || proposals.length == 0) {
            this.popUnsupportedElement(selectionText);
            return;
        }
        this.applyProposal((ICompletionProposal[])proposals, document);
    }

    protected void applyProposal(ICompletionProposal[] proposals, IDocument document) {
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (proposal.getDisplayString().equals(EXTRACT_TO_METHOD)) {
                proposal.apply(document);
            }
            ++n2;
        }
    }

    protected void popEmptySelection() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), EXTRACT_TO_METHOD, null, "Cannot perform extract to method on empty selection.\nPlease select a valid e-Language block of actions.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    protected void popUnsupportedElement(String selectionText) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), EXTRACT_TO_METHOD, null, "The operation is unavailable on the current selection: '" + DVTStringUtil.replaceAll((Pattern)WS, (CharSequence)selectionText, (String)" ") + "'\nPlease select a valid e-Language block of actions.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }
}

