/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.utils.GoToImportUtils;

public class GoToImportAction
extends TextEditorAction {
    private IEPluginConfig pluginConfig;

    public GoToImportAction(ResourceBundle bundle, String prefix, ITextEditor editor, IEPluginConfig pluginConfig) {
        super(bundle, prefix, editor);
        this.pluginConfig = pluginConfig;
    }

    public void run() {
        try {
            if (!(this.getTextEditor() instanceof DVTEditor)) {
                return;
            }
            DVTEditor dvtEditor = (DVTEditor)this.getTextEditor();
            if (dvtEditor == null) {
                return;
            }
            IProject project = dvtEditor.getProject();
            if (project == null) {
                return;
            }
            IResource resource = (IResource)dvtEditor.getAdapter(IResource.class);
            if (resource == null) {
                return;
            }
            GoToImportUtils.goToImport(this.pluginConfig, project, resource);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

