/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceAction;

public class ReferencesInWorkingSetAction
extends ReferencesInWorkspaceAction {
    private IWorkingSet[] fWorkingSets;

    public ReferencesInWorkingSetAction(ResourceBundle bundle, String prefix, ITextEditor editor, IEPluginConfig pluginConfig) {
        super(bundle, prefix, editor, pluginConfig);
    }

    @Override
    public ISearchQuery searchReferences(ITextEditor textEditor, IDocument document, int offset) {
        try {
            IWorkingSetManager manager;
            IWorkingSetSelectionDialog dialog;
            IWorkbenchWindow window = DVTPlugin.getActiveWorkbenchWindow();
            IWorkbenchPage page = null;
            if (window != null) {
                page = window.getActivePage();
            }
            if (page != null && (dialog = (manager = PlatformUI.getWorkbench().getWorkingSetManager()).createWorkingSetSelectionDialog(page.getWorkbenchWindow().getShell(), true)).open() == 0) {
                this.fWorkingSets = dialog.getSelection();
                if (this.fWorkingSets != null) {
                    return super.searchReferences(textEditor, document, offset);
                }
            }
            return null;
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    @Override
    protected FileTextSearchScope getSearchScope(String[] fileExtensions, ITextEditor textEditor) {
        return FileTextSearchScope.newSearchScope((IWorkingSet[])this.fWorkingSets, (String[])fileExtensions, (boolean)false);
    }
}

