/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceActionCommon;
import ro.amiq.edt.base.ui.search.ReferenceSearchPageInput;
import ro.amiq.edt.base.ui.search.SearchQueryProvider;

public class ReferencesInWorkspaceAction
extends ReferencesInWorkspaceActionCommon
implements IReferencesAction {
    protected IEPluginConfig fPluginConfig;

    public ReferencesInWorkspaceAction(ResourceBundle bundle, String prefix, ITextEditor editor, IEPluginConfig pluginConfig) {
        super(bundle, prefix, editor);
        this.fPluginConfig = pluginConfig;
    }

    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "The operation is unavailable on the current selection (the scope could not be determined). Please select another e Language element name or the same element from another location.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        this.searchReferences(textEditor, document, offset);
    }

    public ISearchQuery searchReferences(ITextEditor textEditor, IDocument document, int offset) {
        ISearchQuery result;
        block9: {
            block8: {
                RfProject rfProject;
                IProject project;
                block7: {
                    block6: {
                        try {
                            project = this.getProject(textEditor);
                            if (project != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.E_FAMILY_REPARSE);
                    rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
                    if (rfProject != null) break block7;
                    return null;
                }
                RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElementForSearch(rfProject, textEditor, document, offset, null);
                if (namedElementAndScope == null) break block8;
                RfNamedElement element = namedElementAndScope.getNamedElement();
                if (element != null) {
                    FileTextSearchScope searchScope = this.getSearchScope(ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject), textEditor);
                    result = ReferencesInWorkspaceAction.searchReferencesHelper(this.fPluginConfig, project, element, searchScope, RWSearchTypeEnum.USAGES);
                    break block9;
                }
                this.informationDialog();
                return null;
            }
            this.informationDialog();
            return null;
        }
        return result;
    }

    public static ISearchQuery searchReferencesHelper(IEPluginConfig pluginConfig, IProject project, RfNamedElement namedElement, FileTextSearchScope searchScope, RWSearchTypeEnum searchType) {
        try {
            ISearchQuery query;
            if (namedElement instanceof RfMacro && !((RfMacro)namedElement).isPreprocessing()) {
                TextSearchPageInput input = new TextSearchPageInput(((RfMacro)namedElement).getStringLiteral(), true, false, true, searchScope);
                query = new SearchQueryProvider(pluginConfig, 1, ReferencesInWorkspaceAction.getSearchTypeConstant(namedElement), false, true, searchType).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            } else if (namedElement instanceof RfStructQualifier) {
                RfEnum enumElement = ((RfStructQualifier)namedElement).getEnum();
                ReferenceSearchPageInput input = new ReferenceSearchPageInput(enumElement, true, false, true, searchScope);
                query = new SearchQueryProvider(pluginConfig, 1, ReferencesInWorkspaceAction.getSearchTypeConstant(enumElement), false, true, searchType).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            } else {
                ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, true, false, true, searchScope);
                query = new SearchQueryProvider(pluginConfig, 1, ReferencesInWorkspaceAction.getSearchTypeConstant(namedElement), false, true, searchType).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            }
            if (query != null) {
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
            return query;
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    protected FileTextSearchScope getSearchScope(String[] fileExtensions, ITextEditor textEditor) {
        return FileTextSearchScope.newWorkspaceScope((String[])fileExtensions, (boolean)false);
    }

    protected IProject getProject(ITextEditor textEditor) {
        IFile file = this.getFile(textEditor);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    protected IFile getFile(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        return file;
    }

    public ISearchQuery searchReferences(ITextEditor textEditor, IDocument document, int offset, boolean includeDeclarations) {
        return this.searchReferences(textEditor, document, offset);
    }
}

