/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.actions;

import java.util.Collections;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.diagrams.uml.EUMLHelper;
import ro.amiq.edt.base.diagrams.uml.model.EUMLModel;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.editor.actions.BaseRfAction;

public class ShowDiagramAction
extends BaseRfAction {
    public ShowDiagramAction(ResourceBundle bundle, String prefix, ITextEditor editor, IEPluginConfig pluginConfig) {
        super(bundle, prefix, editor, pluginConfig);
        this.setImageDescriptor(DVTImages.DIAGRAMS);
    }

    public void run() {
        try {
            IEditorInput editorInput = this.getTextEditor().getEditorInput();
            if (editorInput == null) {
                return;
            }
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            IProject project = file.getProject();
            if (project == null) {
                return;
            }
            IDocument document = this.getDocument(this.getTextEditor());
            if (document == null) {
                return;
            }
            int offset = ((DVTEditor)this.getTextEditor()).getCursor();
            RfProject rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            RfModule module = rfProject.getModule((IResource)file);
            if (module == null) {
                return;
            }
            RfWNamedElementAndScope element = RfUtils.getRfElement(rfProject, file, document, offset, false);
            if (element != null) {
                RfNamedElement namedElement = element.getNamedElement();
                IAdaptable diagramElement = null;
                if (namedElement instanceof RfSubtypeElement) {
                    Determinant determinant = ((RfSubtypeElement)namedElement).getSubtypeDeterminant();
                    RfStruct struct = ((RfSubtypeElement)namedElement).getStruct();
                    for (RfStructLayer layer : struct.getSubTypeLayers()) {
                        if (layer == null || !layer.getDeterminant().equals(determinant)) continue;
                        diagramElement = layer;
                    }
                } else {
                    diagramElement = namedElement;
                }
                if (EUMLModel.hasClassDiagram(diagramElement)) {
                    UMLDiagram diagram = EUMLHelper.INSTANCE.makeStructDiagramFor(Collections.singleton(diagramElement), project, this.fPluginConfig);
                    if (diagram == null) {
                        return;
                    }
                    EUMLHelper.INSTANCE.openUMLDiagramEditor(diagram);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IDocument getDocument(ITextEditor _editor) {
        if (_editor == null) {
            return null;
        }
        IDocumentProvider documentProvider = _editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IEditorInput editorInput = _editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return documentProvider.getDocument((Object)editorInput);
    }
}

