/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.edt.base.ui.search.constraints.InstancesSearchQuery;

public class ShowInstancesAction
extends ReferencesInWorkspaceAction
implements IBaseShowInstancesAction {
    public ShowInstancesAction(ResourceBundle bundle, String prefix, ITextEditor editor, IEPluginConfig pluginConfig) {
        super(bundle, prefix, editor, pluginConfig);
        this.setText("Instances");
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    @Override
    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nPlease select an unit to use Show Instances.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    @Override
    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.E_FAMILY_REPARSE);
        RfProject rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.findNamedElementAndShowInstances(rfProject, textEditor, document, offset);
    }

    public ISearchQuery showInstancesTest(ITextEditor textEditor, IDocument document, int offset) {
        RfProject rfProject;
        block7: {
            IProject project;
            block6: {
                IResource resouce;
                block5: {
                    try {
                        resouce = (IResource)textEditor.getAdapter(IResource.class);
                        if (resouce != null) break block5;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                project = resouce.getProject();
                if (project != null) break block6;
                return null;
            }
            DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.E_FAMILY_REPARSE);
            rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
            if (rfProject != null) break block7;
            return null;
        }
        return this.findNamedElementAndShowInstances(rfProject, textEditor, document, offset);
    }

    private ISearchQuery findNamedElementAndShowInstances(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset) {
        IRfNamedElement namedElement = null;
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset, false);
        if (namedElementAndScope != null) {
            namedElement = namedElementAndScope.getIRfNamedElement();
        }
        if (namedElement == null) {
            this.informationDialog();
            return null;
        }
        if (!(namedElement instanceof RfStruct) || !((RfStruct)namedElement).isUnit()) {
            this.informationDialog();
            return null;
        }
        return ShowInstancesAction.showInstances(namedElement);
    }

    public static ISearchQuery showInstances(IRfNamedElement element) {
        InstancesSearchQuery query = new InstancesSearchQuery(element);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return query;
    }
}

