/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.r2lparser.R2LBusy;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistProcessorManagerCommon;
import ro.amiq.edt.base.ui.editor.contentassist.EKeyphraseContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.EKeywordContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.EParameterHintsUtils;
import ro.amiq.edt.base.ui.editor.contentassist.ETemplateContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.edt.base.ui.editor.contentassist.RfLazyCompletionProposal;

public class EContentAssistProcessorManager
extends EContentAssistProcessorManagerCommon {
    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public EContentAssistProcessorManager(IEPluginConfig pluginConfig, AbstractEEditor editor, ContentAssistant assistant) {
        super(pluginConfig, editor, assistant);
    }

    @Override
    public IFile getFile() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        return file;
    }

    public int getNofProcessors() {
        return 3;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] nonUiComputeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            IFile file;
            if (this.fEditor == null) {
                return null;
            }
            if (!this.init(viewer.getDocument(), offset)) {
                return null;
            }
            boolean isTemplateProposalInComment = ((IDocumentExtension3)this.fDocument).getContentType("__e_partitioning", offset, false).equals("__e_ml_comment");
            this.fContextType = isTemplateProposalInComment ? "ro.amiq.edt.templates.contextType.file_content" : (this.fInitialScope != null ? this.fInitialScope.getContextType() : "ro.amiq.edt.templates.contextType.statement");
            if (!isTemplateProposalInComment) {
                if (offset == this.getPrevOffset()) {
                    int crtContentAssistPage = this.getCrtContentAssistPage();
                    switch (IDVTContentAssistConstants.ELangContentAssistProposalsPage.from((int)crtContentAssistPage)) {
                        case DEFAULT: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
                            break;
                        }
                        case TEMPLATES: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show AI Assistant proposals");
                            for (IContentAssistProcessor processor : this.fProcessors) {
                                if (this.fRfProject.isInSDLMode() && (processor instanceof ETemplateContentAssistProcessor || processor instanceof EKeywordContentAssistProcessor || processor instanceof EKeyphraseContentAssistProcessor) || !(processor instanceof TemplateCompletionProcessor)) continue;
                                ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset);
                                if (proposals == null || proposals.length == 0) {
                                    proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                                }
                                return proposals;
                            }
                            return null;
                        }
                        case AI_ASSISTANT: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Default proposals");
                            IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
                            if (aiHostContributor == null) {
                                return null;
                            }
                            for (IContentAssistProcessor processor : this.fProcessors) {
                                if (!aiHostContributor.isAICodeCompletionProcessorAndListener(processor)) continue;
                                ICompletionProposal[] proposals = aiHostContributor.computeCompletionProposalsForAIAssistantPage(processor, viewer, offset);
                                if (proposals == null || proposals.length == 0) {
                                    proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                                }
                                return proposals;
                            }
                            return null;
                        }
                    }
                } else {
                    this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
                }
            }
            if ((file = this.getFile()) == null || this.fRfProject == null) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (IContentAssistProcessor processor : this.fProcessors) {
                    ICompletionProposal[] computeCompletionProposals;
                    if (!DVTUtilsCommon.INSTANCE.isInSDLMode((IPluginConfig)this.fPluginConfig) || !(processor instanceof ETemplateContentAssistProcessor) && !(processor instanceof EKeywordContentAssistProcessor) && !(processor instanceof EKeyphraseContentAssistProcessor) || (computeCompletionProposals = processor.computeCompletionProposals(viewer, offset)) == null) continue;
                    proposals.addAll(Arrays.asList(computeCompletionProposals));
                }
                if (proposals.isEmpty()) {
                    proposals.add(this.getNoProposal(viewer, offset));
                }
                return this.getProposalArray(proposals);
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            boolean isNoProposal = false;
            for (IContentAssistProcessor processor : this.fProcessors) {
                if (this.fRfProject.isInSDLMode() && (processor instanceof ETemplateContentAssistProcessor || processor instanceof EKeywordContentAssistProcessor || processor instanceof EKeyphraseContentAssistProcessor)) continue;
                ICompletionProposal[] computeCompletionProposals = processor.computeCompletionProposals(viewer, offset);
                if (computeCompletionProposals != null) {
                    proposals.addAll(Arrays.asList(computeCompletionProposals));
                }
                if (!(processor instanceof RfContentAssistProcessor)) continue;
                if (!((RfContentAssistProcessor)processor).fAllowProposals) break;
                if (proposals.isEmpty() || !(proposals.get(0) instanceof RfLazyCompletionProposal) || !((RfLazyCompletionProposal)proposals.get(0)).isNoProposal()) continue;
                isNoProposal = true;
            }
            if (isNoProposal && proposals.size() > 1) {
                proposals.remove(0);
            }
            if (proposals.isEmpty()) {
                proposals.add(this.getNoProposal(viewer, offset));
            }
            return this.getProposalArray(proposals);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        try {
            if (!this.init(viewer.getDocument(), offset)) {
                return null;
            }
            if (!(this.fInitialScope instanceof RfDefElement)) {
                return null;
            }
            IRegion startRegion = this.fDocument.getLineInformationOfOffset(((RfDefElement)((Object)this.fInitialScope)).getStartOffset());
            RfNamedElement element = EParameterHintsUtils.getFunctionNamedElementAtOffset(this.fRfProject, this.getFile(), this.fEditor, offset, startRegion.getOffset());
            if (element == null) {
                return null;
            }
            String argsString = null;
            String elementName = element.getName();
            List<String> sdlParamNames = null;
            if (element instanceof RfMethod) {
                if (this.fInitialScope.equals(element.getDeclaration())) {
                    return null;
                }
                argsString = ((RfMethod)element).getArgs();
            } else if (this.fRfProject.isInSDLMode() && element instanceof RfStruct && ((RfStruct)element).isSDLScenario()) {
                argsString = ((RfStruct)element).getSDLParamsAsString();
                sdlParamNames = ((RfStruct)element).getSDLParamNames();
            }
            if (elementName == null || argsString == null || argsString.isEmpty()) {
                return null;
            }
            int contextInformationStartOffset = EParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, false, false);
            if (contextInformationStartOffset < 0) {
                return null;
            }
            int contextInformationEndOffset = EParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, true, false) - 1;
            if (contextInformationEndOffset < 0) {
                return null;
            }
            String wrapped = DVTStringUtil.textWrap((int)75, (String)argsString).toString();
            String tooltip = DVTStringUtil.breakLongNonWhitespaceSequences((String)wrapped, (int)75, (char)'\n');
            DVTProposalContextInformation contextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, tooltip, tooltip, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__e_partitioning");
            contextInformation.setSdlParamNames(sdlParamNames);
            IContextInformation[] contextInformations = new IContextInformation[]{contextInformation};
            return contextInformations;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    protected ICompletionProposal getBusyProposal(ITextViewer viewer, int fOffset) {
        return new RfLazyCompletionProposal(viewer, this.fInitialScope, new R2LBusy(), "", fOffset, false, null, -1, true, this.fPluginConfig);
    }

    public String getContextType() {
        return this.fContextType;
    }
}

