/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.r2lparser.R2LNoProposalElement;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.contentassist.EParameterListValidator;
import ro.amiq.edt.base.ui.editor.contentassist.RfLazyCompletionProposal;

public abstract class EContentAssistProcessorManagerCommon
extends DVTContentAssistProcessorManager {
    protected List<IContentAssistProcessor> fProcessors = new ArrayList<IContentAssistProcessor>();
    protected ContentAssistant fContentAssistant;
    protected IRfScope fInitialScope;
    protected IDocument fDocument;
    protected AbstractEEditor fEditor;
    protected RfProject fRfProject;
    private int fLine;
    protected String fContextType;
    private String fModulePackageName;
    protected boolean fAlreadyComputed;
    protected IEPluginConfig fPluginConfig;
    public static final Comparator<ICompletionProposal> fLexicalSorter = (o1, o2) -> o1.getDisplayString().compareTo(o2.getDisplayString());

    protected EContentAssistProcessorManagerCommon(IEPluginConfig pluginConfig, AbstractEEditor editor, ContentAssistant assistant) {
        this.fContentAssistant = assistant;
        this.fEditor = editor;
        this.fPluginConfig = pluginConfig;
    }

    public IEPluginConfig getPluginConfig() {
        return this.fPluginConfig;
    }

    public void addContentAssistProcessor(IContentAssistProcessor processor) {
        this.fProcessors.add(processor);
    }

    public int getLine() {
        return this.fLine;
    }

    public IRfScope getInitialScope() {
        return this.fInitialScope;
    }

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public AbstractEEditor getEditor() {
        return this.fEditor;
    }

    public List<IContentAssistProcessor> getProcessors() {
        return this.fProcessors;
    }

    public boolean init(IDocument document, int offset) {
        block7: {
            RfModule module;
            IProject project;
            IFile fFile;
            block9: {
                block8: {
                    block6: {
                        if (this.fAlreadyComputed) {
                            return true;
                        }
                        try {
                            this.fDocument = document;
                            if (this.fDocument != null) break block6;
                            return false;
                        }
                        catch (BadLocationException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return false;
                        }
                    }
                    this.fLine = this.fDocument.getLineOfOffset(offset) + 1;
                    if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) break block7;
                    fFile = this.getFile();
                    if (fFile != null) break block8;
                    return false;
                }
                project = fFile.getProject();
                if (project == null) break block7;
                if (DVTPlugin.getDefault().collect().c(project, this.fPluginConfig.feature())) break block9;
                return false;
            }
            this.fRfProject = this.fPluginConfig.getRfManager().getRfProject(project);
            if (this.fRfProject == null || (module = this.fRfProject.getModule((IResource)fFile)) == null) break block7;
            this.fInitialScope = module.getScope(this.fLine, offset);
            this.fModulePackageName = module.getPackageName();
        }
        return true;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new EParameterListValidator();
    }

    protected ICompletionProposal[] getProposalArray(List<ICompletionProposal> proposals) {
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public String getPackageName() {
        return this.fModulePackageName;
    }

    public int getTabWidth() {
        return this.fEditor.getTabWidth();
    }

    public ICompletionProposal getNoProposal(ITextViewer viewer, int fOffset) {
        return new RfLazyCompletionProposal(viewer, this.fInitialScope, new R2LNoProposalElement(), "", fOffset, false, null, -1, true, this.fPluginConfig);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPluginConfig.getPlugin().getPreferenceStore();
    }

    public abstract IFile getFile();
}

