/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistProcessorManager;
import ro.amiq.edt.base.ui.preferences.PrefConst;

public class EKeyphraseContentAssistProcessor
implements IContentAssistProcessor {
    private static final Set<String> SEMICOLON_ENEDED_KEYPHRASES = new HashSet<String>(Arrays.asList("is empty", "is undefined", "is imported"));
    private EContentAssistProcessorManager fProcessor;
    public static final Comparator<ICompletionProposal> fLexicalSorter = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
    };

    public EKeyphraseContentAssistProcessor(EContentAssistProcessorManager ecamgr) {
        this.fProcessor = ecamgr;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            IDocument document = viewer.getDocument();
            int max_phrase_size = PrefConst.getMaxPhraseLength(this.fProcessor.getPluginConfig().getPlugin(), DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)this.fProcessor.getPluginConfig()));
            ArrayList<String> phrases = this.getPhrasesList(document, offset, max_phrase_size);
            ArrayList<ICompletionProposal> proposals = this.getProposals(offset, phrases);
            ICompletionProposal[] complProposals = new ICompletionProposal[proposals.size()];
            proposals.toArray(complProposals);
            Arrays.sort(complProposals, fLexicalSorter);
            return complProposals;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ArrayList<String> getPhrasesList(IDocument document, int offset, int maxSize) {
        ArrayList<String> phrases = new ArrayList<String>();
        try {
            int n = offset;
            if (n >= document.getLength()) {
                return phrases;
            }
            if (n <= 0 || n >= document.getLength() || document.getChar(n) != document.getChar(n - 1) || document.getChar(n) != '\n') {
                while (--n >= 0 && n + maxSize >= offset && document.getChar(n) != '\n') {
                }
                if (n < 0) {
                    n = 0;
                }
                String phrases_space = document.get(n + 1, offset - n);
                int i = 0;
                if (document.getChar(n) != '\n') {
                    i = 0;
                    while (i < phrases_space.length() && Character.isJavaIdentifierPart(phrases_space.charAt(i))) {
                        phrases_space = phrases_space.substring(i);
                        ++i;
                    }
                }
                i = phrases_space.length() - 1;
                while (i >= 0) {
                    String sub_phrase;
                    if (!(phrases_space.charAt(i) == '\n' || Character.isJavaIdentifierPart(phrases_space.charAt(i)) && i != 0 || (sub_phrase = phrases_space.substring(i, phrases_space.length() - 1).trim()).length() <= 0)) {
                        phrases.add(sub_phrase);
                    }
                    --i;
                }
            }
            if (phrases.isEmpty()) {
                phrases.add("");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return phrases;
    }

    private ArrayList<ICompletionProposal> getProposals(int offset, ArrayList<String> currentPhrases) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (this.fProcessor.getInitialScope() == null) {
            return result;
        }
        String[] keyphrases = null;
        boolean isSLN = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)this.fProcessor.getPluginConfig());
        AbstractUIPlugin plugin = this.fProcessor.getPluginConfig().getPlugin();
        if (this.fProcessor.getContextType().equals("ro.amiq.edt.templates.contextType.statement")) {
            keyphrases = PrefConst.getPhrases(plugin, "Statements");
        } else if (this.fProcessor.getContextType().equals("ro.amiq.edt.templates.contextType.struct_member")) {
            keyphrases = this.checkForAllowTypes(currentPhrases) ? PrefConst.getPhrases(plugin, "Types") : PrefConst.getPhrases(plugin, "Struct Members");
        } else if (this.fProcessor.getContextType().equals("ro.amiq.edt.templates.contextType.action")) {
            if (!isSLN) {
                keyphrases = PrefConst.getPhrases(plugin, "Actions");
            } else {
                String res = plugin.getPreferenceStore().getString("e.language.keyphrases.actions");
                res = String.valueOf(res) + plugin.getPreferenceStore().getString("sln.language.keyphrases.scenario_construction_directives");
                keyphrases = res.split(";");
            }
        }
        if (keyphrases == null) {
            return result;
        }
        HashSet<String> keyphrasesSet = new HashSet<String>();
        String[] stringArray = keyphrases;
        int n = keyphrases.length;
        int n2 = 0;
        while (n2 < n) {
            String keyphrase = stringArray[n2];
            keyphrasesSet.add(keyphrase);
            ++n2;
        }
        for (String keyphrase : keyphrasesSet) {
            boolean added = false;
            int j = 0;
            while (j < currentPhrases.size() && !added) {
                String currentWord = currentPhrases.get(j);
                if (currentWord.length() == 0 || keyphrase.startsWith(currentWord) && !keyphrase.equals(currentWord)) {
                    if (!SEMICOLON_ENEDED_KEYPHRASES.contains(keyphrase)) {
                        keyphrase = DVTStringUtil.appendString((Object[])new Object[]{keyphrase, " "});
                    }
                    result.add((ICompletionProposal)new CompletionProposal(keyphrase, offset - currentWord.length(), currentWord.length(), keyphrase.length(), DVTImages.imageCache.getImage(DVTImages.KEYWORD_OBJ), keyphrase, null, "Keyphrase"));
                    added = true;
                }
                ++j;
            }
        }
        return result;
    }

    private boolean checkForAllowTypes(ArrayList<String> currentPhrases) {
        if (currentPhrases == null) {
            return false;
        }
        for (String currentWord : currentPhrases) {
            if (currentWord.indexOf(58) < 0) continue;
            return true;
        }
        return false;
    }
}

