/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistProcessorManager;
import ro.amiq.edt.base.ui.preferences.PrefConst;

public class EKeywordContentAssistProcessor
implements IContentAssistProcessor {
    private static final Set<String> SEMICOLON_ENEDED_KEYWORDS = new HashSet<String>(Arrays.asList("continue", "break", "empty"));
    private EContentAssistProcessorManager fProcessor;

    public EKeywordContentAssistProcessor(EContentAssistProcessorManager ecamgr) {
        this.fProcessor = ecamgr;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        List<ICompletionProposal> proposals;
        block3: {
            try {
                proposals = this.getProposals(viewer, offset);
                if (proposals != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        ICompletionProposal[] complProposals = proposals.toArray(new ICompletionProposal[proposals.size()]);
        Arrays.sort(complProposals, EContentAssistProcessorManager.fLexicalSorter);
        return complProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private List<ICompletionProposal> getProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (this.fProcessor.getInitialScope() == null) {
            return result;
        }
        String[] keywords = null;
        boolean isSLN = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)this.fProcessor.getPluginConfig());
        AbstractUIPlugin plugin = this.fProcessor.getPluginConfig().getPlugin();
        if (this.fProcessor.getContextType().equals("ro.amiq.edt.templates.contextType.statement")) {
            keywords = PrefConst.getKeywords(plugin, "Statements");
        } else if (this.fProcessor.getContextType().equals("ro.amiq.edt.templates.contextType.struct_member")) {
            keywords = PrefConst.getKeywords(plugin, "Struct Members");
        } else if (this.fProcessor.getContextType().equals("ro.amiq.edt.templates.contextType.action")) {
            if (!isSLN) {
                keywords = PrefConst.getKeywords(plugin, "Actions");
            } else {
                String res = plugin.getPreferenceStore().getString("e.language.keywords.actions");
                res = String.valueOf(res) + plugin.getPreferenceStore().getString("sln.language.keywords.scenario_construction_directives");
                keywords = res.split(";");
            }
        }
        if (keywords == null) {
            return result;
        }
        IDocument document = viewer.getDocument();
        String currentWord = this.lastWord(document, offset);
        if (currentWord == null || currentWord.length() == 0) {
            return null;
        }
        HashSet<String> keywordsSet = new HashSet<String>();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            keywordsSet.add(keyword);
            ++n2;
        }
        for (String keyword : keywordsSet) {
            if (currentWord.length() != 0 && (!keyword.startsWith(currentWord) || keyword.equals(currentWord))) continue;
            if (!SEMICOLON_ENEDED_KEYWORDS.contains(keyword)) {
                keyword = String.valueOf(keyword) + " ";
            }
            result.add((ICompletionProposal)new CompletionProposal(keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), DVTImages.imageCache.getImage(DVTImages.KEYWORD_OBJ), keyword, null, "Keyword"));
        }
        return result;
    }

    private String lastWord(IDocument doc, int offset) {
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (!Character.isJavaIdentifierPart(c)) {
                    return doc.get(n + 1, offset - n - 1);
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "";
    }
}

