/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.util.ArrayDeque;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.EWordFinder;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtil;

public class EParameterHintsUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getContextInformationOffset(IDocument document, int triggerOffset, IRfScope initialScope, String functionName, DVTEditor editor, boolean endOffset, boolean isApplyProposal) {
        int rightBracketOffset;
        block14: {
            int leftBracketOffset;
            int scopeEndOffset;
            block13: {
                int functionNameOffset;
                int scopeStartOffset;
                block12: {
                    char nextChar;
                    block11: {
                        String wordAtOffset;
                        block10: {
                            if (initialScope instanceof RfDefElement) break block10;
                            return -1;
                        }
                        if (functionName.isEmpty()) {
                            return triggerOffset;
                        }
                        scopeStartOffset = document.getLineInformationOfOffset(((RfDefElement)((Object)initialScope)).getStartOffset()).getOffset();
                        IRegion scopeInfo = document.getLineInformationOfOffset(((RfDefElement)((Object)initialScope)).getEndOffset());
                        scopeEndOffset = scopeInfo.getOffset() + scopeInfo.getLength();
                        functionNameOffset = -1;
                        EWordFinder eWordFinder = new EWordFinder();
                        IRegion wordAtOffsetRegion = eWordFinder.getWordAtOffset(document, triggerOffset);
                        if (wordAtOffsetRegion != null && (wordAtOffset = document.get(wordAtOffsetRegion.getOffset(), wordAtOffsetRegion.getLength())).equals(functionName)) {
                            functionNameOffset = wordAtOffsetRegion.getOffset() + wordAtOffsetRegion.getLength();
                        }
                        if (functionNameOffset < 0) {
                            functionNameOffset = EQuickFixUtil.getBackwardOffsetFor(document, functionName, scopeStartOffset, triggerOffset, false) + functionName.length();
                        }
                        if (functionNameOffset > scopeStartOffset) break block11;
                        return -1;
                    }
                    if (isApplyProposal || (nextChar = DVTDocumentUtils.nextCodeChar((IDocument)document, (int)functionNameOffset, (String)"__e_partitioning", (boolean)true)) == '(') break block12;
                    return -1;
                }
                leftBracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)functionNameOffset, (boolean)true, (int)100, (IDocument)document, (String)"__e_partitioning") + 1;
                if (leftBracketOffset <= scopeEndOffset && leftBracketOffset >= scopeStartOffset) break block13;
                return -1;
            }
            if (!endOffset) return leftBracketOffset;
            rightBracketOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)leftBracketOffset, (DVTEditor)editor, (IDocument)document);
            if (rightBracketOffset >= 0 && rightBracketOffset <= scopeEndOffset) break block14;
            return -1;
        }
        try {
            return rightBracketOffset;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RfNamedElement getFunctionNamedElementAtOffset(RfProject rfProject, IFile file, AbstractEEditor editor, int offset, int minLimit) {
        try {
            IDocument document = editor.getDocument();
            if (document == null) return null;
            if (offset < 0) return null;
            if (offset >= document.getLength()) {
                return null;
            }
            if (document.getChar(offset) == ')') {
                if ((offset = DVTDocumentUtils.getMatchingLeftBracketOffset((int)offset, (DVTEditor)editor, (IDocument)document) - 1) < 0) {
                    return null;
                }
            } else {
                ArrayDeque<Character> closedBracketsStack = new ArrayDeque<Character>();
                while (offset >= minLimit) {
                    char chr = document.getChar(offset);
                    if (chr == ')') {
                        closedBracketsStack.push(Character.valueOf(chr));
                    } else if (chr == '(') {
                        if (closedBracketsStack.isEmpty()) {
                            Object[] nextCodeOffsetPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)(offset - 1), (boolean)false, (String)"__e_partitioning");
                            if (nextCodeOffsetPair != null) {
                                char nextCode = ((Character)nextCodeOffsetPair[0]).charValue();
                                int nextCodeOffset = (Integer)nextCodeOffsetPair[1];
                                if (Character.isJavaIdentifierPart(nextCode)) {
                                    offset = nextCodeOffset;
                                    break;
                                }
                            }
                        } else {
                            closedBracketsStack.pop();
                        }
                    }
                    --offset;
                }
            }
            if (offset <= minLimit) {
                return null;
            }
            int functionNameEndOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)offset, (boolean)false, (String)"__e_partitioning");
            if (functionNameEndOffset < 0) {
                return null;
            }
            RfWNamedElementAndScope rfElementAndScope = RfUtils.getRfElement(rfProject, file, document, offset, false);
            if (rfElementAndScope != null) return rfElementAndScope.getNamedElement();
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

