/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfiguration;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistProcessorManager;

public class ETemplateContentAssistProcessor
extends TemplateCompletionProcessor {
    private static final String EDT_CODE_TEMPLATES = "edt_code_templates.xml";
    private static final String SLNDT_CODE_TEMPLATES = "sln_code_templates.xml";
    private static final String SDLDT_CODE_TEMPLATES = "sdl_code_templates.xml";
    private EContentAssistProcessorManager fProcessor;
    private TextEditor fEditor;
    private IEPluginConfig fPluginConfig;
    private static final Comparator<ICompletionProposal> fgProposalComparator = new ProposalComparator();
    private boolean fCA = false;
    private int fOffset;

    public ETemplateContentAssistProcessor(IEPluginConfig pluginConfig, TextEditor editor, EContentAssistProcessorManager ecamgr) {
        this.fProcessor = ecamgr;
        this.fEditor = editor;
        this.fPluginConfig = pluginConfig;
    }

    protected int getRelevance(Template template, String prefix) {
        if (template.getPattern().toLowerCase().startsWith(prefix.toLowerCase())) {
            return 1;
        }
        return 0;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return this.fPluginConfig.getTemplateEditor().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return this.fPluginConfig.getTemplateEditor().getContextTypeRegistry().getContextType(this.fProcessor.getContextType());
    }

    protected Image getImage(Template template) {
        return DVTImages.imageCache.getImage(DVTImages.TEMPLATE_OBJ);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        block10: {
            if (!this.fCA || this.fOffset + 1 != offset) break block10;
            this.fCA = false;
            this.fOffset = offset;
            char c = viewer.getDocument().getChar(Math.max(0, offset - 1));
            if (Character.isJavaIdentifierPart(c) || c == '#') break block10;
            return null;
        }
        try {
            String prefix;
            Region region;
            TemplateContext context;
            this.fOffset = offset;
            this.fCA = false;
            ITextSelection selection = this.fProcessor.nonUiGetSelection(viewer);
            if (selection != null && selection.getOffset() == offset) {
                offset = selection.getOffset() + selection.getLength();
            }
            if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())))) == null) {
                return new ICompletionProposal[0];
            }
            if (selection != null) {
                context.setVariable("selection", selection.getText());
            }
            Template[] templates = this.getTemplates(context.getContextType().getId());
            Template[] projectTemplates = this.getProjectTemplates();
            ArrayList<Template> allTemplates = new ArrayList<Template>();
            allTemplates.addAll(Arrays.asList(projectTemplates));
            allTemplates.addAll(Arrays.asList(templates));
            ArrayList<CustomTemplateProposal> matches = new ArrayList<CustomTemplateProposal>();
            for (Template template : allTemplates) {
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    continue;
                }
                if (!template.matches(prefix, context.getContextType().getId()) && !template.matches(prefix, "ro.amiq.edt.templates.contextType.unknown")) continue;
                matches.add(this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
            }
            Collections.sort(matches, fgProposalComparator);
            boolean ignoreCase = this.fPluginConfig.getPlugin().getPreferenceStore().getBoolean("ca.ignore_case");
            boolean camelCase = this.fPluginConfig.getPlugin().getPreferenceStore().getBoolean("ca.camel_case");
            boolean prefixMatch = this.fPluginConfig.getPlugin().getPreferenceStore().getBoolean("ca.prefix_match");
            int matchType = 0x20 | (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
            ArrayList<CustomTemplateProposal> proposals = new ArrayList<CustomTemplateProposal>();
            for (CustomTemplateProposal match : matches) {
                String templateName = match.getTemplateName().toLowerCase();
                if (!DVTStringUtil.regionMatches((String)(templateName = templateName.replace(' ', '_')), (String)prefix.toLowerCase(), (int)matchType)) continue;
                proposals.add(match);
            }
            this.fCA = true;
            return proposals.toArray(new ICompletionProposal[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected CustomTemplateProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new CustomTemplateProposal(this.fPluginConfig, template, context, region, this.getImage(template), relevance);
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while (Character.isJavaIdentifierPart(ch = document.getChar(i - 1))) {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    protected IProject getProject() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return project;
    }

    private File getProjectTemplatesFile() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        if (this.fEditor instanceof AbstractEEditor) {
            IEPluginConfig pluginConfig = ((AbstractEEditor)this.fEditor).getPluginConfig();
            if (DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)pluginConfig)) {
                return project.getLocation().append(".dvt").append(SLNDT_CODE_TEMPLATES).toFile();
            }
            if (DVTUtilsCommon.INSTANCE.isInSDLMode((IPluginConfig)pluginConfig)) {
                return project.getLocation().append(".dvt").append(SDLDT_CODE_TEMPLATES).toFile();
            }
        }
        return project.getLocation().append(".dvt").append(EDT_CODE_TEMPLATES).toFile();
    }

    private Template[] getProjectTemplates() {
        File file = this.getProjectTemplatesFile();
        if (file == null || !file.exists()) {
            return new Template[0];
        }
        Template[] result = this.getTemplatesFromFile(file);
        if (result == null) {
            return new Template[0];
        }
        return result;
    }

    private Template[] getTemplatesFromFile(File file) {
        TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
        TemplatePersistenceData[] templatePersistenceData = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader fileReader = new BufferedReader(new FileReader(file));){
                templatePersistenceData = templateReaderWriter.read((Reader)fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (templatePersistenceData == null) {
            return null;
        }
        ArrayList<Template> result = new ArrayList<Template>();
        TemplatePersistenceData[] templatePersistenceDataArray = templatePersistenceData;
        int n = templatePersistenceData.length;
        int n2 = 0;
        while (n2 < n) {
            TemplatePersistenceData tpd = templatePersistenceDataArray[n2];
            if (tpd.isEnabled() && !tpd.isDeleted()) {
                result.add(tpd.getTemplate());
            }
            ++n2;
        }
        return result.toArray(new Template[result.size()]);
    }

    static class CustomTemplateProposal
    extends TemplateProposal
    implements ICompletionProposalExtension4,
    ICompletionProposalExtension6 {
        private IEPluginConfig pluginConfig;

        public CustomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
            super(template, context, region, image, relevance);
        }

        public CustomTemplateProposal(IEPluginConfig pluginConfig, Template template, TemplateContext context, IRegion region, Image image, int relevance) {
            super(template, context, region, image);
            this.pluginConfig = pluginConfig;
        }

        public String getAdditionalProposalInfo() {
            String additionalProposalInfo = super.getAdditionalProposalInfo();
            if (CommentUtils.getInstance().shouldUseOldTooltip()) {
                return additionalProposalInfo.replace("\n", "<br>");
            }
            if (additionalProposalInfo.trim().isEmpty()) {
                return "";
            }
            return DVTStringUtil.appendString((Object[])new Object[]{"<pre class=\"template\">", additionalProposalInfo.replace("<", "&lt;").replace(">", "&gt;"), "</pre>"});
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            try {
                DVTFileModificationValidator.validateEdit((ITextViewer)viewer);
                String formattedPattern = this.formatReplacementString(viewer, offset);
                this.getTemplate().setPattern(formattedPattern);
                super.apply(viewer, trigger, stateMask, offset);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        private String formatReplacementString(ITextViewer viewer, int offset) {
            String pattern = this.getTemplate().getPattern();
            try {
                String replacementString;
                String result;
                IDocument d = viewer.getDocument();
                int line = d.getLineOfOffset(offset);
                String indent = DVTDocumentCommon.getIndentOfLine((IDocument)d, (int)line, (int)offset);
                if (indent == null) {
                    indent = "";
                }
                if ((result = Utils.formatString(() -> new ESourceViewerConfiguration(this.pluginConfig, null), (String)(replacementString = pattern.trim()), (IDocument)d, (String)indent, (boolean)true)) == null) {
                    result = replacementString;
                }
                result = result.trim();
                return result;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return pattern;
            }
        }

        public String getTemplateName() {
            return super.getTemplate().getName();
        }

        public boolean isAutoInsertable() {
            return this.getTemplate().isAutoInsertable();
        }

        public StyledString getStyledDisplayString() {
            StyledString displayString = new StyledString(this.getTemplateName());
            String templateDescription = this.getTemplate().getDescription();
            if (templateDescription != null && !templateDescription.isEmpty()) {
                displayString.append(new StyledString(" - " + templateDescription, StyledString.QUALIFIER_STYLER));
            }
            return displayString;
        }
    }

    private static final class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
        }
    }
}

