/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.contentasisst.IRfContentAssistProcessor;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.r2lparser.R2LManager;
import ro.amiq.edt.base.r2lparser.R2LProposalManager;
import ro.amiq.edt.base.r2lparser.R2LResultContainer;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistProcessorManager;
import ro.amiq.edt.base.ui.editor.contentassist.RfLazyCompletionProposal;

public class RfContentAssistProcessor
implements IRfContentAssistProcessor,
IContentAssistProcessor {
    private EContentAssistProcessorManager fProcessor;
    protected boolean fAllowProposals;
    private IEPluginConfig fPluginConfig;
    private final boolean fIsInSLNMode;

    public RfContentAssistProcessor(IEPluginConfig pluginConfig, EContentAssistProcessorManager processor) {
        this.fProcessor = processor;
        this.fPluginConfig = pluginConfig;
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    public EContentAssistProcessorManager getProcessor() {
        return this.fProcessor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals;
        block7: {
            block6: {
                RfProject rfProject;
                block5: {
                    try {
                        rfProject = this.fProcessor.getRfProject();
                        if (rfProject != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                if (DVTPlugin.getDefault().collect().c(rfProject.getProject(), this.fPluginConfig.feature())) break block6;
                return null;
            }
            proposals = this.getProposals(viewer, offset);
            if (proposals != null) break block7;
            return null;
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ICompletionProposal[] getProposals(ITextViewer viewer, int offset) {
        File[] fileCandidates;
        IRfNamedElement[] candidates;
        R2LResultContainer container;
        block16: {
            block15: {
                block14: {
                    ParserPath parserPath;
                    IDocument document;
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    try {
                                        if (!this.fProcessor.isCanceled()) break block10;
                                        return null;
                                    }
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        return null;
                                    }
                                }
                                document = viewer.getDocument();
                                if (document != null) break block11;
                                return null;
                            }
                            IFile file = this.fProcessor.getFile();
                            parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
                            if (parserPath != null) break block12;
                            return null;
                        }
                        if (!this.fProcessor.isCanceled()) break block13;
                        return null;
                    }
                    R2LProposalManager manager = new R2LProposalManager(this.fPluginConfig, this.fProcessor.getRfProject(), this.fProcessor.getInitialScope(), this.fProcessor.getPackageName(), parserPath, document, offset, this.fProcessor.getLine());
                    container = ((R2LManager)manager).getProposals();
                    if (container != null) break block14;
                    return null;
                }
                if (!this.fProcessor.isCanceled()) break block15;
                return null;
            }
            candidates = container.candidates;
            fileCandidates = container.fileCandidates;
            this.fAllowProposals = container.allowProposals();
            if (!this.fProcessor.isCanceled()) break block16;
            return null;
        }
        if (fileCandidates != null) {
            return this.getIncludeProposals(viewer, fileCandidates, offset, container.prefix, container.multipleImports);
        }
        return this.getCompletionProposals(viewer, candidates, container.prefix, offset, container.isAtStructLayer, container.rule, this.fProcessor.getInitialScope());
    }

    private ICompletionProposal[] getIncludeProposals(ITextViewer viewer, File[] files, int offset, String prefix, boolean multipleImports) {
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        if (prefix == null) {
            prefix = "";
        }
        String replacementStringPrefix = prefix.contains(File.separator) ? prefix.replaceFirst(String.valueOf(File.separator) + "[^" + File.separator + "]*$", File.separator) : "";
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file == R2LProposalManager.DUMMY_TIMEOUT_FILE) {
                result.add(0, new CompletionProposal(viewer, prefix, offset - prefix.length(), prefix.length(), prefix.length(), DVTImages.imageCache.getImage(DVTImages.INFORMATION), "The time needed for this task exceeds 2000 ms.", null, "For performance reasons, only showing a limited set of results...", false));
            } else if (file == R2LProposalManager.DUMMY_NUMBER_FILE) {
                result.add(0, new CompletionProposal(viewer, prefix, offset - prefix.length(), prefix.length(), prefix.length(), DVTImages.imageCache.getImage(DVTImages.INFORMATION), "Only showing 20 entries per folder.", null, "For performance reasons, only showing a limited set of results...", false));
            } else {
                Image icon;
                String replacementString;
                if (file.isDirectory()) {
                    replacementString = String.valueOf(replacementStringPrefix) + fileName + File.separator;
                    icon = DVTImages.imageCache.getImage(DVTImages.DESC_FOLDER);
                } else {
                    replacementString = String.valueOf(replacementStringPrefix) + fileName + (multipleImports ? "" : ";");
                    icon = DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.DESC_SLN_MODULE : DVTImages.DESC_E_MODULE);
                }
                result.add(new CompletionProposal(viewer, replacementString, offset - prefix.length(), prefix.length(), replacementString.length(), icon, fileName, null, String.valueOf(file.getAbsolutePath()) + (file.isDirectory() ? "/" : ""), file.isDirectory()));
            }
            ++n2;
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private ICompletionProposal[] getCompletionProposals(ITextViewer viewer, IRfNamedElement[] candidates, String prefix, int offset, boolean atStructLayer, int kind, IRfScope initialScope) {
        ArrayList<Object> result = new ArrayList<Object>();
        CompletionProposal completionProposal = null;
        if (kind == 176) {
            completionProposal = new CompletionProposal(viewer, "default: {};", offset - prefix.length(), prefix.length(), "default: {".length(), DVTImages.imageCache.getImage(DVTImages.KEYWORD_OBJ), "default", null, "Keyword", false);
        }
        if (candidates == null) {
            if (completionProposal == null) {
                return null;
            }
            result.add(completionProposal);
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        boolean isInSDLMode = false;
        if (this.fProcessor.getRfProject() != null && this.fProcessor.getRfProject().isInSDLMode()) {
            isInSDLMode = true;
        }
        boolean insertOptionalArguments = this.fPluginConfig.getPlugin().getPreferenceStore().getBoolean("ca.insert_optional_arguments");
        int i = 0;
        while (i < candidates.length) {
            if (!(isInSDLMode && candidates[i] instanceof RfNamedElement && ((RfNamedElement)candidates[i]).isEPredefined() || candidates[i].isNonStandard())) {
                result.add(new RfLazyCompletionProposal(viewer, initialScope, candidates[i], prefix, offset, atStructLayer, null, kind, insertOptionalArguments, this.fPluginConfig));
            }
            ++i;
        }
        if (completionProposal != null) {
            result.add(completionProposal);
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    public static final class CompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension4 {
        private String fDisplayString;
        private String fReplacementString;
        private int fReplacementOffset;
        private int fReplacementLength;
        private int fCursorPosition;
        private Image fImage;
        private IContextInformation fContextInformation;
        private String fAdditionalProposalInfo;
        private boolean fInvokeAgain;
        private ITextViewer fViewer;

        private CompletionProposal(ITextViewer viewer, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, boolean invokeAgain) {
            Assert.isNotNull((Object)replacementString);
            Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
            Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
            Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
            this.fReplacementString = replacementString;
            this.fReplacementOffset = replacementOffset;
            this.fReplacementLength = replacementLength;
            this.fCursorPosition = cursorPosition;
            this.fImage = image;
            this.fDisplayString = displayString;
            this.fContextInformation = contextInformation;
            this.fAdditionalProposalInfo = additionalProposalInfo;
            this.fInvokeAgain = invokeAgain;
            this.fViewer = viewer;
        }

        public void apply(IDocument document) {
            try {
                DVTFileModificationValidator.validateEdit((ITextViewer)this.fViewer);
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (CoreException | BadLocationException throwable) {}
            if (this.fInvokeAgain) {
                if (!(this.fViewer instanceof DVTProjectionViewer)) {
                    return;
                }
                UIJob job = new UIJob("CA Trigger"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ((DVTProjectionViewer)fViewer).doOperation(13);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule(100L);
            }
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        public IContextInformation getContextInformation() {
            return this.fContextInformation;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        public String getAdditionalProposalInfo() {
            return this.fAdditionalProposalInfo;
        }

        public boolean isAutoInsertable() {
            return true;
        }
    }
}

