/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.r2lparser.R2LDummyElement;
import ro.amiq.edt.base.r2lparser.R2LSubtypeElement;
import ro.amiq.edt.base.ui.editor.actions.OverrideMethodsAction;
import ro.amiq.edt.base.ui.editor.contentassist.EParameterHintsUtils;
import ro.amiq.edt.base.ui.editor.contentassist.RfLazyCompletionProposalCommon;

public class RfLazyCompletionProposal
extends RfLazyCompletionProposalCommon {
    private static final String CATEGORY = "CONTENT_ASSIST_PROPOSAL";
    private DVTLinkedPositionProvider fLinkedPositionProvider;

    public RfLazyCompletionProposal(ITextViewer viewer, IRfScope initialScope, Object candidate, String currentWord, int offset, boolean atStructLayer, IContextInformation contextInformation, int kind, boolean insertOptionalArguments, IEPluginConfig pluginConfig) {
        super(viewer, initialScope, candidate, currentWord, offset, atStructLayer, contextInformation, kind, insertOptionalArguments, pluginConfig);
        this.fEditor = viewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)viewer).getEditor() : (DVTEditor)DVTUiUtils.getActivePage().getActiveEditor();
        this.fLinkedPositionProvider = new DVTLinkedPositionProvider(this.fEditor, new LinkedModeModel(), CATEGORY + this.toString(), false);
    }

    public void apply(IDocument document) {
        try {
            int charOffset;
            Object[] charOffsetPair;
            DVTFileModificationValidator.validateEdit((ITextViewer)this.fTextViewer);
            if (!this.fPrefix.isEmpty() && (charOffsetPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)this.fOffset, (boolean)false, (String)"__e_partitioning")) != null && (charOffset = ((Integer)charOffsetPair[1]).intValue()) < this.fReplacementOffset + this.fPrefix.length()) {
                this.fReplacementOffset = charOffset - this.fPrefix.length();
            }
            this.fTemplateProposal = null;
            this.internalComputeProposal();
            if (this.fCandidate instanceof R2LDummyElement) {
                return;
            }
            if (this.fOpenOverrideWizardDialog) {
                IAction a = this.fEditor.getAction("OverrideMethods");
                if (a instanceof OverrideMethodsAction) {
                    ((OverrideMethodsAction)a).setReplacementPrefix(this.fPrefix);
                    a.run();
                    this.fCursorPosition = ((OverrideMethodsAction)a).getCursorPosition();
                    ((OverrideMethodsAction)a).setReplacementPrefix("");
                }
                this.fOpenOverrideWizardDialog = false;
                return;
            }
            Point point = this.fTextViewer.getSelectedRange();
            if (this.fReplacementOffset >= point.x && this.fReplacementOffset <= point.x + point.y) {
                this.fReplacementLength = point.y;
            }
            if (this.fUseTemplate) {
                Region region = new Region(this.fReplacementOffset, this.fReplacementLength);
                TemplateContext context = this.createContext(document, (IRegion)region);
                Template template = new Template("", this.fDisplayString, "ro.amiq.edt.templates.contextType.statement", this.fReplacementString.replace("${.", ".${"), true);
                TemplateBuffer templateBuffer = context.evaluate(template);
                this.fReplacementString = templateBuffer.getString();
                List<IRegion> linkedPositionRegions = this.computeLinkedPositionRegionsFromTemplate(templateBuffer);
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
                this.fTemplateProposal = new TemplateProposal(template, context, (IRegion)region, this.fImage, 1);
                if (linkedPositionRegions == null || linkedPositionRegions.isEmpty() || this.fLinkedPositionProvider == null) {
                    return;
                }
                this.fLinkedPositionProvider.setHasPositions(true);
                IRegion firstRegion = null;
                for (IRegion linkedPosRegion : linkedPositionRegions) {
                    if (firstRegion == null) {
                        firstRegion = linkedPosRegion;
                    }
                    this.fLinkedPositionProvider.addSingleLinkedPosition(linkedPosRegion.getOffset(), linkedPosRegion.getLength(), document);
                }
                if (firstRegion != null) {
                    this.firstParameterOffset = firstRegion.getOffset();
                    this.firstParameterLength = firstRegion.getLength();
                }
                String functionName = "";
                if (this.fCandidate instanceof RfNamedElement) {
                    functionName = ((RfNamedElement)this.fCandidate).getName();
                }
                int contextInformationStartOffset = EParameterHintsUtils.getContextInformationOffset(document, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, false, true);
                int contextInformationEndOffset = EParameterHintsUtils.getContextInformationOffset(document, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, true, true) - 1;
                if (contextInformationStartOffset >= 0 && contextInformationEndOffset >= 0 && this.fFunctionArguments != null) {
                    this.fContextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, this.fDisplayString, this.fFunctionArguments, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__e_partitioning");
                }
                DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.fCandidateHasSemiColon ? (char)';' : ')', this.fReplacementOffset, "__e_partitioning");
                this.fLinkedPositionProvider.enterLinkedMode(document, config);
                return;
            }
            if (this.fCandidate instanceof RfNamedElement && this.fPrefix.isEmpty() && Character.isJavaIdentifierPart(document.getChar(this.fOffset - 1))) {
                this.fReplacementString = " " + this.fReplacementString;
                ++this.fCursorPosition;
            }
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            if (this.fPrefix.length() > 0 && this.fCandidate instanceof R2LSubtypeElement && !((R2LSubtypeElement)this.fCandidate).getStructName().equals(this.fPrefix)) {
                document.replace(this.fOffset - this.fPrefix.length(), this.fPrefix.length(), "");
                this.fCursorPosition = -this.fPrefix.length();
            }
        }
        catch (Throwable throwable) {}
    }

    private List<IRegion> computeLinkedPositionRegionsFromTemplate(TemplateBuffer templateBuffer) {
        ArrayList<IRegion> linkedPositionRegions = new ArrayList<IRegion>();
        TemplateVariable[] templateVariables = templateBuffer.getVariables();
        if (templateVariables == null) {
            return linkedPositionRegions;
        }
        TemplateVariable[] templateVariableArray = templateVariables;
        int n = templateVariables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable templateVariable = templateVariableArray[n2];
            int[] templateOffsets = templateVariable.getOffsets();
            if (templateOffsets != null) {
                String templateVarName = templateVariable.getName();
                int[] nArray = templateOffsets;
                int n3 = templateOffsets.length;
                int n4 = 0;
                while (n4 < n3) {
                    int offset = nArray[n4];
                    linkedPositionRegions.add((IRegion)new Region(this.fReplacementOffset + offset, templateVarName.length()));
                    ++n4;
                }
            }
            ++n2;
        }
        return linkedPositionRegions;
    }

    public Point getSelection(IDocument document) {
        this.internalComputeProposal();
        if (this.fTemplateProposal == null || !this.fLinkedPositionProvider.hasPositions()) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }
        return new Point(this.firstParameterOffset, this.firstParameterLength);
    }
}

