/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.contentassist;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTCompletionProposal;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.predefined.RfPseudoMethod;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.r2lparser.R2LAmbiguousType;
import ro.amiq.edt.base.r2lparser.R2LCoverItemOption;
import ro.amiq.edt.base.r2lparser.R2LDummyElement;
import ro.amiq.edt.base.r2lparser.R2LInfoProposalElement;
import ro.amiq.edt.base.r2lparser.R2LMacroArgument;
import ro.amiq.edt.base.r2lparser.R2LMethodPortElement;
import ro.amiq.edt.base.r2lparser.R2LOverrideWizardElement;
import ro.amiq.edt.base.r2lparser.R2LSDLScenarioInvocationByNameArgElement;
import ro.amiq.edt.base.r2lparser.R2LStructLayerWrapper;
import ro.amiq.edt.base.r2lparser.R2LSubtypeElement;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistUtils;

public abstract class RfLazyCompletionProposalCommon
implements IDVTCompletionProposal,
ICompletionProposalExtension4,
ICompletionProposalExtension5 {
    private static final int DESCRIPTION_LINE_LENGTH = 40;
    private static final Pattern SQUARE_BRACKET_CONTENT_REGEX = Pattern.compile("\\[[^\\]]*\\]");
    private static final Pattern ARGUMENT_TYPE = Pattern.compile("\\s*:\\s*[^,]*");
    private static final Pattern TRAILING_CONTENT = Pattern.compile("\\s.*$");
    private static final Pattern COMMA_FOLLOWED_BY_DOTS = Pattern.compile(",\\s*[\\.]+");
    private static final Pattern MACRO_REGEX = Pattern.compile("<([a-zA-Z0-9_]+)('[a-zA-Z0-9_]+)?>");
    private static final Pattern TTYPEX_REGEX = Pattern.compile("'[Ttypex]+");
    protected Object fCandidate;
    protected String fPrefix;
    protected int fOffset;
    private boolean fAtStructLayer;
    protected String fReplacementString;
    protected String fDisplayString;
    protected Image fImage;
    private DVTTooltipContent fAdditionalProposalInfo;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    protected int fCursorPosition;
    private boolean fAlreadyComputed;
    protected IContextInformation fContextInformation;
    protected TemplateProposal fTemplateProposal;
    protected boolean fUseTemplate;
    protected ITextViewer fTextViewer;
    private int fKind;
    protected boolean fOpenOverrideWizardDialog;
    protected int firstParameterOffset;
    protected int firstParameterLength;
    protected IRfScope fInitialScope;
    protected String fFunctionArguments;
    protected boolean fCandidateHasSemiColon;
    private boolean fInsertOptionalArguments;
    private IEPluginConfig fPluginConfig;
    protected DVTEditor fEditor;

    protected RfLazyCompletionProposalCommon(ITextViewer viewer, IRfScope initialScope, Object candidate, String currentWord, int offset, boolean atStructLayer, IContextInformation contextInformation, int kind, boolean insertOptionalArguments, IEPluginConfig pluginConfig) {
        this.fTextViewer = viewer;
        this.fInitialScope = initialScope;
        this.fCandidate = candidate;
        this.fPrefix = currentWord;
        this.fOffset = offset;
        this.fAtStructLayer = atStructLayer;
        this.fContextInformation = contextInformation;
        this.fKind = kind;
        this.fInsertOptionalArguments = insertOptionalArguments;
        this.fPluginConfig = pluginConfig;
    }

    public boolean isNoProposal() {
        return this.fCandidate instanceof R2LDummyElement;
    }

    public IContextInformation getContextInformation() {
        this.internalComputeProposal();
        return this.fContextInformation;
    }

    public Image getImage() {
        this.internalComputeProposal();
        return this.fImage;
    }

    public String getAdditionalProposalInfo() {
        String result;
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        if ((result = String.valueOf(this.fAdditionalProposalInfo.getSignature()) + this.fAdditionalProposalInfo.getShallow() + this.fAdditionalProposalInfo.getComment() + this.fAdditionalProposalInfo.getUPFSignature() + this.fAdditionalProposalInfo.getDebugInfo()).length() > 300) {
            return String.valueOf(result.substring(0, 300)) + "...";
        }
        return result;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return this.getAdditionalProposalInfo();
        }
        return this.fAdditionalProposalInfo;
    }

    private void computeAdditionalProposalInfo() {
        this.fAdditionalProposalInfo = new DVTTooltipContent();
        DVTTooltipContent tooltipContent = new DVTTooltipContent();
        String comment = null;
        if (this.fCandidate instanceof R2LSDLScenarioInvocationByNameArgElement) {
            RfUtils.getTooltipFormattedText((R2LSDLScenarioInvocationByNameArgElement)this.fCandidate, this.fPluginConfig, (ITextEditor)this.fEditor, tooltipContent);
            comment = String.valueOf(tooltipContent.getSignature()) + tooltipContent.getComment();
        } else if (this.fCandidate instanceof R2LMethodPortElement) {
            RfUtils.getTooltipFormattedText((RfNamedElement)this.fCandidate, this.fPluginConfig, (ITextEditor)this.fEditor, tooltipContent);
            comment = String.valueOf(tooltipContent.getSignature()) + tooltipContent.getComment();
        } else if (this.fCandidate instanceof RfStruct) {
            RfUtils.getTooltipFormattedText((RfNamedElement)this.fCandidate, this.fPluginConfig, (ITextEditor)this.fEditor, tooltipContent);
            comment = String.valueOf(tooltipContent.getSignature()) + tooltipContent.getComment();
        } else if (this.fCandidate instanceof RfNamedElement) {
            RfUtils.getTooltipFormattedText((RfNamedElement)this.fCandidate, this.fPluginConfig, (ITextEditor)this.fEditor, tooltipContent);
            comment = String.valueOf(tooltipContent.getSignature()) + tooltipContent.getComment();
        } else if (this.fCandidate instanceof RfStructLayer) {
            RfUtils.getTooltipFormattedText((RfNamedElement)this.fCandidate, this.fPluginConfig, (ITextEditor)this.fEditor, tooltipContent);
            comment = String.valueOf(tooltipContent.getSignature()) + tooltipContent.getComment();
        }
        if (this.fCandidate instanceof R2LInfoProposalElement) {
            comment = ((R2LInfoProposalElement)this.fCandidate).getSignature();
        }
        if (this.fCandidate instanceof R2LDummyElement) {
            comment = ((R2LDummyElement)this.fCandidate).getSignature();
            return;
        }
        if (this.fCandidate instanceof R2LOverrideWizardElement) {
            RfNamedElement namedElement = (RfNamedElement)this.fCandidate;
            comment = namedElement.getSignature();
            comment = DVTStringUtil.textWrap((int)40, (String)comment).toString();
        }
        if (tooltipContent != null) {
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipContent.getComment());
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, tooltipContent.getSignature());
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.PREFERENCE, tooltipContent.getPreference());
        }
    }

    protected TemplateContext createContext(IDocument document, IRegion region) {
        TemplateContextType contextType = new TemplateContextType("ro.amiq.edt.templates.contextType.unknown", "dummy");
        return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
    }

    public String getDisplayString() {
        this.internalComputeProposal();
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getReplacementString() {
        this.internalComputeProposal();
        if (this.fReplacementString != null) {
            return this.fReplacementString;
        }
        return this.fDisplayString;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    protected void internalComputeProposal() {
        String typeName;
        if (this.fAlreadyComputed) {
            return;
        }
        this.fAlreadyComputed = true;
        this.fUseTemplate = false;
        String methodPortName = null;
        String candidateName = null;
        if (this.fCandidate == null) {
            return;
        }
        if (this.fCandidate instanceof R2LStructLayerWrapper) {
            this.fCandidate = ((R2LStructLayerWrapper)this.fCandidate).getStructLayer();
        }
        this.fImage = EContentAssistUtils.computeImageFromElement(this.fCandidate);
        this.fReplacementString = this.fPrefix;
        this.fDisplayString = "";
        if (this.fCandidate instanceof R2LSDLScenarioInvocationByNameArgElement) {
            RfField param = ((R2LSDLScenarioInvocationByNameArgElement)this.fCandidate).getParam();
            this.fReplacementString = String.valueOf(param.getName()) + ": ";
            typeName = param.getAssociatedFullTypeName();
            int i = 0;
            while (i < param.getAssociatedTypeList()) {
                typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
                ++i;
            }
            this.fDisplayString = String.valueOf(this.fReplacementString) + typeName;
        } else if (this.fCandidate instanceof R2LMethodPortElement) {
            methodPortName = ((R2LMethodPortElement)this.fCandidate).getName();
            this.fCandidate = ((R2LMethodPortElement)this.fCandidate).getMethod();
            candidateName = ((RfNamedElement)this.fCandidate).getName();
        } else if (this.fCandidate instanceof RfStruct) {
            candidateName = String.valueOf(((RfStruct)this.fCandidate).getName()) + ((RfStruct)this.fCandidate).getParametersInfo(true);
        } else if (this.fCandidate instanceof RfNamedElement) {
            candidateName = ((RfNamedElement)this.fCandidate).getName();
        } else if (this.fCandidate instanceof RfStructLayer) {
            candidateName = ((RfStructLayer)this.fCandidate).getInfo();
        }
        if (this.fCandidate instanceof R2LInfoProposalElement) {
            this.fReplacementString = this.fPrefix;
            this.fDisplayString = candidateName;
        }
        String packagePrefix = "";
        if (this.fCandidate instanceof R2LDummyElement) {
            this.fReplacementString = "";
            this.fDisplayString = candidateName;
            this.fReplacementOffset = this.fOffset;
            this.fReplacementLength = 0;
            this.fCursorPosition = 0;
            return;
        }
        if (this.fCandidate instanceof R2LCoverItemOption) {
            this.fReplacementString = candidateName;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof R2LMacroArgument) {
            this.fReplacementString = String.valueOf(candidateName) + ">";
            this.fDisplayString = "<" + candidateName + ">";
        } else if (this.fCandidate instanceof R2LOverrideWizardElement) {
            this.fOpenOverrideWizardDialog = true;
            this.fDisplayString = candidateName;
            this.fReplacementString = this.fPrefix;
        } else if (this.fCandidate instanceof R2LAmbiguousType) {
            this.fCandidate = ((R2LAmbiguousType)this.fCandidate).getRfType();
            String candidatePkgName = ((RfType)this.fCandidate).getPackageName();
            String scopePkgName = this.fInitialScope instanceof RfNamedElement ? "" : this.fInitialScope.getLibPkgScope().getPackageName();
            String string = packagePrefix = !scopePkgName.isEmpty() && !scopePkgName.equals(candidatePkgName) ? String.valueOf(candidatePkgName) + "::" : "";
        }
        if (RfStruct.isPackageElement(this.fCandidate, true)) {
            this.fReplacementString = String.valueOf(candidateName) + (this.fKind == 154 ? ";" : "::");
            this.fCandidateHasSemiColon = this.fKind == 154;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof RfMethodType) {
            this.fReplacementString = String.valueOf(packagePrefix) + candidateName;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof RfStructLayer) {
            this.fReplacementString = String.valueOf(candidateName) + ";";
            this.fCandidateHasSemiColon = true;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof RfMacro) {
            if (((RfMacro)this.fCandidate).isPreprocessing()) {
                this.fDisplayString = this.fReplacementString = ((RfMacro)this.fCandidate).getName();
            } else {
                this.fReplacementString = String.valueOf(this.getMacroString(((RfMacro)this.fCandidate).getStringLiteral())) + ";";
                this.fCandidateHasSemiColon = true;
                this.fDisplayString = ((RfMacro)this.fCandidate).getSignature();
            }
        } else if (this.fCandidate instanceof RfPredefinedStruct) {
            this.fReplacementString = candidateName;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof RfStruct) {
            if (((RfStruct)this.fCandidate).isSDLScenario()) {
                this.fDisplayString = this.fReplacementString = ((RfStruct)this.fCandidate).getName();
            } else {
                this.fReplacementString = String.valueOf(((RfStruct)this.fCandidate).getName()) + this.getParametersInfo((RfStruct)this.fCandidate);
                this.fDisplayString = candidateName;
            }
            this.fReplacementString = String.valueOf(packagePrefix) + ((RfStruct)this.fCandidate).getName() + this.getParametersInfo((RfStruct)this.fCandidate);
            this.fDisplayString = candidateName;
            this.fUseTemplate = this.fReplacementString.contains("${");
        } else if (this.fCandidate instanceof RfScalarType) {
            this.fReplacementString = String.valueOf(packagePrefix) + candidateName;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof RfArg) {
            typeName = ((RfArg)this.fCandidate).getAssociatedFullTypeName();
            int i = 0;
            while (i < ((RfArg)this.fCandidate).getAssociatedTypeList()) {
                typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
                ++i;
            }
            this.fReplacementString = candidateName;
            this.fDisplayString = String.valueOf(candidateName) + ": " + typeName;
        } else if (this.fCandidate instanceof RfCoverItem) {
            this.fReplacementString = candidateName;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof RfVar) {
            this.fReplacementString = candidateName;
            this.fDisplayString = candidateName;
            typeName = ((RfVar)this.fCandidate).getAssociatedFullTypeName();
            int i = 0;
            while (i < ((RfVar)this.fCandidate).getAssociatedTypeList()) {
                typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
                ++i;
            }
            if (((RfVar)this.fCandidate).getAssociatedFullTypeName() != null) {
                this.fDisplayString = String.valueOf(this.fDisplayString) + ": " + typeName;
            }
        } else if (this.fCandidate instanceof RfField) {
            typeName = ((RfField)this.fCandidate).getAssociatedFullTypeName();
            int i = 0;
            while (i < ((RfField)this.fCandidate).getAssociatedTypeList()) {
                typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
                ++i;
            }
            this.fReplacementString = candidateName;
            this.fDisplayString = String.valueOf(candidateName) + ": " + typeName;
        } else {
            if (this.fCandidate instanceof R2LSubtypeElement) {
                if (this.fOffset != ((R2LSubtypeElement)this.fCandidate).getInsertIndex()) {
                    this.fReplacementLength = 0;
                }
                if (candidateName != null && !candidateName.equals("TRUE") && !candidateName.equals("FALSE")) {
                    this.fOffset = this.fReplacementOffset = ((R2LSubtypeElement)this.fCandidate).getInsertIndex();
                    if (candidateName.startsWith(this.fPrefix)) {
                        this.fReplacementLength = this.fPrefix.length();
                    } else {
                        this.fReplacementOffset = ((R2LSubtypeElement)this.fCandidate).getInsertIndex();
                        this.fPrefix = "";
                    }
                }
                this.fReplacementString = " " + candidateName;
                this.fDisplayString = candidateName;
                return;
            }
            if (this.fCandidate instanceof RfEnum) {
                this.fReplacementString = candidateName;
                this.fDisplayString = candidateName;
            } else if (this.fCandidate instanceof RfEvent) {
                this.fReplacementString = candidateName;
                this.fDisplayString = candidateName;
            } else if (this.fCandidate instanceof RfMethod) {
                String arguments = ((RfMethod)this.fCandidate).getArgs();
                if (arguments == null) {
                    arguments = "";
                } else if (!this.fInsertOptionalArguments) {
                    arguments = this.computeMandatoryArguments(arguments);
                }
                this.fFunctionArguments = arguments;
                String typeName2 = ((RfMethod)this.fCandidate).getAssociatedFullTypeName();
                if ("void".equals(typeName2)) {
                    typeName2 = "";
                } else {
                    int i = 0;
                    while (i < ((RfMethod)this.fCandidate).getAssociatedTypeList()) {
                        typeName2 = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName2});
                        ++i;
                    }
                }
                String event = ((RfMethod)this.fCandidate).getEvent();
                if (methodPortName == null) {
                    this.fDisplayString = String.valueOf(candidateName) + "(" + arguments + ")";
                } else {
                    this.fDisplayString = String.valueOf(methodPortName) + "$(" + arguments + ")";
                    candidateName = String.valueOf(methodPortName) + "$$";
                }
                arguments = arguments.replace("-", "_");
                arguments = DVTStringUtil.replaceAll((Pattern)SQUARE_BRACKET_CONTENT_REGEX, (CharSequence)arguments, (String)"");
                arguments = DVTStringUtil.replaceAll((Pattern)COMMA_FOLLOWED_BY_DOTS, (CharSequence)arguments, (String)"");
                if (event != null && event.length() > 0) {
                    this.fDisplayString = String.valueOf(this.fDisplayString) + "@" + event;
                }
                if (typeName2 != null && typeName2.trim().length() > 0) {
                    this.fDisplayString = String.valueOf(this.fDisplayString) + " : " + typeName2;
                }
                if (this.fAtStructLayer) {
                    this.fReplacementString = String.valueOf(candidateName) + "(" + arguments + ")";
                    if (typeName2 != null && typeName2.trim().length() != 0) {
                        this.fReplacementString = String.valueOf(this.fReplacementString) + " : " + typeName2.trim();
                    }
                    if (event != null && event.trim().length() != 0) {
                        this.fReplacementString = String.valueOf(this.fReplacementString) + " @" + event.trim();
                    }
                } else if (arguments != null && arguments.trim().length() > 0) {
                    this.fReplacementString = String.valueOf(candidateName) + "(" + this.getArgumentsInfo(arguments) + ")";
                    this.fUseTemplate = true;
                } else if (((RfMethod)this.fCandidate).getParentStruct() instanceof RfListType && this.fCandidate instanceof RfPseudoMethod) {
                    this.fReplacementString = candidateName;
                    this.fUseTemplate = true;
                } else {
                    this.fReplacementString = String.valueOf(candidateName) + "()";
                    this.fUseTemplate = true;
                }
            }
        }
        if (this.fReplacementString == null) {
            this.fReplacementString = "";
        }
        if (this.fCandidate instanceof RfEnum && this.fKind == 176) {
            this.fReplacementString = String.valueOf(this.fReplacementString) + ": {};";
            this.fCursorPosition = this.fReplacementString.length() - 2;
        } else if (this.fCandidate instanceof RfMacro) {
            this.fCursorPosition = Math.max(this.fReplacementString.indexOf("<"), 0);
            if (this.fCursorPosition == 0) {
                this.fCursorPosition = this.fReplacementString.length();
            }
        } else {
            this.fCursorPosition = this.fCandidate instanceof RfType ? this.fReplacementString.length() : (this.fCandidate instanceof RfStructLayer ? this.fReplacementString.length() : this.fReplacementString.length());
        }
        this.fReplacementOffset = this.fOffset - this.fPrefix.length();
        this.fReplacementLength = this.fPrefix.length();
        Point selectedRange = this.fTextViewer.getSelectedRange();
        if (this.fReplacementLength == 0 && selectedRange != null && selectedRange.x == this.fReplacementOffset) {
            this.fReplacementLength = selectedRange.y;
        }
    }

    private String computeMandatoryArguments(String allArguments) {
        int firstDefaultValue = allArguments.indexOf(61);
        if (firstDefaultValue == -1) {
            return allArguments;
        }
        String mandatoryArguments = allArguments.substring(0, firstDefaultValue);
        int lastArgumentFinishIndex = mandatoryArguments.lastIndexOf(44);
        if (lastArgumentFinishIndex == -1) {
            return "";
        }
        return mandatoryArguments.substring(0, lastArgumentFinishIndex).trim();
    }

    private String getParametersInfo(RfStruct struct) {
        StringBuilder result = new StringBuilder();
        if (!(struct instanceof RfTemplateStruct)) {
            return result.toString();
        }
        Set<String> templateParameters = ((RfTemplateStruct)struct).getParameterNames();
        if (templateParameters == null) {
            return result.toString();
        }
        for (String param : templateParameters) {
            param = DVTStringUtil.replaceFirst((Pattern)DVTStringUtil.SINGLE_QUOTE, (CharSequence)param.trim(), (String)"_");
            param = param.replace("<", "").replace(">", "");
            String temp = "${" + DVTStringUtil.replaceAll((Pattern)TTYPEX_REGEX, (CharSequence)param, (String)"") + "}";
            result.append(result.length() == 0 ? temp : ", " + temp);
        }
        return " of (" + result.toString() + ")";
    }

    private String getArgumentsInfo(String argumentsText) {
        String[] arguments;
        StringBuilder result = new StringBuilder();
        if (argumentsText == null) {
            return result.toString();
        }
        if (argumentsText.equals("...")) {
            return "${}";
        }
        argumentsText = DVTStringUtil.replaceAll((Pattern)SQUARE_BRACKET_CONTENT_REGEX, (CharSequence)argumentsText, (String)"");
        argumentsText = DVTStringUtil.replaceAll((Pattern)ARGUMENT_TYPE, (CharSequence)argumentsText, (String)"");
        String[] stringArray = arguments = argumentsText.split(",");
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            argument = DVTStringUtil.replaceFirst((Pattern)TRAILING_CONTENT, (CharSequence)argument.trim(), (String)"");
            argument = argument.replace("<", "").replace(">", "");
            String temp = "${" + DVTStringUtil.replaceAll((Pattern)TTYPEX_REGEX, (CharSequence)argument, (String)"") + "}";
            result.append(result.length() == 0 ? temp : ", " + temp);
            ++n2;
        }
        return result.toString();
    }

    private String getMacroString(String macroString) {
        String result = "";
        if (macroString == null) {
            return result;
        }
        result = macroString = macroString.replace("\\(", "(").replace("\\)", ")").replace("\\{", "{").replace("\\}", "}").replace("\\[", "[").replace("\\]", "]");
        if (!result.equals(macroString = DVTStringUtil.replaceAll((Pattern)MACRO_REGEX, (CharSequence)macroString, (String)"\\${$1}"))) {
            this.fUseTemplate = true;
            result = macroString;
        }
        return result;
    }

    public boolean isAutoInsertable() {
        return true;
    }
}

