/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.ICFPreprocScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;

public class ECFPreprocScanner
extends CFTokenScanner
implements ICFPreprocScannerImpl {
    private CFTokenScanner fCFTokenScanner;
    private boolean fGotDefine;
    private boolean fInPreprocDefine;
    private int fNofOpensInPreprocDefine;

    public ECFPreprocScanner(CFModel model) {
        super(model);
    }

    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        this.fCFTokenScanner = cfTokenScanner;
    }

    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fCFTokenScanner.startPartition(strategy);
    }

    public void startChunk(CFChunk chunk) {
        super.startChunk(chunk);
        this.fCFTokenScanner.startChunk(chunk);
    }

    public void endChunk(CFChunk chunk) {
        super.endChunk(chunk);
        this.fCFTokenScanner.endChunk(chunk);
    }

    public void startToken(CFToken token) {
        super.startToken(token);
        this.fCFTokenScanner.startToken(token);
    }

    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        this.fCFTokenScanner.analyzeToken(token);
    }

    public void endToken(CFToken token) {
        super.endToken(token);
        this.fCFTokenScanner.endToken(token);
        this.updatePreprocContext(token);
    }

    private void updatePreprocContext(CFToken token) {
        if (this.fGotDefine) {
            if (token.getTokenType() == 3 || token.getTokenType() == 30 || token.getTokenType() == 40) {
                return;
            }
            if (this.isEndOfCode(token) || this.isStartOfCode(token)) {
                return;
            }
            if (token.getTokenType() == 2 && token.getValue().startsWith("<")) {
                this.fGotDefine = false;
                return;
            }
            this.fInPreprocDefine = true;
            this.fNofOpensInPreprocDefine = 0;
            this.fGotDefine = false;
        }
        if (this.fInPreprocDefine) {
            if (token.getTokenType() == 4) {
                if (token.getValue() != null && !token.getValue().isEmpty()) {
                    char c = token.getValue().charAt(0);
                    if ('{' == c || '(' == c || '[' == c) {
                        ++this.fNofOpensInPreprocDefine;
                    } else if ('}' == c || ')' == c || ']' == c) {
                        --this.fNofOpensInPreprocDefine;
                    }
                }
            } else if (token.getTokenType() == 3 && this.fNofOpensInPreprocDefine == 0 && token.getValue().contains("\n") && !token.getEnclosingChunk().getValue().trim().endsWith("\\")) {
                this.fInPreprocDefine = false;
            }
        } else if (token.getTokenType() == 2) {
            String word = token.getValue();
            if ("define".equals(word)) {
                this.fGotDefine = true;
            }
            if ("#define".equals(word)) {
                this.fInPreprocDefine = true;
            }
        }
    }

    public boolean isInPreproc() {
        return this.fInPreprocDefine;
    }

    private boolean isEndOfCode(CFToken token) {
        if (token == null) {
            return false;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        String chunkValue = chunk.getValue();
        CFPartition partition = chunk.getEnclosingPartition();
        if (partition == null) {
            return false;
        }
        if (!partition.isLastChunk(chunk)) {
            return false;
        }
        return chunk.isFirstOnLine() && chunkValue.startsWith("'>");
    }

    private boolean isStartOfCode(CFToken token) {
        if (token == null) {
            return false;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        String chunkValue = chunk.getValue();
        CFPartition partition = chunk.getEnclosingPartition();
        if (partition == null) {
            return false;
        }
        if (!partition.isFirstChunk(chunk)) {
            return false;
        }
        return chunk.isFirstOnLine() && chunkValue.startsWith("<'");
    }
}

