/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.highlight;

import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfConstraint;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfPropConstraint;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyMethod;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.RfUndefVariable;

public class EHlUtils
extends DVTHlUtils {
    public static HighlightKind getHighlightKind(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof RfUndefVariable) {
            return null;
        }
        if (element instanceof RfPropConstraint) {
            element = ((RfPropConstraint)element).getField();
        } else if (element instanceof RfDummyField) {
            if (((RfDummyField)element).getName().equals("apply_container")) {
                return HighlightKind.METHOD;
            }
            element = ((RfDummyField)element).getAssociatedType();
        } else if (element instanceof RfDummyMethod) {
            element = ((RfDummyMethod)element).getAssociatedBaseType();
        }
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        if (((RfNamedElement)element).isConst()) {
            return HighlightKind.CONSTANT;
        }
        if (element instanceof RfArg) {
            return HighlightKind.ARGUMENT;
        }
        if (element instanceof RfVar) {
            return HighlightKind.VARIABLE;
        }
        if (element instanceof RfStructQualifier) {
            RfStructQualifier structQualifier = (RfStructQualifier)element;
            RfEnum enumeration = structQualifier.getEnum();
            if (enumeration == null) {
                return HighlightKind.FIELD;
            }
            if (enumeration.getName().equals("TRUE")) {
                return HighlightKind.FIELD;
            }
            return HighlightKind.CONSTANT;
        }
        if (element instanceof RfEnum) {
            return HighlightKind.CONSTANT;
        }
        if (element instanceof RfField) {
            RfField fieldElement = (RfField)element;
            if (fieldElement.isPort()) {
                if (fieldElement.isOutputPort()) {
                    return HighlightKind.OUT_PORT;
                }
                return HighlightKind.PORT;
            }
            return HighlightKind.FIELD;
        }
        if (element instanceof RfMethod) {
            if (((RfMethod)element).getName().startsWith("on_")) {
                return HighlightKind.EVENT;
            }
            return HighlightKind.METHOD;
        }
        if (element instanceof RfType || element instanceof RfScalarType || element instanceof RfStruct && RfStruct.isPackageElement(element, false) || element instanceof RfStruct && ((RfStruct)element).isUnit()) {
            return HighlightKind.TYPE;
        }
        if (element instanceof RfEvent) {
            return HighlightKind.EVENT;
        }
        if (element instanceof RfExpect || element instanceof RfConstraint) {
            return HighlightKind.LABEL;
        }
        return null;
    }
}

