/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.highlight;

import antlr.collections.AST;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightJob;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.ui.editor.highlight.SemanticHighlightWalker;

public class ESemanticHighlighter
extends DVTSemanticHighlighter<RfModule> {
    public ESemanticHighlighter(IDocument document) {
        super(document);
    }

    public void process(IRfFileDef file, SemanticHighlightJob job, int startOffset, int endOffset) {
        if (!(file instanceof RfModule)) {
            return;
        }
        RfModule module = (RfModule)file;
        RfProject.ModuleReference moduleReference = module.getModuleReference();
        if (moduleReference == null) {
            return;
        }
        IRfSingleLangProject project = module.getRfProject();
        if (project == null) {
            return;
        }
        EModuleInfo moduleInfoByParserPath = project.getModuleInfo(moduleReference);
        if (moduleInfoByParserPath == null) {
            return;
        }
        AST moduleAST = moduleInfoByParserPath.getModuleAST();
        if (moduleAST == null) {
            return;
        }
        super.process(file, job, startOffset, endOffset);
        SemanticHighlightWalker semanticHighlightWalker = new SemanticHighlightWalker(module.getDocument(), module.getParserPath(), startOffset, endOffset);
        semanticHighlightWalker.walkFile(moduleAST, this.getPositions());
    }

    protected Collection<RfModule> getChildren(RfModule root) {
        return null;
    }

    protected void doHighlight(RfModule root) throws BadLocationException {
    }

    protected IStatus doHighlightRecursive(RfModule root, Set<RfModule> visited, SemanticHighlightJob job) throws BadLocationException, BadPositionCategoryException, Exception {
        return Status.OK_STATUS;
    }
}

