/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hover;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.ui.editor.IEStyle;

public class EHoverNonRuleBasedReconciler
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument fDocument;
    protected IEStyle fColorManager;
    protected String fType;

    public EHoverNonRuleBasedReconciler(IEStyle colorManager, String type) {
        Assert.isNotNull((Object)colorManager);
        this.fColorManager = colorManager;
        this.fType = type;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        try {
            TextAttribute textAttribute = (TextAttribute)this.fColorManager.getToken(this.fType).getData();
            this.addRange(presentation, region.getOffset(), region.getLength(), textAttribute);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            presentation.addStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
        }
    }
}

