/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hover;

import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.ECodeScanner;
import ro.amiq.edt.base.ui.editor.ECommentScanner;
import ro.amiq.edt.base.ui.editor.EExpansionScanner;
import ro.amiq.edt.base.ui.editor.IEStyle;
import ro.amiq.edt.base.ui.editor.hover.EHoverNonRuleBasedReconciler;
import ro.amiq.edt.base.ui.editor.hover.EHoverSourceViewerReconciler;

public class EHoverSourceViewerConfiguration
extends SourceViewerConfiguration {
    private ECodeScanner fCodeScanner;
    private EExpansionScanner fExpansionScanner;
    private ECommentScanner fCommentScanner;
    private IEStyle fColorManager;
    private IEPluginConfig fPluginConfig;
    protected String[] fConfiguredContentType = new String[]{"__dftl_partition_content_type", "__e_expansion", "__e_string", "__dftl_partition_content_type"};

    public EHoverSourceViewerConfiguration(IEPluginConfig pluginConfig, IEStyle colorManager) {
        this.fColorManager = colorManager;
        this.fPluginConfig = pluginConfig;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.fConfiguredContentType;
    }

    protected ECodeScanner getECodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new ECodeScanner(this.fPluginConfig, this.fColorManager, 0);
            this.fCodeScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected EExpansionScanner getEExpansionScanner() {
        if (this.fExpansionScanner == null) {
            this.fExpansionScanner = new EExpansionScanner(this.fPluginConfig, this.fColorManager, false);
            this.fExpansionScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.exp_literal"));
        }
        return this.fExpansionScanner;
    }

    private ECommentScanner getECommentScanner() {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new ECommentScanner(this.fColorManager, false, 0, this.isInspectView(), null);
            this.fCommentScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.comment"));
        }
        return this.fCommentScanner;
    }

    protected boolean isInspectView() {
        return false;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        EHoverSourceViewerReconciler dr1 = new EHoverSourceViewerReconciler((ITokenScanner)this.getECodeScanner());
        reconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
        EHoverSourceViewerReconciler dr2 = new EHoverSourceViewerReconciler((ITokenScanner)this.getEExpansionScanner());
        reconciler.setDamager((IPresentationDamager)dr2, "__e_expansion");
        reconciler.setRepairer((IPresentationRepairer)dr2, "__e_expansion");
        EHoverSourceViewerReconciler dr3 = new EHoverSourceViewerReconciler((ITokenScanner)this.getECommentScanner());
        reconciler.setDamager((IPresentationDamager)dr3, "__e_sl_comment");
        reconciler.setRepairer((IPresentationRepairer)dr3, "__e_sl_comment");
        EHoverSourceViewerReconciler dr4 = new EHoverSourceViewerReconciler((ITokenScanner)this.getECommentScanner());
        reconciler.setDamager((IPresentationDamager)dr4, "__e_ml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr4, "__e_ml_comment");
        reconciler.setDamager((IPresentationDamager)dr4, "__e_sv_ml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr4, "__e_sv_ml_comment");
        EHoverNonRuleBasedReconciler ndr1 = new EHoverNonRuleBasedReconciler(this.fColorManager, "highlight.string");
        reconciler.setDamager((IPresentationDamager)ndr1, "__e_string");
        reconciler.setRepairer((IPresentationRepairer)ndr1, "__e_string");
        EHoverSourceViewerReconciler dr7 = new EHoverSourceViewerReconciler((ITokenScanner)this.getECommentScanner());
        reconciler.setDamager((IPresentationDamager)dr7, "__e_sl_comment_in_expansion");
        reconciler.setRepairer((IPresentationRepairer)dr7, "__e_sl_comment_in_expansion");
        EHoverNonRuleBasedReconciler ndr2 = new EHoverNonRuleBasedReconciler(this.fColorManager, "highlight.string");
        reconciler.setDamager((IPresentationDamager)ndr2, "__e_string_in_code_replacement_in_expansion");
        reconciler.setRepairer((IPresentationRepairer)ndr2, "__e_string_in_code_replacement_in_expansion");
        EHoverNonRuleBasedReconciler ndr3 = new EHoverNonRuleBasedReconciler(this.fColorManager, "highlight.string");
        reconciler.setDamager((IPresentationDamager)ndr3, "__e_string_in_code_section_in_expansion");
        reconciler.setRepairer((IPresentationRepairer)ndr3, "__e_string_in_code_section_in_expansion");
        return reconciler;
    }
}

