/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hover;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.hover.ETextHoverParticipantCommon;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class ETextHoverParticipant
extends ETextHoverParticipantCommon {
    public ETextHoverParticipant(IEPluginConfig pluginConfig) {
        super(pluginConfig);
    }

    @Override
    protected IAnnotationModel getAnnotationModel(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getAnnotationModel((Object)editor.getEditorInput());
        }
        return null;
    }

    @Override
    protected IProject getProject(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    @Override
    protected IFile getFile() {
        if (this.fTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    @Override
    protected String getTooltipContentFilePath(ITextViewer textViewer) {
        EDTFileUtils fileUtilsInstance = EDTFileUtils.getInstance();
        IFile fileFromViewer = fileUtilsInstance != null ? fileUtilsInstance.getFileFromViewer(textViewer) : null;
        IPath relativePath = fileFromViewer != null ? fileFromViewer.getProjectRelativePath() : null;
        String filePath = relativePath == null ? "" : relativePath.lastSegment();
        return filePath;
    }

    @Override
    protected String getWaveform(IDocument document, int offset, String contextType) {
        try {
            String waveform = WaveDromManager.getInstance().getWaveform(document, this.getFile(), offset, "__e_partitioning", contextType);
            if ("WaveDrom description file not found!".equals(waveform) || "WaveDrom description file does not have a valid extension!".equals(waveform)) {
                return waveform;
            }
            return Wavedrom.getInstance().generateSVG(waveform);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }
}

