/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hover;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldUtils;
import ro.amiq.dvt.diagrams.wavedrom.IBitFieldRegister;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtilsCommon;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;

public abstract class ETextHoverParticipantCommon
implements ITextHoverParticipant {
    protected ITextEditor fTextEditor;
    protected IEPluginConfig fPluginConfig;

    protected ETextHoverParticipantCommon(IEPluginConfig pluginConfig) {
        this.fPluginConfig = pluginConfig;
    }

    public void makeInfo(ITextViewer textViewer, IRegion region, DVTTooltipContent tooltipContent) {
        try {
            IAnnotationModel annotationModel;
            if (region == null || this.fTextEditor == null) {
                return;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return;
            }
            int offset = region.getOffset();
            int line = document.getLineOfOffset(offset);
            int col = offset - DVTDocumentUtils.documentLineOffset((Object)document, (int)line);
            tooltipContent.set(DVTTooltipContent.TooltipContent.LINE, Integer.valueOf(line + 1));
            tooltipContent.set(DVTTooltipContent.TooltipContent.COLUMN, Integer.valueOf(col + 1));
            String filePath = this.getTooltipContentFilePath(textViewer);
            tooltipContent.set(DVTTooltipContent.TooltipContent.FILE, filePath);
            String contextType = ((IDocumentExtension3)document).getContentType("__e_partitioning", offset, false);
            if (contextType.equals("__dftl_partition_content_type")) {
                offset = Math.min(offset + 1, document.getLength() - 1);
                IProject project = this.getProject(this.fTextEditor);
                if (project == null) {
                    return;
                }
                RfProject rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
                if (rfProject == null) {
                    return;
                }
                if (!DVTPlugin.getDefault().collect().c(project, this.fPluginConfig.feature())) {
                    return;
                }
                RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(rfProject, this.fTextEditor, document, offset, false);
                if (elementAndScope != null) {
                    RfNamedElement element = elementAndScope.getNamedElement();
                    if (element instanceof RfStructMember) {
                        element = this.getDeclarationOf((RfStructMember)element);
                    }
                    if (element instanceof RfStructQualifier) {
                        element = elementAndScope.getOriginalElement();
                    }
                    if (element instanceof RfSubtypeElement) {
                        element = ((RfSubtypeElement)element).getNamedElement();
                    }
                    if (element instanceof IBitFieldRegister) {
                        BitFieldModel model = BitFieldUtils.getModelForEditor((DVTEditor)((DVTEditor)this.fTextEditor), (IRfNamedElementAndScope)elementAndScope, (int)offset);
                        if (Wavedrom.getInstance().isVSCode()) {
                            tooltipContent.set(DVTTooltipContent.TooltipContent.BITFIELD_REGISTER, model);
                        } else {
                            tooltipContent.set(DVTTooltipContent.TooltipContent.BITFIELD_DIAGRAM, Wavedrom.getInstance().generateBitfieldSVG(model));
                        }
                    }
                    RfUtils.getTooltipFormattedText(element, this.fPluginConfig, this.fTextEditor, tooltipContent);
                }
                if (!tooltipContent.has(DVTTooltipContent.TooltipContent.SIGNATURE) && !tooltipContent.has(DVTTooltipContent.TooltipContent.COMMENT)) {
                    boolean isDeclaration;
                    RfUtilsCommon.MacroRegion macroRegion = RfUtils.getMacro(rfProject, this.fTextEditor, document, offset);
                    if (macroRegion == null) {
                        return;
                    }
                    boolean bl = isDeclaration = macroRegion.getMacroLayer() != null && macroRegion.getMacroLayer().isDeclaration();
                    if (isDeclaration) {
                        return;
                    }
                    Set<RfNamedElement> guessedElementsUnderCursor = macroRegion.getGuessedElementsUnderCursor();
                    if (guessedElementsUnderCursor == null || guessedElementsUnderCursor.isEmpty()) {
                        RfUtils.getMacroSignature(macroRegion.getMacro(), this.fPluginConfig, this.fTextEditor, tooltipContent);
                        return;
                    }
                    RfUtils.getTooltipFormattedText(guessedElementsUnderCursor.iterator().next(), this.fPluginConfig, this.fTextEditor, tooltipContent);
                }
                return;
            }
            if (contextType.equals("__e_sl_comment") || contextType.equals("__e_ml_comment") || contextType.equals("__e_sv_ml_comment")) {
                try {
                    tooltipContent.set(DVTTooltipContent.TooltipContent.WAVEDROM_DIAGRAM, this.getWaveform(document, offset, contextType));
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            if ((annotationModel = this.getAnnotationModel(this.fTextEditor)) != null) {
                Iterator iter = annotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    Position position = annotationModel.getPosition(annotation);
                    if (!annotation.getType().equals("org.eclipse.ui.workbench.texteditor.spelling") || region.getOffset() < position.getOffset() || region.getOffset() > position.getOffset() + position.getLength()) continue;
                    tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, annotation.getText());
                    return;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private RfNamedElement getDeclarationOf(RfStructMember element) {
        RfStruct parentStruct;
        if (element instanceof RfMethod) {
            RfStruct parentStruct2 = ((RfMethod)element).getMethodInLikeParent(false);
            if (parentStruct2 != element.getParentStruct()) {
                element = parentStruct2.getMethod(element.getName());
            }
        } else if (element instanceof RfEvent && (parentStruct = ((RfEvent)element).getEventInLikeParent(RfEventLayer.class, false)) != element.getParentStruct()) {
            element = parentStruct.getEvent(element.getName());
        }
        return element;
    }

    public void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected abstract String getTooltipContentFilePath(ITextViewer var1);

    protected abstract IProject getProject(ITextEditor var1);

    protected abstract IFile getFile();

    protected abstract IAnnotationModel getAnnotationModel(ITextEditor var1);

    protected abstract String getWaveform(IDocument var1, int var2, String var3);
}

