/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hyperlink.DVTCommentHyperlinkDetector;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkTimeoutException;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.edt.base.utils.EDTBaseLinkResolver;

public class CommentHyperlinkDetector
extends DVTCommentHyperlinkDetector {
    private IEPluginConfig fPluginConfig;

    public CommentHyperlinkDetector(IEPluginConfig pluginConfig, AbstractEEditor editor) {
        super((DVTEditor)editor, (IRfSingleLangProject)editor.getRfProject());
        this.fPluginConfig = pluginConfig;
    }

    protected List<IHyperlink> solveHyperlinkForAllCandidates(Collection<IRfNamedElement> candidates, String[] types, IRegion region, IDocument document, long timeoutTime) throws HyperlinkTimeoutException {
        ArrayList<IHyperlink> actionHyperlinks = new ArrayList<IHyperlink>();
        for (IRfNamedElement candidate : candidates) {
            this.recursiveSolveHyperlink(candidate, types, 0, actionHyperlinks, region, timeoutTime);
        }
        if (types.length != 1 || candidates.isEmpty()) {
            return actionHyperlinks;
        }
        IRfNamedElement firstCandidate = candidates.iterator().next();
        if (candidates.size() == 1 && RfStruct.isPackageElement(firstCandidate, false)) {
            return actionHyperlinks;
        }
        for (IRfNamedElement candidate : candidates) {
            RfNamedElementActionHyperlink hyperlink;
            RfNamedElement potentialMacro = EDTBaseLinkResolver.searchForMacro(candidate, types[0]);
            if (potentialMacro == null || (hyperlink = RfUtils.createOpenAction(this.fPluginConfig, potentialMacro, potentialMacro.getRfProject().getProject(), region, this.getFullName(potentialMacro))) == null || actionHyperlinks.contains(hyperlink)) continue;
            actionHyperlinks.add((IHyperlink)hyperlink);
            break;
        }
        return actionHyperlinks;
    }

    protected void recursiveSolveHyperlink(IRfNamedElement currentElement, String[] types, int index, List<IHyperlink> actionHyperlinks, IRegion region, long timeoutTime) throws HyperlinkTimeoutException {
        if (System.currentTimeMillis() > timeoutTime) {
            throw new HyperlinkTimeoutException();
        }
        if (!(currentElement instanceof RfNamedElement) || types == null) {
            return;
        }
        RfNamedElement element = (RfNamedElement)currentElement;
        if (index >= types.length) {
            RfNamedElementActionHyperlink hyperlink = RfUtils.createOpenAction(this.fPluginConfig, element.getDeclaration(), element.getRfProject().getProject(), region, false, this.getFullName(element));
            if (hyperlink != null && !actionHyperlinks.contains(hyperlink)) {
                actionHyperlinks.add((IHyperlink)hyperlink);
            }
            return;
        }
        ArrayList<RfNamedElement> members = new ArrayList<RfNamedElement>();
        members.addAll(EDTBaseLinkResolver.getCandidatesInScope(element));
        if (members.isEmpty()) {
            return;
        }
        String[] elementArgs = EDTBaseLinkResolver.extractArgs(types[index]);
        String name = EDTBaseLinkResolver.extractName(types[index]);
        for (RfNamedElement member : members) {
            if (!types[index].equals(member.getName()) && !EDTBaseLinkResolver.isElementWithGenericParams(member, elementArgs, name)) continue;
            this.recursiveSolveHyperlink(member, types, index + 1, actionHyperlinks, region, timeoutTime);
        }
    }

    protected Collection<IRfNamedElement> getInitialCandidates(IDocument document, int startOffset) throws BadLocationException {
        IRfScopeElement scope = RfUtils.getRfScope(this.fPluginConfig.getRfManager(), (ITextEditor)this.getEditor(), document, startOffset, document.getLineOfOffset(startOffset));
        if (scope == null) {
            return null;
        }
        Collection<IRfNamedElement> result = EDTBaseLinkResolver.getInitialCandidatesInScope(scope);
        IRfScopeElement elementScope = this.getRfScopeOfElementForCommentOffset((ITextEditor)this.getEditor(), document, startOffset);
        if (elementScope != null && !elementScope.equals(scope) && elementScope instanceof RfDefElement) {
            result.add(((RfDefElement)elementScope).getNamedElement());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRfScopeElement getRfScopeOfElementForCommentOffset(ITextEditor textEditor, IDocument document, int offset) throws BadLocationException {
        line = document.getLineOfOffset(offset);
        while (this.isInCommentPartition(document, offset)) {
            line = document.getLineOfOffset(offset);
            offset = document.getLineOffset(line + 1);
        }
        try {
            block11: {
                if (offset < 0) {
                    return null;
                }
                scanner = new DVTCharacterScanner(100, document, offset, true);
                ch = (char)scanner.read();
                if (ch == '\uffff') {
                    return null;
                }
                do {
                    if (Character.isWhitespace(ch)) continue;
                    project = this.getProject();
                    if (!(project instanceof RfProject)) {
                        return null;
                    }
                    break block11;
                } while ((ch = (char)scanner.read()) != '\uffff');
                return null;
            }
            skipMaxEmptyLinesAbove = (Integer)BuildConfigManager.getDVTConfig((IProject)project.getProject(), (IBuildConfigParserConstants.Directive)IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_ABOVE_MAX_EMPTY_LINES);
            newLine = document.getLineOfOffset(scanner.getOffset());
            if (newLine - line > skipMaxEmptyLinesAbove + 1) {
                return null;
            }
            if (this.isInCommentPartition(document, scanner.getOffset())) {
                return null;
            }
            while (Character.isJavaIdentifierPart(ch)) {
                ch = (char)scanner.read();
                if (ch != '\uffff') continue;
                return null;
            }
            if (true) ** GOTO lbl39
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return RfUtils.getRfScope(this.fPluginConfig.getRfManager(), textEditor, document, offset, document.getLineOfOffset(offset));
        do {
            if ((ch = (char)scanner.read()) != '\uffff') continue;
            return null;
lbl39:
            // 2 sources

        } while (Character.isWhitespace(ch));
        offset = scanner.getOffset();
        return RfUtils.getRfScope(this.fPluginConfig.getRfManager(), textEditor, document, offset, document.getLineOfOffset(offset));
    }

    protected boolean isInCommentPartition(IDocument document, int offset) {
        String typedRegion = RfUtils.getTypedRegion(document, offset).getType();
        return "__e_sl_comment".equals(typedRegion) || "__e_ml_comment".equals(typedRegion) || "__e_sv_ml_comment".equals(typedRegion);
    }

    protected List<IRfNamedElement> getPackageCandidates(DVTCommentHyperlinkDetector.ParseCommentResult parsedComment) {
        IRfSingleLangProject project = this.getProject();
        if (!(project instanceof RfProject)) {
            return null;
        }
        return EDTBaseLinkResolver.getPackageCandidatesFromProject(parsedComment.getPackageName(), (RfProject)project);
    }

    private String getFullName(RfNamedElement element) {
        RfModule module = element.getModule();
        String label = element.getName();
        if (module != null) {
            String elementFullName = element.getFullName().toString();
            if (elementFullName.charAt(0) == '.') {
                elementFullName = elementFullName.substring(1);
            }
            label = element instanceof RfMacro ? elementFullName : String.valueOf(element.getModule().getPackageName()) + "::" + elementFullName;
        }
        return "Open " + element.getKindName() + " " + label;
    }
}

