/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.hyperlink.ActionHyperlink;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class ImportHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;
    private IEPluginConfig fPluginConfig;
    private DVTStringBuilder fText;

    public ImportHyperlinkDetector(IEPluginConfig pluginConfig, ITextEditor editor) {
        this.fTextEditor = editor;
        this.fPluginConfig = pluginConfig;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || this.fTextEditor == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return this.computeHyperlink(document, file, project, region);
    }

    public IHyperlink[] computeHyperlink(IDocument document, IFile file, IProject project, IRegion region) {
        int offset = region.getOffset();
        IRegion wordRegion = this.selectWord(document, offset);
        if (wordRegion == null || wordRegion.getLength() == 0) {
            return null;
        }
        String knownPath = this.fText.toString();
        final String fromPath = file.getLocation().removeLastSegments(1).toOSString();
        final IProject finalProject = project;
        String replaced = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)knownPath, DVTUtilsCommon.ReplaceSysvarsPolicy.REPLACE_WITH_EMPTY, (DVTUtilsCommon.IEnvironmentProvider)this.fPluginConfig.getModelManager().getEModel().getEProject(project));
        if (Path.fromOSString((String)replaced).lastSegment().indexOf(46) < 0 && replaced.indexOf(36) < 0) {
            replaced = String.valueOf(replaced) + ".e";
        }
        final String finalKnownPath = replaced != null ? replaced : knownPath;
        Action openAction = new Action(){

            public void run() {
                EDTFileUtils.getInstance().openFile(ImportHyperlinkDetector.this.fPluginConfig.getModelManager(), finalProject, fromPath, finalKnownPath, 1, null);
            }

            public String getPath() {
                if (Path.fromOSString((String)finalKnownPath).isAbsolute()) {
                    return finalKnownPath;
                }
                IPath filePath = Path.fromOSString((String)fromPath).append(finalKnownPath);
                if (filePath.toFile().exists()) {
                    return filePath.toOSString();
                }
                return EDTFileUtils.getInstance().getPathFromSpecmanPath(ImportHyperlinkDetector.this.fPluginConfig.getModelManager(), finalProject, fromPath, finalKnownPath, 1, null);
            }

            public int getLine() {
                return 1;
            }
        };
        return new IHyperlink[]{new ImportHyperlink(wordRegion, knownPath, (IAction)openAction)};
    }

    private IRegion selectWord(IDocument document, int anchor) {
        int start;
        char c;
        int offset;
        block10: {
            this.fText = new DVTStringBuilder();
            offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (Character.isWhitespace(c) || c == ';' || c == ',' || c == '(') break;
                this.fText.prepend(c);
                --offset;
            }
            start = offset--;
            boolean foundImport = false;
            DVTStringBuilder matchImport = new DVTStringBuilder();
            while (offset >= 0) {
                c = document.getChar(offset);
                if (c == ';') break;
                matchImport.prepend(c);
                if (matchImport.length() > 6) {
                    matchImport.deleteLastChar();
                }
                if (matchImport.toString().equals("import")) {
                    foundImport = true;
                    break;
                }
                --offset;
            }
            if (foundImport) break block10;
            return null;
        }
        try {
            int end;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (Character.isWhitespace(c) || c == ';' || c == ',' || c == ')') break;
                if (offset != anchor) {
                    this.fText.append(c);
                }
                ++offset;
            }
            if (start == (end = offset)) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    static class ImportHyperlink
    extends ActionHyperlink {
        private String fKnownPath;

        public ImportHyperlink(IRegion region, String knownPath, IAction action) {
            super(region, action);
            this.fKnownPath = knownPath;
        }

        @Override
        public String getHyperlinkText() {
            return DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.jumpToFile, (Object[])new Object[]{this.fKnownPath});
        }

        public IRfNamedElement getRfNamedElement() {
            return null;
        }
    }
}

