/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hyperlink;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkDetector;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkUtils;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTableDefine;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.AbstractEVHBreadcrumbUtils;
import ro.amiq.edt.base.ui.editor.EWordFinder;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.edt.base.ui.editor.actions.ShowConstraintsAction;
import ro.amiq.edt.base.ui.editor.actions.ShowEmittersAction;
import ro.amiq.edt.base.ui.editor.actions.ShowInstancesAction;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.edt.base.utils.Utils;

public class RfHyperlinkDetector
extends DVTHyperlinkDetector {
    private static final Object OPEN_WHEN_SUBTYPE = "Open When Subtype";
    private static final Object OPEN_UNIT_INSTANCE_TYPE = "Open Unit Instance Type";
    private static final Object OPEN_DECLARATION = "Open Declaration";
    private IEPluginConfig fPluginConfig;

    public RfHyperlinkDetector(IEPluginConfig pluginConfig, ITextEditor editor) {
        this.fTextEditor = editor;
        this.fPluginConfig = pluginConfig;
    }

    public IDVTHyperlink[] detectHyperlinksInternal(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || !(this.fTextEditor instanceof AbstractEEditor)) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        if (!(this.fTextEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fTextEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        int offset = Math.min(region.getOffset() + 1, document.getLength() - 1);
        LinkedList<IDVTHyperlink> hyperlinks = new LinkedList<IDVTHyperlink>();
        RfNamedElement namedElement = null;
        IDVTHyperlink showUsages = null;
        IDVTHyperlink showReaders = null;
        IDVTHyperlink showWriters = null;
        IDVTHyperlink showLayers = null;
        IDVTHyperlink showConstraints = null;
        IDVTHyperlink showEmitters = null;
        IDVTHyperlink showInstances = null;
        boolean isHyperlinkRunTimeInfoEnabled = BuildConfigManager.isDebugHyperlinkRunTimeInfo((IProject)project);
        long start = System.currentTimeMillis();
        List<RfNamedElementActionHyperlink> hyperlinkActions = RfUtils.getRfNamedElementActionHyperlink(this.fPluginConfig, this.fTextEditor, project, document, offset, true, false);
        if (isHyperlinkRunTimeInfoEnabled) {
            DVTHyperlinkUtils.getInstance().reportHyperlinkElementFromCursorBenchmark(System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        try {
            RfNamedElementActionHyperlink associatedTypeLink;
            if (!hyperlinkActions.isEmpty()) {
                String hyperlinkLabel;
                RfNamedElementActionHyperlink firstHyperlinkAction = hyperlinkActions.get(0);
                showUsages = this.createUsagesHyperlink(firstHyperlinkAction);
                showReaders = this.createReadersHyperlink(firstHyperlinkAction);
                showWriters = this.createWritersHyperlink(firstHyperlinkAction);
                showLayers = this.createLayersHyperlink(firstHyperlinkAction);
                showConstraints = this.createShowConstraintsHyperlink(firstHyperlinkAction, namedElement);
                showEmitters = this.createShowEmittersHyperlink(firstHyperlinkAction, namedElement);
                showInstances = this.createShowInstancesHyperlink(firstHyperlinkAction, namedElement);
                LinkedHashMap<String, RfNamedElementActionHyperlink> uniqueOpenDeclarations = new LinkedHashMap<String, RfNamedElementActionHyperlink>();
                for (RfNamedElementActionHyperlink hyperlinkAction : hyperlinkActions) {
                    RfNamedElement element;
                    if (hyperlinkAction.hasBindLabel() || hyperlinkAction.hasSubtypeLabel() || hyperlinkAction.hasDeterminantLabel() || hyperlinkAction.hasImplementationLabel() || (element = hyperlinkAction.getRfNamedElement()) == null || element.getFullName() == null || element.getFullName().toString() == null || uniqueOpenDeclarations.containsKey(element.getFullName().toString())) continue;
                    uniqueOpenDeclarations.put(element.getFullName().toString(), hyperlinkAction);
                }
                int nofOpenDeclaration = uniqueOpenDeclarations.size();
                for (RfNamedElementActionHyperlink hyperlinkAction : uniqueOpenDeclarations.values()) {
                    hyperlinkLabel = DVTHyperlinkMessages.openDeclaration;
                    RfNamedElement element = hyperlinkAction.getRfNamedElement();
                    if (nofOpenDeclaration > 1) {
                        hyperlinkLabel = element instanceof RfMacro ? String.valueOf(hyperlinkLabel) + " <" + element.getName() + ">" : String.valueOf(hyperlinkLabel) + " [" + element.getFullName().toString() + "]";
                    }
                    hyperlinks.add(this.createHyperlink(hyperlinkAction, hyperlinkLabel));
                }
                for (RfNamedElementActionHyperlink hyperlinkAction : hyperlinkActions) {
                    hyperlinkLabel = DVTHyperlinkMessages.openDeclaration;
                    if (hyperlinkAction.hasBindLabel()) {
                        hyperlinkLabel = DVTHyperlinkMessages.jumpToBinding;
                    } else if (hyperlinkAction.hasSubtypeLabel()) {
                        hyperlinkLabel = DVTHyperlinkMessages.openWhenSubtype;
                    } else if (hyperlinkAction.hasDeterminantLabel()) {
                        hyperlinkLabel = DVTHyperlinkMessages.openDeterminant;
                    } else {
                        if (!hyperlinkAction.hasImplementationLabel()) continue;
                        hyperlinkLabel = DVTHyperlinkMessages.openImplementation;
                    }
                    hyperlinks.add(this.createHyperlink(hyperlinkAction, hyperlinkLabel));
                }
            } else {
                RfProject rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
                if (rfProject == null) {
                    return null;
                }
                IRegion wordAtOffset = EWordFinder.getDefault().getWordAtOffset(document, offset);
                RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(rfProject, this.fTextEditor, document, offset, true);
                if (elementAndScope != null && (namedElement = elementAndScope.getNamedElement()) != null && namedElement.isPredefined()) {
                    hyperlinks.add(this.createPredefinedHyperlink(wordAtOffset));
                    showUsages = this.createUsagesHyperlink(project, namedElement, wordAtOffset);
                    showReaders = this.createReadersHyperlink(project, namedElement, wordAtOffset);
                    showWriters = this.createWritersHyperlink(project, namedElement, wordAtOffset);
                    showLayers = this.createLayersHyperlink(project, namedElement, wordAtOffset);
                    showEmitters = this.createShowEmittersHyperlink(project, namedElement, wordAtOffset);
                }
            }
            List<RfNamedElementActionHyperlink> firstImplHyperlinkActions = RfUtils.getRfNamedElementActionHyperlink(this.fPluginConfig, this.fTextEditor, project, document, offset, true, true);
            if (!firstImplHyperlinkActions.isEmpty()) {
                RfNamedElementActionHyperlink firstHyperlinkAction = firstImplHyperlinkActions.get(0);
                if (namedElement == null) {
                    namedElement = firstHyperlinkAction.getRfNamedElement();
                }
                if (showUsages == null) {
                    showUsages = this.createUsagesHyperlink(firstHyperlinkAction);
                }
                if (showReaders == null) {
                    showReaders = this.createReadersHyperlink(firstHyperlinkAction);
                }
                if (showWriters == null) {
                    showWriters = this.createWritersHyperlink(firstHyperlinkAction);
                }
                if (showLayers == null) {
                    showLayers = this.createLayersHyperlink(firstHyperlinkAction);
                }
                if (showConstraints == null) {
                    showConstraints = this.createShowConstraintsHyperlink(firstHyperlinkAction, namedElement);
                }
                if (showEmitters == null) {
                    showEmitters = this.createShowEmittersHyperlink(firstHyperlinkAction, namedElement);
                }
                if (showInstances == null) {
                    showInstances = this.createShowInstancesHyperlink(firstHyperlinkAction, namedElement);
                }
                if (namedElement instanceof RfMethod || namedElement instanceof RfEvent) {
                    boolean firstImplementation = this.fPluginConfig.getPlugin().getPreferenceStore().getBoolean("editor.jump_to_defined_method_layer");
                    if (!this.isDuplicate(hyperlinkActions, firstHyperlinkAction)) {
                        if (firstImplementation) {
                            hyperlinks.add(0, this.createHyperlink(firstHyperlinkAction, DVTHyperlinkMessages.openFirstImplementation));
                        } else {
                            hyperlinks.add(this.createHyperlink(firstHyperlinkAction, DVTHyperlinkMessages.openFirstImplementation));
                        }
                    }
                }
            }
            if (namedElement == null) {
                return null;
            }
            if (canShowMultipleHyperlinks && (associatedTypeLink = RfUtils.getAssociatedTypeHyperlink(this.fPluginConfig, this.fTextEditor, project, document, offset, true, false)) != null && !this.isDuplicate(hyperlinkActions, associatedTypeLink)) {
                String labelType = RfUtils.getAssociatedTypeHyperlinkLabelPart(namedElement);
                String hyperlinkLabel = labelType.isEmpty() ? DVTHyperlinkMessages.openEmptyTypeDeclaration : DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openTypeDeclaration, (Object[])new Object[]{labelType});
                hyperlinks.add(this.createHyperlink(associatedTypeLink, hyperlinkLabel));
            }
            if (showConstraints != null) {
                hyperlinks.add(showConstraints);
            }
            if (showEmitters != null) {
                hyperlinks.add(showEmitters);
            }
            if (showLayers != null && !(namedElement instanceof RfTableDefine)) {
                hyperlinks.add(showLayers);
            }
            if (showInstances != null) {
                hyperlinks.add(showInstances);
            }
            if (showReaders != null && !(namedElement instanceof RfTableDefine)) {
                hyperlinks.add(showReaders);
            }
            if (showWriters != null && !(namedElement instanceof RfTableDefine)) {
                hyperlinks.add(showWriters);
            }
            if (showUsages != null && !(namedElement instanceof RfTableDefine)) {
                hyperlinks.add(showUsages);
            }
            IDVTHyperlink[] iDVTHyperlinkArray = hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
            return iDVTHyperlinkArray;
        }
        finally {
            if (isHyperlinkRunTimeInfoEnabled) {
                DVTHyperlinkUtils.getInstance().reportHyperlinkProposalsBenchmark(System.currentTimeMillis() - start);
            }
        }
    }

    private IDVTHyperlink createShowConstraintsHyperlink(RfNamedElementActionHyperlink hyperlink, IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfField)) {
            return null;
        }
        if (!((RfField)namedElement).isGenerated()) {
            return null;
        }
        return this.createConstraintsHyperlink(hyperlink, namedElement);
    }

    private IDVTHyperlink createShowEmittersHyperlink(RfNamedElementActionHyperlink hyperlink, IRfNamedElement namedElement) {
        if (!Utils.canShowEmitters(namedElement)) {
            return null;
        }
        if ((namedElement = Utils.getEvent((RfNamedElement)namedElement)) == null) {
            return null;
        }
        return this.createEmittersHyperlink(hyperlink, namedElement);
    }

    private IDVTHyperlink createUsagesHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    IProject project = hyperlinkAction.getProject();
                    RfProject rfProject = RfHyperlinkDetector.this.fPluginConfig.getRfManager().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    RfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
                    ReferencesInWorkspaceAction.searchReferencesHelper(RfHyperlinkDetector.this.fPluginConfig, project, namedElement, searchScope, RWSearchTypeEnum.USAGES);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
    }

    private IDVTHyperlink createReadersHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        if (!Utils.shouldShowReadersWriters(hyperlinkAction.getRfNamedElement())) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showReadersUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    IProject project = hyperlinkAction.getProject();
                    RfProject rfProject = RfHyperlinkDetector.this.fPluginConfig.getRfManager().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    RfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
                    ReferencesInWorkspaceAction.searchReferencesHelper(RfHyperlinkDetector.this.fPluginConfig, project, namedElement, searchScope, RWSearchTypeEnum.READERS);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
    }

    private IDVTHyperlink createWritersHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        if (!Utils.shouldShowReadersWriters(hyperlinkAction.getRfNamedElement())) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showWritersUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    IProject project = hyperlinkAction.getProject();
                    RfProject rfProject = RfHyperlinkDetector.this.fPluginConfig.getRfManager().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    RfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
                    ReferencesInWorkspaceAction.searchReferencesHelper(RfHyperlinkDetector.this.fPluginConfig, project, namedElement, searchScope, RWSearchTypeEnum.WRITERS);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
    }

    private IDVTHyperlink createUsagesHyperlink(final IProject project, final RfNamedElement namedElement, final IRegion region) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    RfProject rfProject = RfHyperlinkDetector.this.fPluginConfig.getRfManager().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    ReferencesInWorkspaceAction.searchReferencesHelper(RfHyperlinkDetector.this.fPluginConfig, project, namedElement, searchScope, RWSearchTypeEnum.USAGES);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public String getTypeLabel() {
                return null;
            }
        };
    }

    private IDVTHyperlink createReadersHyperlink(final IProject project, final RfNamedElement namedElement, final IRegion region) {
        if (!Utils.shouldShowReadersWriters(namedElement)) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showReadersUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    RfProject rfProject = RfHyperlinkDetector.this.fPluginConfig.getRfManager().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    ReferencesInWorkspaceAction.searchReferencesHelper(RfHyperlinkDetector.this.fPluginConfig, project, namedElement, searchScope, RWSearchTypeEnum.READERS);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public String getTypeLabel() {
                return null;
            }
        };
    }

    private IDVTHyperlink createWritersHyperlink(final IProject project, final RfNamedElement namedElement, final IRegion region) {
        if (!Utils.shouldShowReadersWriters(namedElement)) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showWritersUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    RfProject rfProject = RfHyperlinkDetector.this.fPluginConfig.getRfManager().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    ReferencesInWorkspaceAction.searchReferencesHelper(RfHyperlinkDetector.this.fPluginConfig, project, namedElement, searchScope, RWSearchTypeEnum.WRITERS);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public String getTypeLabel() {
                return null;
            }
        };
    }

    private IDVTHyperlink createShowEmittersHyperlink(IProject project, final RfNamedElement namedElement, final IRegion region) {
        if (!Utils.canShowEmitters(namedElement)) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showEmitters;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                ShowEmittersAction.showEmitters(namedElement, RfHyperlinkDetector.this.fPluginConfig);
            }

            public String getTypeLabel() {
                return null;
            }
        };
    }

    private IDVTHyperlink createPredefinedHyperlink(final IRegion region) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.predefined;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
            }

            public String getTypeLabel() {
                return null;
            }
        };
    }

    private IDVTHyperlink createLayersHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        RfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
        if (!this.canShowLayers(namedElement)) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showLayers;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                IProject project = hyperlinkAction.getProject();
                RfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
                RfDefElement declaration = namedElement.getDeclaration();
                RfStructLayer structLayer = null;
                if (declaration != null) {
                    structLayer = declaration.getStructLayer();
                }
                RfStruct struct = null;
                if (structLayer != null) {
                    struct = structLayer.getStruct();
                }
                EQuickViewersUtil.getInstance().updateLayersView(RfHyperlinkDetector.this.fPluginConfig, namedElement, project, struct, true, DVTViewEvent.EventKind.TRIGGER, "context_menu", true);
            }
        };
    }

    private IDVTHyperlink createLayersHyperlink(final IProject project, final RfNamedElement namedElement, final IRegion region) {
        if (!this.canShowLayers(namedElement)) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getTypeLabel() {
                return null;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showLayers;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                RfDefElement declaration = namedElement.getDeclaration();
                RfStructLayer structLayer = null;
                if (declaration != null) {
                    structLayer = declaration.getStructLayer();
                }
                RfStruct struct = null;
                if (structLayer != null) {
                    struct = structLayer.getStruct();
                }
                EQuickViewersUtil.getInstance().updateLayersView(RfHyperlinkDetector.this.fPluginConfig, namedElement, project, struct, true, DVTViewEvent.EventKind.TRIGGER, "context_menu", true);
            }
        };
    }

    private boolean canShowLayers(RfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfModule) {
            return false;
        }
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).isPackage()) {
            return false;
        }
        if (namedElement instanceof RfCheckThat) {
            return false;
        }
        if (namedElement instanceof RfCoverItem) {
            return false;
        }
        return namedElement.getFirstLayer() != null;
    }

    private IDVTHyperlink createConstraintsHyperlink(final RfNamedElementActionHyperlink hyperlinkAction, final IRfNamedElement element) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showConstraints;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                ShowConstraintsAction.showConstraints((RfField)element);
            }
        };
    }

    private IDVTHyperlink createEmittersHyperlink(final RfNamedElementActionHyperlink hyperlinkAction, final IRfNamedElement element) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showEmitters;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                ShowEmittersAction.showEmitters((RfNamedElement)element, RfHyperlinkDetector.this.fPluginConfig);
            }
        };
    }

    private boolean isDuplicate(List<RfNamedElementActionHyperlink> list, RfNamedElementActionHyperlink element) {
        if (list == null || element == null) {
            return false;
        }
        for (RfNamedElementActionHyperlink actionHyperlink : list) {
            if (!actionHyperlink.getFullPath().equalsIgnoreCase(element.getFullPath()) || actionHyperlink.getLine() != element.getLine()) continue;
            return true;
        }
        return false;
    }

    protected void openShowInstances(IRfNamedElement element) {
        ShowInstancesAction.showInstances(element);
    }

    protected void openShowInstancesInDH(IRfNamedElement element) {
    }

    protected IActionHyperlink createOpenAction(IRfInstanceElement targetNamedElement, IProject project, IRegion region) {
        return null;
    }

    protected void openShowReadersUsages(IActionHyperlink hyperlink) {
    }

    protected void openShowWritersUsages(IActionHyperlink hyperlink) {
    }

    protected void setDataForBreadcrumb(IActionHyperlink hyperlink, String label) {
        if (!(this.fTextEditor instanceof DVTEditor)) {
            return;
        }
        this.setDataForVHBreadcrumb((DVTEditor)this.fTextEditor, label, hyperlink);
    }

    protected void setDataForVHBreadcrumb(DVTEditor activeEditor, String label, IActionHyperlink hyperlink) {
        try {
            IRfFileDef defFile;
            if (!(hyperlink instanceof RfNamedElementActionHyperlink)) {
                return;
            }
            RfNamedElementActionHyperlink hyperlinkAction = (RfNamedElementActionHyperlink)hyperlink;
            if (!activeEditor.hasBreadcrumbViewer(new Class[]{VHBreadcrumbViewer.class})) {
                return;
            }
            if (!(OPEN_WHEN_SUBTYPE.equals(label) || OPEN_UNIT_INSTANCE_TYPE.equals(label) || OPEN_DECLARATION.equals(label))) {
                return;
            }
            RfNamedElement hyperlinkNamedElement = hyperlinkAction.getRfNamedElement();
            if (!(hyperlinkNamedElement instanceof RfStruct) || !((RfStruct)hyperlinkNamedElement).isUnit()) {
                return;
            }
            AbstractBreadcrumbViewer breadcrumbViewer = activeEditor.getBreadcrumbViewer(VHBreadcrumbViewer.class);
            if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
                return;
            }
            BreadcrumbInput oldInput = breadcrumbViewer.getInput();
            if (oldInput == null) {
                return;
            }
            Determinant hperlinkElement = null;
            Object meta = hyperlinkAction.getMeta("ASSOC_TYPE_OF");
            if (meta instanceof Determinant) {
                hperlinkElement = (Determinant)meta;
                hyperlinkAction.setMeta("ASSOC_TYPE_OF", null);
            }
            if (hperlinkElement == null) {
                return;
            }
            AbstractBreadcrumbUtils utils = activeEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
            if (!(utils instanceof AbstractEVHBreadcrumbUtils)) {
                return;
            }
            RfDefElement toAppend = ((AbstractEVHBreadcrumbUtils)utils).getSegmentToAppend(hperlinkElement, oldInput, activeEditor.getProject());
            if (toAppend == null) {
                return;
            }
            BreadcrumbInput newInput = new BreadcrumbInput(activeEditor.getProject(), oldInput, utils.getBreadcrumbSerializer());
            newInput.append((IRfBreadcrumbElement)toAppend);
            RfDefElement defElement = hyperlinkAction.getDefElement();
            if (defElement == null) {
                RfNamedElement rfNamedElement = hyperlinkAction.getRfNamedElement();
                if (rfNamedElement == null) {
                    return;
                }
                defElement = rfNamedElement.getDeclaration();
                if (defElement == null) {
                    return;
                }
            }
            if ((defFile = defElement.getDefFile()) == null) {
                return;
            }
            IResource file = (IResource)defFile.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)newInput);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected LanguageKind getSourceLanguageKind() {
        return LanguageKind.E;
    }

    public DVTWordFinder getWordFinder() {
        return EWordFinder.getDefault();
    }

    public List<String> getDefaultHyperlinks() {
        return DVTHyperlinkMessages.getELANGDefaultHyperlinks();
    }
}

