/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.hyperlink;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.ui.editor.hyperlink.ActionHyperlink;

public class RfNamedElementActionHyperlink
extends ActionHyperlink {
    private final IProject fProject;
    private final RfNamedElement fNamedElement;
    private final boolean fhasBindLabel;
    private IRfScope fScope;
    private boolean fhasSubtypeLabel;
    private boolean fhasDeterminantLabel;
    private boolean fhasImplementationLabel;
    private String fFullPath;
    private int fLine;
    private Map<String, Object> fMetadata;
    private final RfDefElement fDefElement;

    public RfNamedElementActionHyperlink(IProject project, RfNamedElement namedElement, boolean hasBindLabel, boolean hasDeterminantLabel, IRegion region, IAction action, String fullPath, int line, String hyperlinkText) {
        super(region, action, hyperlinkText);
        Assert.isNotNull((Object)project);
        this.fProject = project;
        Assert.isNotNull((Object)namedElement);
        this.fNamedElement = namedElement;
        this.fDefElement = null;
        this.fhasSubtypeLabel = false;
        this.fhasDeterminantLabel = hasDeterminantLabel;
        this.fhasBindLabel = hasBindLabel;
        this.fhasImplementationLabel = false;
        this.fFullPath = fullPath;
        this.fLine = line;
    }

    public RfNamedElementActionHyperlink(IProject project, RfNamedElement namedElement, boolean hasBindLabel, boolean hasDeterminantLabel, IRegion region, IAction action, String fullPath, int line) {
        this(project, namedElement, hasBindLabel, hasDeterminantLabel, region, action, fullPath, line, null);
    }

    public RfNamedElementActionHyperlink(IProject project, RfDefElement defElement, boolean hasSubtypeLabel, IRegion region, IAction action, String fullPath, int line) {
        this(project, defElement, hasSubtypeLabel, region, action, fullPath, line, null);
    }

    public RfNamedElementActionHyperlink(IProject project, RfDefElement defElement, boolean hasSubtypeLabel, IRegion region, IAction action, String fullPath, int line, String hyperlinkText) {
        super(region, action, hyperlinkText);
        Assert.isNotNull((Object)project);
        this.fProject = project;
        Assert.isNotNull((Object)defElement);
        Assert.isNotNull((Object)defElement.getNamedElement());
        this.fNamedElement = defElement.getNamedElement();
        this.fDefElement = defElement;
        this.fhasSubtypeLabel = hasSubtypeLabel;
        this.fhasDeterminantLabel = false;
        this.fhasBindLabel = false;
        this.fhasImplementationLabel = false;
        this.fFullPath = fullPath;
        this.fLine = line;
    }

    public RfNamedElement getRfNamedElement() {
        return this.fNamedElement;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setScope(IRfScope scope) {
        this.fScope = scope;
    }

    @Override
    public IRfScope getScope() {
        return this.fScope;
    }

    public String getFullPath() {
        return this.fFullPath;
    }

    public int getLine() {
        return this.fLine;
    }

    public boolean hasBindLabel() {
        return this.fhasBindLabel;
    }

    public boolean hasSubtypeLabel() {
        return this.fhasSubtypeLabel;
    }

    public boolean hasDeterminantLabel() {
        return this.fhasDeterminantLabel;
    }

    public void setHasImplementationLabel(boolean has) {
        this.fhasImplementationLabel = has;
    }

    public boolean hasImplementationLabel() {
        return this.fhasImplementationLabel;
    }

    public RfDefElement getDefElement() {
        return this.fDefElement;
    }

    public void setMeta(String key, Object value) {
        if (this.fMetadata == null) {
            this.fMetadata = new HashMap<String, Object>();
        }
        this.fMetadata.put(key, value);
    }

    public Object getMeta(String key) {
        if (this.fMetadata == null) {
            return null;
        }
        return this.fMetadata.get(key);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfNamedElementActionHyperlink other = (RfNamedElementActionHyperlink)obj;
        if (this.getHyperlinkText() == null && other.getHyperlinkText() != null) {
            return false;
        }
        if (this.getHyperlinkText() != null && !this.getHyperlinkText().equals(other.getHyperlinkText())) {
            return false;
        }
        if (this.getHyperlinkRegion() != null && !this.getHyperlinkRegion().equals(other.getHyperlinkRegion())) {
            return false;
        }
        return this.getFullPath() == null || this.getFullPath().equals(other.getFullPath());
    }
}

