/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.lazy.outline;

import antlr.collections.AST;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.ui.editor.lazy.outline.ELazyOutlineProviderCommon;
import ro.amiq.edt.base.ui.editor.lazy.outline.EOutlineUtil;

public class ELazyOutlineProvider
extends ELazyOutlineProviderCommon {
    public static final Map<LanguageKind, Map<String, String>> E_OUTLINE_FIELDS = new EnumMap<LanguageKind, Map<String, String>>(LanguageKind.class){
        private static final long serialVersionUID = 1L;
        {
            this.putt("Show actions", "outline.show_actions", LanguageKind.SLN);
            this.putt("Show components", "outline.show_components", LanguageKind.SLN);
            this.putt("Show cover definitions", "outline.show_coverdefs", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show events", "outline.show_events", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show expects", "outline.show_expects", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show fields", "outline.show_fields", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show macros", "outline.show_macros", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show methods", "outline.show_methods", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show method types", "outline.show_methodtypes", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show on event", "outline.show_onevent", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show structs", "outline.show_structs", LanguageKind.SLN, LanguageKind.E);
            this.putt("Show tokens", "outline.show_tokens", LanguageKind.SLN);
            this.putt("Show types", "outline.show_types", LanguageKind.SLN, LanguageKind.E);
        }

        private void putt(String name, String prefName, LanguageKind ... languageKinds) {
            if (languageKinds == null) {
                return;
            }
            LanguageKind[] languageKindArray = languageKinds;
            int n = languageKinds.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageKind lk = languageKindArray[n2];
                TreeMap<String, String> m = (TreeMap<String, String>)this.get(lk);
                if (m == null) {
                    m = new TreeMap<String, String>();
                    this.put(lk, m);
                }
                m.put(name, prefName);
                ++n2;
            }
        }
    };

    public ELazyOutlineProvider(DVTEditor editor, IEPluginConfig pluginConfig) {
        super(editor, pluginConfig);
    }

    public IRfFileDef getFileDef() {
        AbstractRfManager rfManager = this.pluginConfig.getRfManager();
        if (rfManager == null) {
            return null;
        }
        RfProject rfProject = rfManager.getRfProject(this.editor.getProject());
        if (rfProject == null) {
            return null;
        }
        IFile file = (IFile)this.editor.getAdapter(IResource.class);
        if (file == null) {
            return null;
        }
        return rfProject.getModule((IResource)file);
    }

    public boolean isOutlineElement(IRfDefElement def) {
        return EOutlineUtil.INSTANCE.isOutlineElement(def);
    }

    @Override
    public DVTGUIFilterMatcher.GUIFilterResult getFilterResult(IRfDefElement def) {
        return EOutlineUtil.INSTANCE.getFilterResult(def, this.pluginConfig);
    }

    public boolean isUnnamedBlock(IRfDefElement def) {
        return false;
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        return EOutlineUtil.INSTANCE.isPossibleOutlineParent(def);
    }

    public int getCategory(IRfDefElement def) {
        IRfNamedElement namedElem = def.getNamedElement();
        RfKind kind = RfKind.of(namedElem);
        return kind.ordinal();
    }

    public boolean isLexicallySorted() {
        return this.pluginConfig.getPlugin().getPreferenceStore().getBoolean("outline.lexical_sort");
    }

    public boolean isCategoricallySorted() {
        return this.pluginConfig.getPlugin().getPreferenceStore().getBoolean("outline.category_sort");
    }

    public AST getRootAST() {
        RfProject rfProject = this.pluginConfig.getRfManager().getRfProject(this.editor.getProject());
        if (rfProject == null) {
            return null;
        }
        IFile iFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (iFile == null) {
            return null;
        }
        RfModule module = rfProject.getModule((IResource)iFile);
        if (module == null) {
            return null;
        }
        EModuleInfo moduleInfo = rfProject.getModuleInfo(module.getModuleReference());
        if (moduleInfo == null) {
            return null;
        }
        return moduleInfo.getModuleAST();
    }

    public IDVTElementWrapper createElementTreeWrapper(Object rfElement) {
        return this.pluginConfig.createElementTreeWrapper(rfElement);
    }

    public void setPluginConfig(IEPluginConfig config) {
        this.pluginConfig = config;
    }
}

