/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.lazy.outline;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.OutlineTreeViewProvider;

public enum EOutlineUtil {
    INSTANCE;

    private static final ElementType[] skippedElements;
    private static final Set<ElementType> SKIPPED_ELEMENTS_SET;

    static {
        skippedElements = new ElementType[]{new ElementType(ElementType.ElementTypeName.ASSERT, ElementType.ElementTypeLanguage.E), new ElementType(ElementType.ElementTypeName.CHECK, ElementType.ElementTypeLanguage.E), new ElementType(ElementType.ElementTypeName.COVER_POINT, ElementType.ElementTypeLanguage.E), new ElementType(ElementType.ElementTypeName.COVER_CROSS, ElementType.ElementTypeLanguage.E), new ElementType(ElementType.ElementTypeName.COVER_TRANSITION, ElementType.ElementTypeLanguage.E), new ElementType(ElementType.ElementTypeName.ASSERT, ElementType.ElementTypeLanguage.SLN), new ElementType(ElementType.ElementTypeName.CHECK, ElementType.ElementTypeLanguage.SLN), new ElementType(ElementType.ElementTypeName.COVER_POINT, ElementType.ElementTypeLanguage.SLN), new ElementType(ElementType.ElementTypeName.COVER_CROSS, ElementType.ElementTypeLanguage.SLN), new ElementType(ElementType.ElementTypeName.COVER_TRANSITION, ElementType.ElementTypeLanguage.SLN)};
        SKIPPED_ELEMENTS_SET = new HashSet<ElementType>(Arrays.asList(skippedElements));
    }

    public boolean isOutlineElement(IRfDefElement def) {
        if (!(def instanceof RfDefElement)) {
            return false;
        }
        RfDefElement element = (RfDefElement)def;
        if (element.isImplicit()) {
            return false;
        }
        RfProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(element, null, null);
        return elementType != null && !SKIPPED_ELEMENTS_SET.contains(elementType);
    }

    public DVTGUIFilterMatcher.GUIFilterResult getFilterResult(IRfDefElement def, IEPluginConfig pluginConfig) {
        if (!(def instanceof RfDefElement)) {
            return null;
        }
        RfDefElement element = (RfDefElement)def;
        if (element.isImplicit()) {
            return null;
        }
        RfProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ElementType elementType = rfProject.computeElementType(element, null, null);
        RfDefElement defElement = elementType.equals((Object)new ElementType(ElementType.ElementTypeName.MACRO, ElementType.ElementTypeLanguage.E)) ? element.getNamedElement().getDeclaration() : element;
        if (defElement.getNamedElement() == null) {
            return null;
        }
        AbstractRfTreeElementWrapper wrapper = pluginConfig.createElementTreeWrapper(element, true);
        OutlineTreeViewProvider labelProvider = new OutlineTreeViewProvider(pluginConfig);
        DVTGUIFilterMatcher.GUIFilterResult result = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.OUTLINE, (IRfDefElement)defElement, () -> labelProvider.getText((Object)wrapper));
        return result;
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        if (!(def instanceof RfDefElement)) {
            return false;
        }
        RfDefElement element = (RfDefElement)def;
        if (element.isImplicit()) {
            return false;
        }
        RfProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(element, null, null);
        if (elementType == null || SKIPPED_ELEMENTS_SET.contains(elementType)) {
            return false;
        }
        return elementType.equals((Object)new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.E)) || elementType.equals((Object)new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.SLN));
    }
}

