/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.outline;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfMethodTypeLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;

public abstract class AbstractAccessLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof AbstractRfTreeElementWrapper || element instanceof TreePath) {
            this.decorateRfDefElement(element, decoration);
        }
    }

    private void decorateRfDefElement(Object element, IDecoration decoration) {
        if (element instanceof AbstractRfTreeElementWrapper && !((AbstractRfTreeElementWrapper)((Object)element)).getAccessDecoratorEnable()) {
            return;
        }
        Object rfElement = null;
        if (element instanceof AbstractRfTreeElementWrapper) {
            rfElement = ((AbstractRfTreeElementWrapper)((Object)element)).getRfElement();
        } else if (element instanceof TreePath) {
            rfElement = ((TreePath)element).getElement();
        }
        if (rfElement == null) {
            return;
        }
        if (rfElement instanceof RfCoverLayer || rfElement instanceof RfOnEventLayer) {
            return;
        }
        RfNamedElement namedElement = null;
        if (rfElement instanceof RfStructLayer || rfElement instanceof RfMethodLayer || rfElement instanceof RfFieldLayer || rfElement instanceof RfEventLayer || rfElement instanceof RfScalarTypeLayer || rfElement instanceof RfMethodTypeLayer) {
            namedElement = ((RfDefElement)rfElement).getNamedElement();
        } else if (rfElement instanceof RfStruct || rfElement instanceof RfMethod || rfElement instanceof RfField || rfElement instanceof RfEvent || rfElement instanceof RfScalarType || rfElement instanceof RfMethodType) {
            namedElement = (RfNamedElement)rfElement;
        } else {
            return;
        }
        if (namedElement.isPrivate()) {
            decoration.addOverlay(DVTImages.OVR_PRIVATE, 0);
        } else if (namedElement.isProtected()) {
            decoration.addOverlay(DVTImages.OVR_PROTECTED, 0);
        } else if (namedElement.isPackage()) {
            decoration.addOverlay(DVTImages.OVR_PACKAGE, 0);
        } else {
            decoration.addOverlay(DVTImages.OVR_PUBLIC, 0);
        }
    }
}

