/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.outline;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyWalkerNode;

public abstract class AbstractOverlayLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object wrapper, IDecoration decoration) {
        Object element = null;
        if (wrapper instanceof AbstractRfTreeElementWrapper) {
            element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
        } else if (wrapper instanceof TreePath) {
            element = ((TreePath)wrapper).getElement();
        }
        if (element instanceof ECallHierarchyWalkerNode) {
            element = ((ECallHierarchyWalkerNode)element).getElement();
        }
        if (wrapper instanceof AbstractRfTreeElementWrapper && !((AbstractRfTreeElementWrapper)((Object)wrapper)).getAccessDecoratorEnable()) {
            return;
        }
        if (element instanceof RfDefElement) {
            this.decorateRfDefElement((RfDefElement)element, decoration);
            return;
        }
        if (element instanceof RfNamedElement) {
            this.decorateRfNamedElement((RfNamedElement)element, decoration);
            return;
        }
    }

    private void decorateRfDefElement(RfDefElement def, IDecoration decoration) {
        if (def instanceof RfMethodLayer) {
            RfMethodLayer mDef = (RfMethodLayer)def;
            switch (mDef.getLayerKind()) {
                case 371: {
                    decoration.addOverlay(DVTImages.OVR_EMPTY, 1);
                    break;
                }
                case 372: {
                    decoration.addOverlay(DVTImages.OVR_UNDEFINED, 1);
                    break;
                }
                case 373: {
                    decoration.addOverlay(DVTImages.OVR_INLINE, 1);
                    break;
                }
                case 374: {
                    decoration.addOverlay(DVTImages.OVR_INLINE_ONLY, 1);
                    break;
                }
                case 375: {
                    decoration.addOverlay(DVTImages.OVR_FIRST, 1);
                    break;
                }
                case 376: {
                    decoration.addOverlay(DVTImages.OVR_ALSO, 1);
                    break;
                }
                case 377: {
                    decoration.addOverlay(DVTImages.OVR_ONLY, 1);
                }
            }
            if (mDef.getMethod().isTCM()) {
                decoration.addOverlay(DVTImages.OVR_EVENT, 3);
            }
        } else {
            if (def instanceof RfOnEventLayer) {
                return;
            }
            if (def instanceof RfEventLayer) {
                RfEventLayer eDef = (RfEventLayer)def;
                switch (eDef.getLayerKind()) {
                    case 371: {
                        decoration.addOverlay(DVTImages.OVR_EMPTY, 1);
                        break;
                    }
                    case 377: {
                        decoration.addOverlay(DVTImages.OVR_ONLY, 1);
                        break;
                    }
                    case 376: {
                        decoration.addOverlay(DVTImages.OVR_ALSO, 1);
                    }
                }
            } else if (def instanceof RfExpectLayer) {
                RfExpectLayer eDef = (RfExpectLayer)def;
                switch (eDef.getLayerKind()) {
                    case 377: {
                        decoration.addOverlay(DVTImages.OVR_ONLY, 1);
                    }
                }
            }
        }
    }

    private void decorateRfNamedElement(RfNamedElement def, IDecoration decoration) {
        RfMethod method;
        if (def instanceof RfMethod && (method = (RfMethod)def).isTCM()) {
            decoration.addOverlay(DVTImages.OVR_EVENT, 3);
        }
    }
}

