/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.override.ESignatureProviderConfigurator;

public class EMethodSignatureProvider {
    public static final String NEW_LINE = System.lineSeparator();
    private static final Object TO_DO_COMMENT = "// TODO Auto-generated method stub";

    public static String createMethodSignature(IEPluginConfig pluginConfig, ESignatureProviderConfigurator sigConfig) {
        boolean useSpacesNotTabs;
        String tabOrSpace;
        IEditorPart editor = sigConfig.getEditor();
        boolean insertAtStructEnd = sigConfig.isInsertAtStructEnd();
        String indent = sigConfig.getIndent();
        String methodType = sigConfig.getMethodReturnType();
        String methodName = sigConfig.getMethodName();
        boolean hasEvent = sigConfig.hasEvent();
        String eventName = sigConfig.getEventName();
        boolean hasExtendType = sigConfig.hasExtendType();
        String extendType = sigConfig.getExtendType();
        String args = sigConfig.getMethodArgs();
        String aditionalKeywords = "";
        String accessIdentifier = sigConfig.getAccessIdentifier();
        if (accessIdentifier != null) {
            aditionalKeywords = String.valueOf(aditionalKeywords) + (!accessIdentifier.isEmpty() ? String.valueOf(accessIdentifier) + " " : "");
        }
        aditionalKeywords = String.valueOf(aditionalKeywords) + (sigConfig.hasStaticMethodQualifier() ? "static " : "");
        aditionalKeywords = String.valueOf(aditionalKeywords) + (sigConfig.hasFinalQualifier() ? "final " : "");
        StringBuilder sb = new StringBuilder();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        IDocument document = ((DVTEditor)editor).getDocument();
        if (document == null) {
            return "";
        }
        int tabWidth = 4;
        if (editor instanceof DVTEditor) {
            tabWidth = ((DVTEditor)editor).getTabWidth();
        }
        if ((tabOrSpace = TextUtils.getIndentTab((boolean)(useSpacesNotTabs = TextUtils.getEditorSpacesForTabs((IPreferenceStore)pluginConfig.getCombinedPreferenceStore())), (int)tabWidth)) == null) {
            tabOrSpace = "    ";
        }
        StringBuilder firstLine = new StringBuilder();
        if (insertAtStructEnd) {
            firstLine.append(lineDelimiter);
        }
        boolean hasReturnType = methodType != null && (!methodType.isEmpty() || "void".equals(methodType));
        firstLine.append(insertAtStructEnd ? tabOrSpace : "").append(aditionalKeywords.isEmpty() ? "" : aditionalKeywords).append(methodName).append("(").append(args).append(")").append(hasReturnType ? " : " + methodType : "").append(hasReturnType && hasEvent ? " " : "").append(hasEvent ? "@" + eventName : "").append(" " + (hasExtendType ? extendType : "is") + " ").append("{");
        firstLine.append(lineDelimiter);
        sb.append(firstLine.toString());
        sb.append(insertAtStructEnd ? tabOrSpace : "").append(tabOrSpace).append(TO_DO_COMMENT).append(lineDelimiter);
        sb.append(insertAtStructEnd ? tabOrSpace : "").append("};");
        sb.append(lineDelimiter);
        if (insertAtStructEnd) {
            sb.append(indent);
        }
        return sb.toString();
    }
}

