/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.ui.editor.override.ESignaturesInsertConfigurationProvider;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;

public class EOverriddenElementInserter {
    public static Change getInsertSignaturesChange(ESignaturesInsertConfigurationProvider configurator) {
        DVTEditor textEditor = configurator.getTextEditor();
        IDocument document = configurator.getDocument();
        List<String> signatures = configurator.getSignatures();
        if (textEditor == null || document == null || signatures == null || signatures.isEmpty()) {
            return null;
        }
        int insertOffset = configurator.getInsertionOffset();
        String indent = configurator.getIndent();
        String lineDelimiter = configurator.getLineDelimiter();
        int prefixLength = configurator.getPrefixLength();
        boolean addLineDelimitatorOnFirstLine = configurator.isAddLineDelimOnFirstLine();
        boolean indentFirstLine = configurator.isIndentFirstLine();
        boolean prependExtraNewLine = false;
        if (insertOffset < 0) {
            return null;
        }
        String implementationSignatureString = "";
        if (!addLineDelimitatorOnFirstLine) {
            implementationSignatureString = DVTFileUtils.getInstance().computeFirstLineIndent(document, indent, insertOffset);
        }
        implementationSignatureString = String.valueOf(implementationSignatureString) + DVTStringUtil.concatMethodsSignatures(signatures, (String)"", (String)indent, (String)lineDelimiter, (boolean)addLineDelimitatorOnFirstLine, (boolean)indentFirstLine);
        if (prependExtraNewLine) {
            implementationSignatureString = String.valueOf(System.lineSeparator()) + implementationSignatureString;
        }
        ETextFileChange textFileChange = new ETextFileChange("_insert_signature", (IFile)textEditor.getAdapter(IResource.class));
        textFileChange.setEdit((TextEdit)new ReplaceEdit(insertOffset - prefixLength, prefixLength, implementationSignatureString));
        return textFileChange;
    }
}

