/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.ui.editor.override.OverrideMethodsUtils;
import ro.amiq.edt.base.ui.preferences.PrefConst;

public class EOverrideMethodsDialog {
    private static final String[] EXTEND_TYPE = new String[]{"is also", "is first", "is only", "is"};
    private static final String[] EXTEND_TYPE_TOOLTIPS = new String[]{"Extend using 'is also'", "Extend using 'is first'", "Extend using 'is only'", "Extend using 'is'"};
    private static final String OVERRIDE_METHODS_TITLE = "Override Methods";
    private static final String EMPTY_LIST_MESSAGE = "No methods to override.";
    private static final int DESCRIPTION_LINE_LENGTH = 80;
    private Map<IRfScope, List<RfMethod>> model;
    private String fReplacementPrefix;
    private IEPluginConfig fPluginConfig;

    public EOverrideMethodsDialog(IEPluginConfig pluginConfig, String replacementPrefix) {
        this.fReplacementPrefix = replacementPrefix;
        this.fPluginConfig = pluginConfig;
    }

    protected boolean isChildMethod(Object obj) {
        return obj instanceof RfMethod;
    }

    protected boolean isParent(Object obj) {
        return !this.isChildMethod(obj);
    }

    protected void setHelp(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.edt.base.help.OverrideMethodsDialog");
    }

    protected IDVTElementWrapper getWrapperElement(Object element) {
        return this.fPluginConfig.createElementTreeWrapper(element);
    }

    public Map<RfMethod, String> getSelectedFunctions(Map<IRfScope, List<RfMethod>> model) {
        int status;
        this.model = model;
        SelectDialog selectDialog = new SelectDialog(Utils.getActiveShell(), (ILabelProvider)new OverrideMethodsLabelProvider(), new OverrideContentProvider());
        selectDialog.setBlockOnOpen(true);
        selectDialog.setTitle(OVERRIDE_METHODS_TITLE);
        selectDialog.setInput(model);
        if (this.fReplacementPrefix != null && !this.fReplacementPrefix.isEmpty()) {
            selectDialog.setSearchTextString(this.fReplacementPrefix);
        }
        if ((status = selectDialog.open()) == 0) {
            return selectDialog.getResultMap();
        }
        return new HashMap<RfMethod, String>();
    }

    private class OverrideContentProvider
    implements ITreeContentProvider {
        HashMap<Object, ArrayList<IRfNamedElement>> params = new HashMap();

        private OverrideContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashMap params;
            if (!(inputElement instanceof HashMap)) {
                return null;
            }
            this.params = params = (HashMap)inputElement;
            return params.keySet().toArray(new Object[params.size()]);
        }

        public Object[] getChildren(Object parentElement) {
            if (!EOverrideMethodsDialog.this.isParent(parentElement)) {
                return new Object[0];
            }
            if (!this.params.containsKey(parentElement)) {
                return new Object[0];
            }
            ArrayList<IRfNamedElement> methods = this.params.get(parentElement);
            if (methods == null) {
                return new Object[0];
            }
            return methods.toArray();
        }

        public Object getParent(Object element) {
            if (!EOverrideMethodsDialog.this.isChildMethod(element)) {
                return null;
            }
            for (Map.Entry<Object, ArrayList<IRfNamedElement>> entry : this.params.entrySet()) {
                if (!entry.getValue().contains(element)) continue;
                return entry.getKey();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.params.containsKey(element) && !this.params.get(element).isEmpty();
        }
    }

    private static class OverrideMethodsExtendColumnLabelProvider
    extends ColumnLabelProvider {
        private Map<RfMethod, String> fResultMap;
        private Set<Object> fCheckedElements;

        public OverrideMethodsExtendColumnLabelProvider(Map<RfMethod, String> resultMap, Set<Object> checkedElements) {
            this.fResultMap = resultMap;
            this.fCheckedElements = checkedElements;
        }

        public String getText(Object element) {
            if (this.fResultMap == null) {
                return null;
            }
            if (this.fCheckedElements == null || !this.fCheckedElements.contains(element)) {
                return null;
            }
            return this.fResultMap.get(element);
        }
    }

    private class OverrideMethodsLabelProvider
    extends ColumnLabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element instanceof RfStructLayer) {
                RfStructLayer layer = (RfStructLayer)element;
                result = layer.getStruct() != null && layer.getStruct().isLike("any_sequence") ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE) : (layer.isIs() ? (layer.isUnit() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT)) : (layer.isWhen() ? (layer.isUnit() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_WHEN) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_WHEN)) : (layer.isUnit() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_EXTEND) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND))));
            } else if (element instanceof RfStruct) {
                result = ((RfStruct)element).isUnit() ? (((RfStruct)element).isPredefined() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_GRAY) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT)) : (((RfStruct)element).isPredefined() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_GRAY) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT));
            } else if (element instanceof RfPredefinedMethod) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_PMETHOD);
            } else if (element instanceof RfMethod) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
            }
            return result;
        }

        public String getText(Object element) {
            if (EOverrideMethodsDialog.this.isParent(element)) {
                return ((IRfScope)element).getDeterminant().toString();
            }
            if (EOverrideMethodsDialog.this.isChildMethod(element)) {
                return ((RfMethod)element).getName();
            }
            return (String)element;
        }

        public String getToolTipText(Object element) {
            if (element instanceof IRfDefElement) {
                return ((IRfDefElement)element).getName();
            }
            if (element instanceof IRfNamedElement) {
                return DVTStringUtil.textWrap((int)80, (String)(String.valueOf(((IRfNamedElement)element).getSignature().trim().replace("\n", "")) + "\n\n" + ((IRfNamedElement)element).getComment())).toString();
            }
            return null;
        }
    }

    private class SelectDialog
    extends CheckedTreeSelectionDialog {
        private static final String SHOW_ONLY_EMPTY_OR_UNDEFINED_MESSAGE = "Show only empty or undefined methods";
        private static final String EXTEND_TYPE_TITLE = "Extend type";
        private Button[] extendTypeButtons;
        private Button showOnlyEmptyOrUndefined;
        private Group extendTypeGroup;
        private Map<RfMethod, String> result;
        private Text searchText;
        private String searchTextString;
        private FilterTriggerJob filterTriggerJob;
        private Set<Object> checkedElements;

        public SelectDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, (ILabelProvider)new LabelProvider(), contentProvider);
            this.result = new LinkedHashMap<RfMethod, String>();
            this.filterTriggerJob = new FilterTriggerJob();
            this.checkedElements = new LinkedHashSet<Object>();
            this.setEmptyListMessage(EOverrideMethodsDialog.EMPTY_LIST_MESSAGE);
            this.setContainerMode(true);
        }

        protected CheckboxTreeViewer createTreeViewer(Composite parent) {
            final CheckboxTreeViewer checkboxTreeViewer = super.createTreeViewer(parent);
            checkboxTreeViewer.getTree().setHeaderVisible(true);
            checkboxTreeViewer.getTree().setLinesVisible(true);
            TreeViewerColumn methodColumn = new TreeViewerColumn((TreeViewer)checkboxTreeViewer, 0);
            methodColumn.getColumn().setWidth(300);
            methodColumn.getColumn().setText("Method");
            methodColumn.setLabelProvider((CellLabelProvider)new OverrideMethodsLabelProvider());
            TreeViewerColumn extendTypeColumn = new TreeViewerColumn((TreeViewer)checkboxTreeViewer, 0);
            extendTypeColumn.getColumn().setWidth(100);
            extendTypeColumn.getColumn().setText(EXTEND_TYPE_TITLE);
            extendTypeColumn.setLabelProvider((CellLabelProvider)new OverrideMethodsExtendColumnLabelProvider(this.result, this.checkedElements));
            checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean checkedState = event.getChecked();
                    Object rfElement = event.getElement();
                    SelectDialog.this.setChecked(rfElement, checkedState, checkboxTreeViewer);
                    SelectDialog.this.getTreeViewer().getTree().update();
                    SelectDialog.this.getTreeViewer().refresh();
                    checkboxTreeViewer.refresh(true);
                }
            });
            checkboxTreeViewer.setSorter((ViewerSorter)new OverrideMethodsSorter());
            checkboxTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object element = ((TreeSelection)event.getSelection()).getFirstElement();
                    boolean isEnabled = SelectDialog.this.result.containsKey(element);
                    int i = 0;
                    while (i < SelectDialog.this.extendTypeButtons.length) {
                        boolean isSelected = SelectDialog.this.extendTypeButtons[i].getText().equals(SelectDialog.this.result.get(element));
                        SelectDialog.this.extendTypeButtons[i].setSelection(isSelected);
                        SelectDialog.this.extendTypeButtons[i].setEnabled(isEnabled);
                        ++i;
                    }
                    SelectDialog.this.extendTypeGroup.setEnabled(isEnabled);
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer(), (int)2);
            EOverrideMethodsDialog.this.setHelp(parent);
            return checkboxTreeViewer;
        }

        private void setChecked(Object rfElement, boolean isChecked, CheckboxTreeViewer checkboxTreeViewer) {
            if (EOverrideMethodsDialog.this.isParent(rfElement)) {
                this.setCheckedParent(rfElement, isChecked, checkboxTreeViewer);
                return;
            }
            this.setCheckedChild(rfElement, isChecked, checkboxTreeViewer);
        }

        private void setCheckedChild(Object rfElement, boolean isChecked, CheckboxTreeViewer checkboxTreeViewer) {
            checkboxTreeViewer.setChecked(rfElement, isChecked);
            if (isChecked) {
                this.checkedElements.add(rfElement);
                this.result.put((RfMethod)rfElement, this.extendTypeButtons[0].getText());
            } else {
                this.checkedElements.remove(rfElement);
                this.result.remove(rfElement);
                this.extendTypeGroup.setEnabled(false);
            }
        }

        private void setCheckedParent(Object rfElement, boolean isChecked, CheckboxTreeViewer checkboxTreeViewer) {
            Object[] structChildren;
            ITreeContentProvider contentProvider = (ITreeContentProvider)checkboxTreeViewer.getContentProvider();
            Object[] objectArray = structChildren = contentProvider.getChildren(rfElement);
            int n = structChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (contentProvider.getParent(child) == rfElement) {
                    this.setCheckedChild(child, isChecked, checkboxTreeViewer);
                }
                ++n2;
            }
        }

        public void setSearchTextString(String text) {
            this.searchTextString = text;
        }

        private void update() {
            CheckboxTreeViewer checkboxTreeViewer = this.getTreeViewer();
            TreePath[] expandedTreePath = checkboxTreeViewer.getExpandedTreePaths();
            LinkedHashMap newModel = new LinkedHashMap();
            LinkedHashMap<RfMethod, String> newResultMap = new LinkedHashMap<RfMethod, String>();
            LinkedHashSet<RfMethod> visibleCheckedElements = new LinkedHashSet<RfMethod>();
            String matchText = this.searchText.getText().trim();
            boolean showOnlyEmptyUndefined = this.showOnlyEmptyOrUndefined == null ? false : this.showOnlyEmptyOrUndefined.getSelection();
            for (Map.Entry<IRfScope, List<RfMethod>> modelEntry : EOverrideMethodsDialog.this.model.entrySet()) {
                ArrayList<RfMethod> newMethodsForStruct = new ArrayList<RfMethod>();
                IRfScope struct = modelEntry.getKey();
                if (this.shouldFilterStruct(struct, matchText)) {
                    for (RfMethod method : modelEntry.getValue()) {
                        isChecked = this.checkedElements.contains(method);
                        if (isChecked) {
                            newResultMap.put(method, this.result.containsKey(method) ? this.result.get(method) : EXTEND_TYPE[0]);
                        }
                        if (this.shoudlFilterMethod(method, matchText, showOnlyEmptyUndefined)) continue;
                        newMethodsForStruct.add(method);
                        if (!isChecked) continue;
                        visibleCheckedElements.add(method);
                    }
                } else {
                    for (RfMethod method : modelEntry.getValue()) {
                        isChecked = this.checkedElements.contains(method);
                        if (isChecked) {
                            newResultMap.put(method, this.result.containsKey(method) ? this.result.get(method) : EXTEND_TYPE[0]);
                        }
                        if (this.shoudlFilterMethod(method, "", showOnlyEmptyUndefined)) continue;
                        newMethodsForStruct.add(method);
                        if (!isChecked) continue;
                        visibleCheckedElements.add(method);
                    }
                }
                if (newMethodsForStruct.isEmpty()) continue;
                newModel.put(struct, newMethodsForStruct);
            }
            this.result.clear();
            this.result.putAll(newResultMap);
            checkboxTreeViewer.setInput(newModel);
            checkboxTreeViewer.setCheckedElements(visibleCheckedElements.toArray());
            checkboxTreeViewer.getTree().update();
            if (matchText.isEmpty()) {
                checkboxTreeViewer.setExpandedTreePaths(expandedTreePath);
            } else {
                checkboxTreeViewer.expandAll();
            }
            checkboxTreeViewer.refresh();
        }

        private boolean shoudlFilterMethod(RfMethod method, String matchText, boolean showOnlyEmptyUndefined) {
            if (showOnlyEmptyUndefined && !OverrideMethodsUtils.INSTANCE.isEmptyOrUndefined(method, EOverrideMethodsDialog.this.model)) {
                return true;
            }
            if (matchText.isEmpty()) {
                return false;
            }
            return !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)ViewsUtils.createCamelCaseOrRegexMatcher((String)matchText, (boolean)true, (boolean)false), (String)method.getName());
        }

        private boolean shouldFilterStruct(IRfScope scope, String matchText) {
            if (matchText.isEmpty()) {
                return false;
            }
            return !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)ViewsUtils.createCamelCaseOrRegexMatcher((String)matchText, (boolean)true, (boolean)false), (String)scope.getName());
        }

        protected Control createDialogArea(Composite parent) {
            boolean showOnlyEmptyUndefined;
            Composite topComposite = new Composite(parent, 0);
            topComposite.setLayout((Layout)new GridLayout(2, false));
            topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            this.searchText = new Text(topComposite, 2048);
            this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.searchText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectDialog.this.filterTriggerJob.cancel();
                    SelectDialog.this.filterTriggerJob.schedule(500L);
                }
            });
            this.searchText.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                        SelectDialog.this.getTreeViewer().getTree().setFocus();
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            if (this.searchTextString != null && !this.searchTextString.isEmpty()) {
                this.searchText.setText(this.searchTextString);
                this.searchText.setSelection(this.searchTextString.length());
                this.filterTriggerJob.run((IProgressMonitor)new NullProgressMonitor());
            }
            this.searchText.setFocus();
            ToolBar toolbar = new ToolBar(topComposite, 0x800100);
            ToolItem expand = new ToolItem(toolbar, 0);
            expand.setImage(DVTImages.imageCache.getImage(DVTImages.EXPAND_TREE));
            expand.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SelectDialog.this.setExpandedState(true);
                }
            });
            ToolItem collapse = new ToolItem(toolbar, 0);
            collapse.setImage(DVTImages.imageCache.getImage(DVTImages.COLLAPSE_TREE));
            collapse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SelectDialog.this.setExpandedState(false);
                }
            });
            Composite treeComposite = new Composite(parent, 0);
            treeComposite.setLayout((Layout)new GridLayout(2, false));
            treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            CheckboxTreeViewer treeViewer = this.createTreeViewer(treeComposite);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 400;
            data.widthHint = 600;
            Tree treeWidget = treeViewer.getTree();
            treeWidget.setLayoutData((Object)data);
            treeWidget.setFont(parent.getFont());
            treeWidget.setEnabled(true);
            if (!EOverrideMethodsDialog.this.model.keySet().isEmpty()) {
                treeViewer.expandToLevel((Object)EOverrideMethodsDialog.this.model.keySet().iterator().next(), 1);
            }
            ArrayList<RfMethod> selectedElements = new ArrayList<RfMethod>();
            boolean bl = showOnlyEmptyUndefined = this.showOnlyEmptyOrUndefined == null ? false : this.showOnlyEmptyOrUndefined.getSelection();
            if (this.searchTextString != null && !this.searchTextString.isEmpty()) {
                for (List<RfMethod> methods : EOverrideMethodsDialog.this.model.values()) {
                    for (RfMethod method : methods) {
                        if (this.shoudlFilterMethod(method, this.searchTextString, showOnlyEmptyUndefined)) continue;
                        selectedElements.add(method);
                        this.result.put(method, EXTEND_TYPE[0]);
                    }
                }
            }
            this.setInitialSelections(selectedElements.toArray());
            this.checkedElements.clear();
            this.checkedElements.addAll(selectedElements);
            this.createSelectionButtons(treeComposite);
            Composite bottomComposite = new Composite(parent, 0);
            bottomComposite.setLayout((Layout)new GridLayout(1, false));
            bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addShowOnlyAbstratCheckbox(bottomComposite);
            this.createExtendTypeGroup(bottomComposite);
            this.update();
            return treeComposite;
        }

        private void setExpandedState(boolean expanded) {
            CheckboxTreeViewer checkboxTreeViewer = this.getTreeViewer();
            Object input = checkboxTreeViewer.getInput();
            if (!(input instanceof Map)) {
                return;
            }
            Map model = (Map)input;
            for (Object struct : model.keySet()) {
                checkboxTreeViewer.setExpandedState(struct, expanded);
            }
        }

        private void addShowOnlyAbstratCheckbox(Composite parent) {
            this.showOnlyEmptyOrUndefined = new Button(parent, 32);
            this.showOnlyEmptyOrUndefined.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.showOnlyEmptyOrUndefined.setText(SHOW_ONLY_EMPTY_OR_UNDEFINED_MESSAGE);
            this.showOnlyEmptyOrUndefined.setToolTipText(SHOW_ONLY_EMPTY_OR_UNDEFINED_MESSAGE);
            this.showOnlyEmptyOrUndefined.setSelection(PrefConst.getOverrideOnlyEmptyOrUndefined(EOverrideMethodsDialog.this.fPluginConfig.getPlugin()));
            this.showOnlyEmptyOrUndefined.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PrefConst.setOverrideOnlyEmptyOrUndefined(((SelectDialog)SelectDialog.this).EOverrideMethodsDialog.this.fPluginConfig.getPlugin(), SelectDialog.this.showOnlyEmptyOrUndefined.getSelection());
                    SelectDialog.this.update();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }

        private void createExtendTypeGroup(Composite composite) {
            this.extendTypeGroup = new Group(composite, 0);
            this.extendTypeGroup.setText(EXTEND_TYPE_TITLE);
            this.extendTypeGroup.setLayoutData((Object)new GridData(4, 1024, true, false));
            this.extendTypeGroup.setLayout((Layout)new GridLayout(4, false));
            this.extendTypeGroup.setEnabled(false);
            this.extendTypeButtons = new Button[EXTEND_TYPE.length];
            int i = 0;
            while (i < EXTEND_TYPE.length) {
                this.extendTypeButtons[i] = new Button((Composite)this.extendTypeGroup, 16);
                this.extendTypeButtons[i].setLayoutData((Object)new GridData(1, 128, false, false));
                this.extendTypeButtons[i].setText(EXTEND_TYPE[i]);
                this.extendTypeButtons[i].setToolTipText(EXTEND_TYPE_TOOLTIPS[i]);
                this.extendTypeButtons[i].setEnabled(false);
                this.extendTypeButtons[i].addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        SelectDialog.this.updateExtendType();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                ++i;
            }
        }

        private void updateExtendType() {
            int i = 0;
            while (i < this.extendTypeButtons.length) {
                if (this.extendTypeButtons[i].getSelection()) {
                    TreeSelection selection = (TreeSelection)this.getTreeViewer().getSelection();
                    RfMethod selectedElement = (RfMethod)selection.getFirstElement();
                    if (selectedElement == null) break;
                    this.result.put(selectedElement, this.extendTypeButtons[i].getText());
                    break;
                }
                ++i;
            }
            this.getTreeViewer().refresh();
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            CheckboxTreeViewer checkboxTreeViewer = this.getTreeViewer();
            Object input = checkboxTreeViewer.getInput();
            if (!(input instanceof Map)) {
                return;
            }
            Map model = (Map)input;
            if (buttonId == 19) {
                for (Object struct : model.keySet()) {
                    this.setCheckedParent(struct, false, checkboxTreeViewer);
                }
                checkboxTreeViewer.refresh();
            } else if (buttonId == 18) {
                for (Object struct : model.keySet()) {
                    this.setCheckedParent(struct, true, checkboxTreeViewer);
                }
                checkboxTreeViewer.refresh();
            }
        }

        public Map<RfMethod, String> getResultMap() {
            return this.result;
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite result = super.createSelectionButtons(composite);
            Object dataObject = result.getLayoutData();
            if (dataObject instanceof GridData) {
                GridData data = (GridData)dataObject;
                data.verticalAlignment = 128;
            }
            return result;
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            if (id != 0 && id != 1) {
                ((GridLayout)parent.getLayout()).numColumns = 0;
            }
            return super.createButton(parent, id, label, defaultButton);
        }

        class FilterTriggerJob
        extends UIJob {
            public FilterTriggerJob() {
                super("FilterTriggerJob");
                this.setPriority(50);
                this.setSystem(true);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SelectDialog.this.update();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }

        private class OverrideMethodsSorter
        extends ViewerSorter {
            private OverrideMethodsSorter() {
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (!(e1 instanceof IRfNamedElement && e2 instanceof IRfNamedElement && EOverrideMethodsDialog.this.isChildMethod(e1) && EOverrideMethodsDialog.this.isChildMethod(e2))) {
                    return 0;
                }
                String name1 = ((IRfNamedElement)e1).getName();
                String name2 = ((IRfNamedElement)e2).getName();
                if (name1 == null || name2 == null) {
                    return 0;
                }
                return name1.compareTo(name2);
            }
        }
    }
}

