/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfStructLayer;

public class ESignatureProviderConfigurator {
    private RfMethod method;
    private RfStructLayer enclosingStructLayer;
    private IEditorPart editor;
    private String indent;
    private int indentRelativeOffset;
    private String methodName;
    private String returnType;
    private String methodArgs;
    private boolean insertAtStructEnd;
    private boolean hasAccessIdentifiers;
    private String accessIdentifier;
    private boolean hasStaticQualifier;
    private boolean hasFinalQualifier;
    private String argumentNamesString;
    private boolean hasExtendType;
    private String extendType;
    private boolean hasEvent;
    private String eventName;
    private boolean isUndefined;
    private boolean isEmpty;

    public ESignatureProviderConfigurator(RfMethod method, String extendType, RfStructLayer enclosingStructLayer, IEditorPart editor, String indent, boolean insertAtStructEnd, boolean addTab) {
        this.method = method;
        this.methodName = method.getName();
        this.methodArgs = method.getArgs();
        this.returnType = method.getAssociatedFullTypeName();
        if ("void".equals(this.returnType)) {
            this.returnType = "";
        } else {
            int i = 0;
            while (i < method.getAssociatedTypeList()) {
                this.returnType = DVTStringUtil.appendString((Object[])new Object[]{"list of ", this.returnType});
                ++i;
            }
        }
        this.hasStaticQualifier = method.isStatic();
        if (method.isTCM()) {
            this.hasEvent = true;
            this.eventName = method.getEvent();
        }
        if (extendType != null && !extendType.isEmpty()) {
            this.hasExtendType = true;
            this.extendType = extendType;
        }
        boolean bl = this.hasAccessIdentifiers = method.getAccessModifier() != 16;
        if (this.hasAccessIdentifiers) {
            if (method.isPrivate()) {
                this.accessIdentifier = "private";
            } else if (method.isProtected()) {
                this.accessIdentifier = "protected";
            } else if (method.isPackage()) {
                this.accessIdentifier = "package";
            }
        }
        this.isEmpty = method.hasNoLayers();
        this.isUndefined = method.hasNoLayers();
        this.enclosingStructLayer = enclosingStructLayer;
        this.editor = editor;
        this.indent = indent;
        this.insertAtStructEnd = insertAtStructEnd;
    }

    public RfMethod getMethod() {
        return this.method;
    }

    public void setMethod(RfMethod method) {
        this.method = method;
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public int getIndentRelativeOffset() {
        return this.indentRelativeOffset;
    }

    public void setIndentRelativeOffset(int indentRelativeOffset) {
        this.indentRelativeOffset = indentRelativeOffset;
    }

    public void setInsertAtStructEnd(boolean insertAtStructEnd) {
        this.insertAtStructEnd = insertAtStructEnd;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodReturnType() {
        return this.returnType;
    }

    public void setMethodReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getMethodArgs() {
        return this.methodArgs;
    }

    public void setMethodArgs(String methodArgs) {
        this.methodArgs = methodArgs;
    }

    public boolean isAddAccessIdentifiers() {
        return this.hasAccessIdentifiers;
    }

    public void setAddAccessIdentifiers(boolean addAccessIdentifiers) {
        this.hasAccessIdentifiers = addAccessIdentifiers;
    }

    public boolean hasFinalQualifier() {
        return this.hasFinalQualifier;
    }

    public void setHasFinalQualifier(boolean hasFinalQualifier) {
        this.hasFinalQualifier = hasFinalQualifier;
    }

    public String getAccessIdentifier() {
        return this.accessIdentifier;
    }

    public void setAccessIdentifier(String accessIdentifier) {
        this.accessIdentifier = accessIdentifier;
    }

    public boolean hasStaticMethodQualifier() {
        return this.hasStaticQualifier;
    }

    public void setHasStaticMethodQualifier(boolean hasStaticMethodQualifier) {
        this.hasStaticQualifier = hasStaticMethodQualifier;
    }

    public String getArgumentNamesString() {
        return this.argumentNamesString;
    }

    public void setArgumentsNameString(String argumentsNameString) {
        this.argumentNamesString = argumentsNameString;
    }

    public RfStructLayer getEnclosingStructLayer() {
        return this.enclosingStructLayer;
    }

    public void setEnclosingClass(RfStructLayer enclosingLayer) {
        this.enclosingStructLayer = enclosingLayer;
    }

    public boolean isHasStaticQualifier() {
        return this.hasStaticQualifier;
    }

    public void setHasStaticQualifier(boolean hasStaticQualifier) {
        this.hasStaticQualifier = hasStaticQualifier;
    }

    public boolean hasExtendType() {
        return this.hasExtendType;
    }

    public void setHasExtendType(boolean hasExtendType) {
        this.hasExtendType = hasExtendType;
    }

    public String getExtendType() {
        return this.extendType;
    }

    public void setExtendType(String extendType) {
        this.extendType = extendType;
    }

    public boolean hasEvent() {
        return this.hasEvent;
    }

    public void setHasEvent(boolean hasEvent) {
        this.hasEvent = hasEvent;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public boolean isUndefined() {
        return this.isUndefined;
    }

    public void setUndefined(boolean isUndefined) {
        this.isUndefined = isUndefined;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public boolean isInsertAtStructEnd() {
        return this.insertAtStructEnd;
    }
}

