/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.EDTBasePlugin;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.ui.editor.override.EMethodSignatureProvider;
import ro.amiq.edt.base.ui.editor.override.ESignatureProviderConfigurator;

public class ESignaturesInsertConfigurationProvider {
    private List<String> signatures;
    private DVTEditor textEditor;
    private IDocument document;
    private int insertOffset;
    private int userInsertPoint;
    private String indent;
    private String lineDelimiter;
    private boolean addLineDelimiterOnFirstLine;
    private boolean indentFirstLine;
    private int prefixLength;
    private RfStructLayer structLayer;
    private IEPluginConfig pluginConfig;

    public static ESignaturesInsertConfigurationProvider createUserInsertionPointConfiguration(IEPluginConfig pluginConfig, RfStructLayer structLayer, Map<RfMethod, String> selectedMethods, ITextEditor textEditor, int userInsertionPoint, int prefixLength) {
        return new ESignaturesInsertConfigurationProvider(pluginConfig, structLayer, selectedMethods, textEditor, userInsertionPoint, prefixLength);
    }

    public static ESignaturesInsertConfigurationProvider createAutoInsertionPointConfiguration(RfStructLayer structLayer, Map<RfMethod, String> selectedMethods, ITextEditor textEditor) {
        return new ESignaturesInsertConfigurationProvider(structLayer, selectedMethods, (DVTEditor)textEditor);
    }

    private ESignaturesInsertConfigurationProvider(IEPluginConfig pluginConfig, RfStructLayer structLayer, Map<RfMethod, String> selectedMethods, ITextEditor textEditor, int userInsertionPoint, int prefixLength) {
        this.structLayer = structLayer;
        this.textEditor = (DVTEditor)textEditor;
        this.document = ((DVTEditor)textEditor).getDocument();
        this.insertOffset = userInsertionPoint;
        this.indent = String.valueOf(ESignaturesInsertConfigurationProvider.computeEnclosingElementIndent(structLayer, (DVTEditor)textEditor)) + DVTFileUtils.getInstance().computeOneIndent(EDTBasePlugin.getDefault().getPreferenceStore(), (DVTEditor)textEditor);
        this.lineDelimiter = System.lineSeparator();
        this.prefixLength = prefixLength;
        this.addLineDelimiterOnFirstLine = false;
        this.indentFirstLine = false;
        this.userInsertPoint = userInsertionPoint;
        this.pluginConfig = pluginConfig;
        this.signatures = this.computeFunctionSignatures(structLayer, selectedMethods, prefixLength, false);
    }

    private static String computeEnclosingElementIndent(RfStructLayer structLayer, DVTEditor textEditor) {
        if (textEditor == null) {
            return "";
        }
        IDocument document = textEditor.getDocument();
        if (document == null) {
            return "";
        }
        if (structLayer == null) {
            return "";
        }
        return DVTDocumentUtils.getIndent((int)structLayer.getStartOffset(), (IDocument)document);
    }

    private ESignaturesInsertConfigurationProvider(RfStructLayer structLayer, Map<RfMethod, String> methods, DVTEditor textEditor) {
        this.setstructLayer(structLayer);
        this.textEditor = textEditor;
        this.document = textEditor.getDocument();
        this.insertOffset = this.getStructLayer().getEndOffset();
        this.indent = this.computeToolInsertionPointIndent(this.insertOffset);
        this.lineDelimiter = System.lineSeparator();
        this.addLineDelimiterOnFirstLine = true;
        this.indentFirstLine = true;
        this.userInsertPoint = -1;
        this.signatures = this.computeFunctionSignatures(structLayer, methods, this.prefixLength, true);
    }

    private List<String> computeFunctionSignatures(RfDefElement structLayer, Map<RfMethod, String> selectedMethods, int prefixLength, boolean insertAtStructEnd) {
        ArrayList<String> signatures = new ArrayList<String>();
        Set<Map.Entry<RfMethod, String>> methodsEntrySet = selectedMethods.entrySet();
        for (Map.Entry<RfMethod, String> entry : methodsEntrySet) {
            ESignatureProviderConfigurator sigConfig = new ESignatureProviderConfigurator(entry.getKey(), entry.getValue(), (RfStructLayer)structLayer, (IEditorPart)this.textEditor, this.indent, insertAtStructEnd, false);
            signatures.add(EMethodSignatureProvider.createMethodSignature(this.pluginConfig, sigConfig));
        }
        return signatures;
    }

    private String computeToolInsertionPointIndent(int toolInsertionPoint) {
        return DVTFileUtils.computeIndent((IDocument)this.textEditor.getDocument(), (int)toolInsertionPoint);
    }

    public DVTEditor getTextEditor() {
        return this.textEditor;
    }

    public void setTextEditor(DVTEditor textEditor) {
        this.textEditor = textEditor;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<String> signatures) {
        this.signatures = signatures;
    }

    public int getInsertionOffset() {
        return this.insertOffset;
    }

    public void setInsertionOffset(int insertionOffset) {
        this.insertOffset = insertionOffset;
    }

    public boolean isUserInsertionPoint() {
        return this.userInsertPoint != -1;
    }

    public void setIsUserInsertionPoint(int isUserInsertionPoint) {
        this.userInsertPoint = isUserInsertionPoint;
    }

    public boolean isAddLineDelimOnFirstLine() {
        return this.addLineDelimiterOnFirstLine;
    }

    public void setAddLineDelimOnFirstLine(boolean addLineDelimOnFirstLine) {
        this.addLineDelimiterOnFirstLine = addLineDelimOnFirstLine;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public boolean isIndentFirstLine() {
        return this.indentFirstLine;
    }

    public void setIndentFirstLine(boolean indentFirstLine) {
        this.indentFirstLine = indentFirstLine;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public RfStructLayer getStructLayer() {
        return this.structLayer;
    }

    public void setstructLayer(RfStructLayer structLayer) {
        this.structLayer = structLayer;
    }
}

