/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfStructLayer;

public class InsertMethodLayerDialog {
    private static final String[] EXTEND_TYPE = new String[]{"is also", "is first", "is only", "is"};
    private static final String[] EXTEND_TYPE_TOOLTIPS = new String[]{"Extend using 'is also'", "Extend using 'is first'", "Extend using 'is only'", "Extend using 'is'"};
    private static final String DIALOG_TITLE = "Override";
    private RfStructLayer singleLayer = null;
    private String dialogMessage = null;
    Map<RfModule, List<RfStructLayer>> layerOverrideParams;

    public InsertMethodLayerDialog(RfStructLayer currentStructLayer, RfMethod currentMethod) {
        this.dialogMessage = "Please choose the '" + currentStructLayer.getDeterminant().toString() + "' override insertion point:";
    }

    protected boolean isChild(Object obj) {
        return obj instanceof RfStructLayer;
    }

    protected boolean isParent(Object obj) {
        return !this.isChild(obj);
    }

    public Map.Entry<RfStructLayer, String> getSelectedLayers(Map<RfModule, List<RfStructLayer>> layerOverrideParams, String methodName) {
        List<RfStructLayer> structLayersInFile;
        if (layerOverrideParams.isEmpty()) {
            return null;
        }
        SelectLayerDialog selectDialog = new SelectLayerDialog(Utils.getActiveShell(), (IBaseLabelProvider)new StructLayerLabelProvider(), new StructLayerContentProvider());
        selectDialog.setBlockOnOpen(true);
        this.layerOverrideParams = layerOverrideParams;
        Set<Map.Entry<RfModule, List<RfStructLayer>>> overrideParamsEntries = layerOverrideParams.entrySet();
        if (overrideParamsEntries == null || overrideParamsEntries.isEmpty()) {
            return null;
        }
        if (overrideParamsEntries.size() == 1 && (structLayersInFile = overrideParamsEntries.iterator().next().getValue()).size() == 1) {
            this.singleLayer = structLayersInFile.get(0);
        }
        selectDialog.setTitle("Override Method " + methodName + "()");
        selectDialog.setInput(layerOverrideParams);
        int returnValue = selectDialog.open();
        if (returnValue == 0) {
            Map.Entry<RfStructLayer, String> result = selectDialog.getSelectionResult();
            Object[] orderedResult = selectDialog.getResult();
            if (orderedResult == null) {
                return null;
            }
            return result;
        }
        return null;
    }

    private class SelectLayerDialog
    extends ElementTreeSelectionDialog {
        private Button[] extendTypeButtons;
        private Group extendTypeGroup;
        private TreeViewer treeViewer;
        private Text searchText;
        private FilterTriggerJob filterTriggerJob;
        Map<RfStructLayer, Integer> prevSelections;

        public SelectLayerDialog(Shell parent, IBaseLabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
            this.filterTriggerJob = new FilterTriggerJob();
            this.prevSelections = new HashMap<RfStructLayer, Integer>();
            this.setDoubleClickSelects(false);
        }

        public Map.Entry<RfStructLayer, String> getSelectionResult() {
            Integer extendTypeIndex;
            RfStructLayer selectedLayer = InsertMethodLayerDialog.this.singleLayer;
            if (selectedLayer == null) {
                Object[] selectionResult = this.getResult();
                if (selectionResult == null || selectionResult.length != 1 || !(selectionResult[0] instanceof RfStructLayer)) {
                    return null;
                }
                selectedLayer = (RfStructLayer)selectionResult[0];
            }
            if ((extendTypeIndex = this.prevSelections.get(selectedLayer)) == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<RfStructLayer, String>(selectedLayer, EXTEND_TYPE[extendTypeIndex]);
        }

        protected Control createDialogArea(Composite parent) {
            StructLayerContentProvider contentProvider;
            Map.Entry<RfModule, RfStructLayer> lastLayerEntry;
            super.setMessage(InsertMethodLayerDialog.this.dialogMessage);
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            if (InsertMethodLayerDialog.this.singleLayer == null) {
                this.searchText = new Text(dialogArea, 2176);
                this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.searchText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        SelectLayerDialog.this.filterTriggerJob.cancel();
                        SelectLayerDialog.this.filterTriggerJob.schedule(500L);
                    }
                });
                this.searchText.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                            SelectLayerDialog.this.getTreeViewer().getTree().setFocus();
                        }
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                Control[] children = dialogArea.getChildren();
                if (children[0] instanceof Label) {
                    this.searchText.moveBelow(children[0]);
                }
                this.searchText.setFocus();
                this.treeViewer = this.getTreeViewer();
                this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        TreeSelection selection = (TreeSelection)event.getSelection();
                        Object element = selection.getFirstElement();
                        if (!(element instanceof RfStructLayer)) {
                            SelectLayerDialog.this.setEnabledForExtendGroup(false, null);
                            return;
                        }
                        RfStructLayer selectedLayer = (RfStructLayer)element;
                        SelectLayerDialog.this.setEnabledForExtendGroup(true, selectedLayer);
                    }
                });
            } else {
                dialogArea.dispose();
            }
            Composite bottomComposite = new Composite(parent, 0);
            bottomComposite.setLayout((Layout)new GridLayout(1, false));
            GridData layoutData = new GridData(4, 4, true, false);
            layoutData.widthHint = 400;
            bottomComposite.setLayoutData((Object)layoutData);
            this.createExtendTypeGroup(bottomComposite);
            if (InsertMethodLayerDialog.this.singleLayer == null && (lastLayerEntry = (contentProvider = (StructLayerContentProvider)this.treeViewer.getContentProvider()).getElementToSelect()) != null) {
                this.treeViewer.setExpandedState((Object)lastLayerEntry.getKey(), true);
                this.setInitialSelection(lastLayerEntry.getValue());
            }
            return parent;
        }

        private void createExtendTypeGroup(Composite composite) {
            boolean enabled = InsertMethodLayerDialog.this.singleLayer != null;
            this.extendTypeGroup = new Group(composite, 0);
            this.extendTypeGroup.setText("Extend type");
            this.extendTypeGroup.setLayoutData((Object)new GridData(4, 1024, true, false));
            this.extendTypeGroup.setLayout((Layout)new GridLayout(4, false));
            this.extendTypeGroup.setEnabled(enabled);
            this.extendTypeButtons = new Button[EXTEND_TYPE.length];
            int i = 0;
            while (i < EXTEND_TYPE.length) {
                this.extendTypeButtons[i] = new Button((Composite)this.extendTypeGroup, 16);
                this.extendTypeButtons[i].setLayoutData((Object)new GridData(1, 128, false, false));
                this.extendTypeButtons[i].setText(EXTEND_TYPE[i]);
                this.extendTypeButtons[i].setToolTipText(EXTEND_TYPE_TOOLTIPS[i]);
                this.extendTypeButtons[i].setEnabled(enabled);
                this.extendTypeButtons[i].addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        SelectLayerDialog.this.updateExtendType();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                ++i;
            }
            if (enabled) {
                this.extendTypeButtons[0].setSelection(true);
                this.prevSelections.put(InsertMethodLayerDialog.this.singleLayer, 0);
            }
        }

        private void setEnabledForExtendGroup(boolean enabled, RfStructLayer selectedLayer) {
            this.extendTypeGroup.setEnabled(enabled);
            int i = 0;
            while (i < this.extendTypeButtons.length) {
                this.extendTypeButtons[i].setSelection(false);
                this.extendTypeButtons[i].setEnabled(enabled);
                ++i;
            }
            if (!enabled || selectedLayer == null) {
                return;
            }
            Integer prevIndex = this.prevSelections.get(selectedLayer);
            if (prevIndex == null) {
                prevIndex = 0;
            }
            this.extendTypeButtons[prevIndex].setSelection(true);
            this.prevSelections.put(selectedLayer, prevIndex);
        }

        protected void updateExtendType() {
            RfStructLayer selectedLayer = InsertMethodLayerDialog.this.singleLayer;
            if (selectedLayer == null) {
                Object[] selectionResult = this.getResult();
                if (selectionResult == null || selectionResult.length != 1 || !(selectionResult[0] instanceof RfStructLayer)) {
                    this.setEnabledForExtendGroup(false, null);
                    return;
                }
                selectedLayer = (RfStructLayer)selectionResult[0];
            }
            int i = 0;
            while (i < this.extendTypeButtons.length) {
                if (this.extendTypeButtons[i].getSelection()) {
                    this.prevSelections.put(selectedLayer, i);
                    break;
                }
                ++i;
            }
        }

        private void update() {
            TreePath[] expandedTreePath = this.treeViewer.getExpandedTreePaths();
            LinkedHashMap<RfModule, List<RfStructLayer>> newData = new LinkedHashMap<RfModule, List<RfStructLayer>>();
            RfStructLayer selectedLayer = null;
            Object[] currentSelection = this.getResult();
            if (currentSelection != null && currentSelection.length > 0 && currentSelection[0] instanceof RfStructLayer) {
                selectedLayer = (RfStructLayer)currentSelection[0];
            }
            String matchText = this.searchText.getText().trim();
            for (Map.Entry<RfModule, List<RfStructLayer>> layerOverrideParamEntry : InsertMethodLayerDialog.this.layerOverrideParams.entrySet()) {
                RfModule file = layerOverrideParamEntry.getKey();
                if (this.filter(file, matchText)) continue;
                newData.put(file, layerOverrideParamEntry.getValue());
            }
            this.treeViewer.setInput(newData);
            this.treeViewer.getTree().update();
            if (matchText.isEmpty()) {
                this.treeViewer.setExpandedTreePaths(expandedTreePath);
            } else {
                this.treeViewer.expandAll();
            }
            this.treeViewer.refresh();
            StructLayerContentProvider contentProvider = (StructLayerContentProvider)this.treeViewer.getContentProvider();
            Object parent = contentProvider.getParent(selectedLayer);
            if (parent instanceof RfModule && newData.get(parent) != null) {
                this.setSelectionResult(new Object[]{selectedLayer});
            }
        }

        private boolean filter(RfModule file, String matchText) {
            StringMatcher sm;
            return !matchText.isEmpty() && !(sm = new StringMatcher(String.valueOf('*') + matchText + '*', true, false)).match(file.getName());
        }

        class FilterTriggerJob
        extends UIJob {
            public FilterTriggerJob() {
                super("FilterTriggerJob");
                this.setPriority(50);
                this.setSystem(true);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SelectLayerDialog.this.update();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }
    }

    private class StructLayerContentProvider
    implements ITreeContentProvider {
        LinkedHashMap<RfModule, ArrayList<RfStructLayer>> params = new LinkedHashMap();

        private StructLayerContentProvider() {
        }

        public void dispose() {
        }

        public Map.Entry<RfModule, RfStructLayer> getElementToSelect() {
            if (this.params == null || this.params.isEmpty()) {
                return null;
            }
            Object[] files = this.params.keySet().toArray(new Object[this.params.size()]);
            RfModule fileOfSelectedLayer = (RfModule)files[files.length - 1];
            ArrayList<RfStructLayer> layersForFile = this.params.get(fileOfSelectedLayer);
            if (layersForFile == null || layersForFile.isEmpty()) {
                return null;
            }
            RfStructLayer selectedLayer = layersForFile.get(layersForFile.size() - 1);
            if (selectedLayer == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<RfModule, RfStructLayer>(fileOfSelectedLayer, selectedLayer);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            LinkedHashMap params;
            if (!(inputElement instanceof LinkedHashMap)) {
                return null;
            }
            this.params = params = (LinkedHashMap)inputElement;
            return params.keySet().toArray(new Object[params.size()]);
        }

        public Object[] getChildren(Object parentElement) {
            if (!InsertMethodLayerDialog.this.isParent(parentElement)) {
                return new Object[0];
            }
            if (!this.params.containsKey(parentElement)) {
                return new Object[0];
            }
            ArrayList<RfStructLayer> layers = this.params.get(parentElement);
            if (layers == null) {
                return new Object[0];
            }
            return layers.toArray();
        }

        public Object getParent(Object element) {
            if (!InsertMethodLayerDialog.this.isChild(element)) {
                return null;
            }
            for (Map.Entry<RfModule, ArrayList<RfStructLayer>> entry : this.params.entrySet()) {
                if (!entry.getValue().contains(element)) continue;
                return entry.getKey();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.params.containsKey(element) && !this.params.get(element).isEmpty();
        }
    }

    private class StructLayerLabelProvider
    implements ILabelProvider {
        private StructLayerLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof RfModule) {
                return DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE);
            }
            if (element instanceof RfStructLayer) {
                RfStructLayer layer = (RfStructLayer)element;
                if (layer.getStruct() != null && layer.getStruct().isLike("any_sequence")) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
                }
                if (layer.isIs()) {
                    if (layer.isUnit()) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT);
                    }
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
                }
                if (layer.isWhen()) {
                    if (layer.isUnit()) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_WHEN);
                    }
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_WHEN);
                }
                if (layer.isUnit()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_EXTEND);
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND);
            }
            return null;
        }

        public String getText(Object element) {
            if (InsertMethodLayerDialog.this.isParent(element)) {
                if (element instanceof RfModule) {
                    return ((RfModule)element).getName();
                }
            } else if (InsertMethodLayerDialog.this.isChild(element) && element instanceof RfStructLayer) {
                return String.valueOf(((RfStructLayer)element).getDeterminant().toString()) + " @line " + ((RfStructLayer)element).getStartLine();
            }
            return null;
        }
    }
}

