/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.override.EOverriddenElementInserter;
import ro.amiq.edt.base.ui.editor.override.ESignaturesInsertConfigurationProvider;
import ro.amiq.edt.base.ui.editor.override.InsertMethodLayerDialog;
import ro.amiq.edt.base.ui.editor.override.OverrideMethodsUtilsCommon;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;

public enum OverrideMethodsUtils implements OverrideMethodsUtilsCommon
{
    INSTANCE;


    public RfStructLayer getLocalStructLayer(IEPluginConfig pluginConfig, ITextEditor textEditor, boolean showNotValidPositionDialog) {
        IRfScopeElement scope;
        block14: {
            block13: {
                int offset;
                IDocument document;
                block12: {
                    block11: {
                        block10: {
                            try {
                                if (textEditor.getSite() != null && textEditor.getSite().getShell() != null && textEditor instanceof DVTEditor) break block10;
                                return null;
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return null;
                            }
                        }
                        document = ((DVTEditor)textEditor).getDocument();
                        if (document != null) break block11;
                        return null;
                    }
                    offset = OverrideMethodsUtils.getCurrentOffset(textEditor);
                    String contentType = ((IDocumentExtension3)document).getContentType("__e_partitioning", offset, true);
                    if (!contentType.equals("__e_ml_comment") && !contentType.equals("__e_sl_comment") && !contentType.equals("__e_sv_ml_comment")) break block12;
                    if (showNotValidPositionDialog) {
                        this.showNotValidPositionMessageDialog();
                    }
                    return null;
                }
                int line = document.getLineOfOffset(offset);
                scope = RfUtils.getRfScope(pluginConfig.getRfManager(), textEditor, document, offset, line);
                if (scope != null) break block13;
                if (showNotValidPositionDialog) {
                    this.showNotValidPositionMessageDialog();
                }
                return null;
            }
            if (scope instanceof RfStructLayer) break block14;
            if (showNotValidPositionDialog) {
                this.showNotValidPositionMessageDialog();
            }
            return null;
        }
        return (RfStructLayer)scope;
    }

    public int insertInEditor(IEPluginConfig pluginConfig, RfStructLayer localStructLayer, DVTEditor textEditor, int prefixLength, Map<RfMethod, String> selectedMethods, int currentOffset) {
        IDocument document = textEditor.getDocument();
        if (document == null) {
            return 0;
        }
        ESignaturesInsertConfigurationProvider config = ESignaturesInsertConfigurationProvider.createUserInsertionPointConfiguration(pluginConfig, localStructLayer, selectedMethods, (ITextEditor)textEditor, currentOffset, prefixLength);
        Change change = EOverriddenElementInserter.getInsertSignaturesChange(config);
        try {
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)textEditor, textEditor.getDocument(), "", change);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        ETextFileChange eTextFileChange = (ETextFileChange)change;
        return ((ReplaceEdit)eTextFileChange.getEdit()).getText().length();
    }

    public int insertInEditorAtEndOfLayer(RfStructLayer structLayer, ITextEditor textEditor, Map<RfMethod, String> selectedMethods) {
        ESignaturesInsertConfigurationProvider config = ESignaturesInsertConfigurationProvider.createAutoInsertionPointConfiguration(structLayer, selectedMethods, textEditor);
        Change change = EOverriddenElementInserter.getInsertSignaturesChange(config);
        try {
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)textEditor, ((DVTEditor)textEditor).getDocument(), "", change);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return 0;
    }

    public static int getCurrentOffset(ITextEditor textEditor) {
        return ((DVTEditor)textEditor).getCursor();
    }

    public void showNotValidPositionMessageDialog() {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Override Methods", null, "Cursor position not valid for method insertion. Override Methods can only be invoked from within a struct body, outside a comment block", 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
    }

    public void overrideMethodFromView(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
        try {
            RfStructLayer currentStructLayer;
            Object memberRfElement = memberWrapper.getRfElement();
            if (!(memberRfElement instanceof RfMethod) && !(memberRfElement instanceof RfMethodLayer)) {
                return;
            }
            Object hierarchyRfElement = hierarchyWrapper.getRfElement();
            if (!(hierarchyRfElement instanceof RfStruct) && !(hierarchyRfElement instanceof RfStructLayer)) {
                return;
            }
            RfStructLayer rfStructLayer = currentStructLayer = hierarchyRfElement instanceof RfStruct ? (RfStructLayer)((RfStruct)hierarchyRfElement).getDeclaration() : (RfStructLayer)hierarchyRfElement;
            if (currentStructLayer == null) {
                return;
            }
            RfStruct currentStruct = hierarchyRfElement instanceof RfStruct ? (RfStruct)hierarchyRfElement : ((RfStructLayer)hierarchyRfElement).getStruct();
            RfMethod currentMethod = memberRfElement instanceof RfMethod ? (RfMethod)memberRfElement : (RfMethod)((RfMethodLayer)memberRfElement).getNamedElement();
            Determinant determinant = currentStructLayer.getDeterminant();
            if (determinant == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            LinkedHashMap<RfModule, List<RfStructLayer>> structLayers = new LinkedHashMap<RfModule, List<RfStructLayer>>();
            for (RfDefElement currentLayer : currentStruct.getLayers()) {
                if (!(currentLayer instanceof RfStructLayer) || !determinant.equals(((RfStructLayer)currentLayer).getDeterminant()) || currentLayer.getStartInfo().virtOffset >= 0 || currentLayer.isImplicit()) continue;
                RfModule layerFileDef = currentLayer.getLayerModule();
                ArrayList<RfStructLayer> layersForFile = (ArrayList<RfStructLayer>)structLayers.get(layerFileDef);
                if (layersForFile == null) {
                    layersForFile = new ArrayList<RfStructLayer>();
                    structLayers.put(layerFileDef, layersForFile);
                }
                layersForFile.add((RfStructLayer)currentLayer);
            }
            InsertMethodLayerDialog insertMethodDialog = new InsertMethodLayerDialog(currentStructLayer, currentMethod);
            Map.Entry<RfStructLayer, String> layerInfo = insertMethodDialog.getSelectedLayers(structLayers, currentMethod.getFullName().toString());
            if (layerInfo == null) {
                return;
            }
            RfStructLayer structLayer = layerInfo.getKey();
            String extendType = layerInfo.getValue();
            IFile file = (IFile)structLayer.getFileAdapter();
            if (file == null || !file.exists() || !file.isAccessible()) {
                return;
            }
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            if (!(editor instanceof ITextEditor)) {
                return;
            }
            HashMap<RfMethod, String> methods = new HashMap<RfMethod, String>();
            methods.put(currentMethod, extendType);
            int cursorDelta = this.insertInEditorAtEndOfLayer(structLayer, (ITextEditor)editor, methods);
            ((DVTEditor)editor).selectAndReveal(structLayer.getEndOffset() + cursorDelta, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean canShowOverrideInView(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
        RfMethod currentMethod;
        Object memberRfElement = memberWrapper.getRfElement();
        if (!(memberRfElement instanceof RfMethod) && !(memberRfElement instanceof RfMethodLayer)) {
            return false;
        }
        Object hierarchyRfElement = hierarchyWrapper.getRfElement();
        if (!(hierarchyRfElement instanceof RfStruct) && !(hierarchyRfElement instanceof RfStructLayer)) {
            return false;
        }
        RfStruct currentStruct = null;
        currentStruct = hierarchyRfElement instanceof RfStruct ? (RfStruct)hierarchyRfElement : (RfStruct)((RfStructLayer)hierarchyRfElement).getNamedElement();
        if (currentStruct == null || currentStruct.isPredefined()) {
            return false;
        }
        RfMethod rfMethod = currentMethod = memberRfElement instanceof RfMethod ? (RfMethod)memberRfElement : (RfMethod)((RfMethodLayer)memberRfElement).getNamedElement();
        return currentMethod != null;
    }
}

