/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.override;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.views.THViewUtil;

public interface OverrideMethodsUtilsCommon {
    default public Map<IRfScope, List<RfMethod>> getOverrideContext(int cursorOffset, IRfScope scope) {
        LinkedHashMap<IRfScope, List<RfMethod>> methodsByDeclarationStructLayer = new LinkedHashMap<IRfScope, List<RfMethod>>();
        if (!(scope instanceof RfStructLayer var4_5)) {
            return methodsByDeclarationStructLayer;
        }
        RfStruct triggerStruct = (RfStruct)triggerStructLayer.getNamedElement();
        for (RfStruct likeParentStruct : this.getLikeParentsInHierarcyOrder(triggerStruct)) {
            ArrayList<RfMethod> result = new ArrayList<RfMethod>();
            List<RfStructMember> methodsOfParentStruct = likeParentStruct.getMethods();
            if (methodsOfParentStruct == null || (methodsOfParentStruct = THViewUtil.INSTANCE.filterElementsDeclaredInLikeParent(methodsOfParentStruct, triggerStruct)).isEmpty()) continue;
            for (RfStructMember method : methodsOfParentStruct) {
                if (this.isFinal((RfMethod)method) || (method.isPackage() || method.isPrivate()) && !method.getPackageName().equals(triggerStructLayer.getPackageName())) continue;
                result.add((RfMethod)method);
            }
            Collections.sort(result, ViewsUtils.NAMED_ELEMENT_LEXICAL_COMPARATOR);
            methodsByDeclarationStructLayer.put(likeParentStruct, result);
        }
        for (RfDefElement structLayer : triggerStruct.getLayers()) {
            if (!triggerStructLayer.getDeterminant().contains(((RfStructLayer)structLayer).getDeterminant(), true)) continue;
            ArrayList<RfMethod> structLayerMethods = new ArrayList<RfMethod>();
            boolean myLayer = structLayer.equals(triggerStructLayer);
            for (RfDefElement childLayer : structLayer.getChildren()) {
                if (myLayer && childLayer.getStartOffset() > cursorOffset) break;
                if (!(childLayer instanceof RfMethodLayer) || (namedElement = childLayer.getNamedElement()) == null || namedElement.getDeclaration() != childLayer || ((RfMethodLayer)childLayer).isFinal() || (childLayer.getNamedElement().isPackage() || childLayer.getNamedElement().isPrivate()) && !childLayer.getPackageName().equals(triggerStructLayer.getPackageName())) continue;
                structLayerMethods.add(((RfMethodLayer)childLayer).getMethod());
            }
            Collections.sort(structLayerMethods, ViewsUtils.NAMED_ELEMENT_LEXICAL_COMPARATOR);
            methodsByDeclarationStructLayer.put((RfStructLayer)structLayer, structLayerMethods);
            if (myLayer) break;
        }
        Iterator<List<RfMethod>> iterator = methodsByDeclarationStructLayer.values().iterator();
        while (iterator.hasNext()) {
            List<RfMethod> l = iterator.next();
            if (!l.isEmpty()) continue;
            iterator.remove();
        }
        return methodsByDeclarationStructLayer;
    }

    private ArrayList<RfStruct> getLikeParentsInHierarcyOrder(RfStruct triggerStruct) {
        ArrayList<RfStruct> parents = new ArrayList<RfStruct>();
        if (triggerStruct == null) {
            return parents;
        }
        RfStruct parent = triggerStruct;
        while ((parent = parent.getParentStruct()) != null) {
            parents.add(0, parent);
        }
        return parents;
    }

    default public boolean isFinal(RfMethod method) {
        for (RfDefElement methodLayer : method.getLayers()) {
            if (!(methodLayer instanceof RfMethodLayer) || !((RfMethodLayer)methodLayer).isFinal()) continue;
            return true;
        }
        return false;
    }

    default public boolean isEmptyOrUndefined(RfMethod method, Map<IRfScope, List<RfMethod>> model) {
        List<RfDefElement> layers = method.getLayers();
        if (layers == null || layers.isEmpty()) {
            return false;
        }
        if (layers.get(0).getLayerKind() != 372 && layers.get(0).getLayerKind() != 371) {
            return false;
        }
        int i = 1;
        while (i < layers.size()) {
            if (model.keySet().contains(((RfMethodLayer)layers.get(i)).getStructLayer().getStruct())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    default public boolean checkOverrideContext(int cursorOffset, RfStructLayer structLayer, String prefix) {
        Map<IRfScope, List<RfMethod>> context = this.getOverrideContext(cursorOffset, structLayer);
        if (context.isEmpty()) {
            return false;
        }
        StringMatcher matcher = ViewsUtils.createCamelCaseOrRegexMatcher((String)prefix, (boolean)true, (boolean)true);
        for (List<RfMethod> methods : context.values()) {
            for (RfMethod method : methods) {
                if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)method.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

