/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.quickassist.EAbstractQuickAssistProcessor;
import ro.amiq.edt.base.ui.editor.quickassist.QuickAssistExtractMethodProposal;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtil;

public abstract class EQuickAssistExtractMethodProcessorCommon
extends EAbstractQuickAssistProcessor {
    public static final String EXTRACT_TO_METHOD = "Extract to method";
    public static final String EXTRACT_TO_TCM = "Extract to TCM";
    protected RfDefElement fStartScope;
    protected RfDefElement fEndScope;
    protected RfDefElement fClosestContainer;
    protected String fSelectedText;
    protected int fStartOffset;
    protected int fEndOffset;
    ITextEditor fTextEditor;

    protected EQuickAssistExtractMethodProcessorCommon(IEPluginConfig pluginConfig, ITextViewer viewer, ITextEditor textEditor) {
        super(pluginConfig, viewer);
        this.fTextEditor = textEditor;
    }

    protected boolean init() {
        IRfScopeElement endScope;
        IRfScopeElement startScope;
        block9: {
            block8: {
                if (!super.init()) {
                    return false;
                }
                ISelection selection = this.getSelection();
                if (selection.isEmpty()) {
                    return false;
                }
                if (!(selection instanceof ITextSelection)) {
                    return false;
                }
                ITextSelection textSelection = (ITextSelection)selection;
                this.fSelectedText = textSelection.getText();
                this.fStartOffset = textSelection.getOffset();
                this.fEndOffset = textSelection.getOffset() + textSelection.getLength();
                int startLine = this.fDocument.getLineOfOffset(this.fStartOffset);
                startScope = RfUtils.getRfScope(this.fPluginConfig.getRfManager(), this.fTextEditor, this.fDocument, this.fStartOffset, startLine);
                if (startScope instanceof RfDefElement && !(startScope instanceof RfMethodLayer)) break block8;
                return false;
            }
            int endLine = this.fDocument.getLineOfOffset(this.fEndOffset);
            endScope = RfUtils.getRfScope(this.fPluginConfig.getRfManager(), this.fTextEditor, this.fDocument, this.fEndOffset, endLine);
            if (endScope instanceof RfDefElement) break block9;
            return false;
        }
        try {
            this.fStartScope = (RfDefElement)startScope;
            this.fEndScope = (RfDefElement)endScope;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (!this.isSameScope()) {
            return false;
        }
        this.fClosestContainer = this.internalComputeClosestContainer();
        return this.fClosestContainer != null;
    }

    public boolean validate() {
        block13: {
            block12: {
                block11: {
                    String endOffsetContentType;
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (this.fStartOffset <= 0 || !Character.isJavaIdentifierPart(this.fDocument.get(this.fStartOffset - 1, 1).charAt(0))) break block8;
                                    return false;
                                }
                                catch (Exception e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return false;
                                }
                            }
                            if (this.fEndOffset >= this.fDocument.getLength() - 1 || !Character.isJavaIdentifierPart(this.fDocument.get(this.fEndOffset, 1).charAt(0))) break block9;
                            return false;
                        }
                        String startOffsetContentType = ((IDocumentExtension3)this.fDocument).getContentType("__e_partitioning", this.fStartOffset, false);
                        endOffsetContentType = ((IDocumentExtension3)this.fDocument).getContentType("__e_partitioning", this.fEndOffset, false);
                        if (startOffsetContentType.equals("__dftl_partition_content_type") || this.fStartOffset <= 0 || ((IDocumentExtension3)this.fDocument).getContentType("__e_partitioning", this.fStartOffset - 1, false).equals("__dftl_partition_content_type")) break block10;
                        return false;
                    }
                    if (endOffsetContentType.equals("__dftl_partition_content_type") || this.fEndOffset >= this.fDocument.getLength() - 1 || ((IDocumentExtension3)this.fDocument).getContentType("__e_partitioning", this.fEndOffset - 1, false).equals("__dftl_partition_content_type") || ((IDocumentExtension3)this.fDocument).getContentType("__e_partitioning", this.fEndOffset + 1, false).equals("__dftl_partition_content_type")) break block11;
                    return false;
                }
                if (DVTDocumentUtils.hasNestedParentheses((IDocument)this.fDocument, (int)this.fStartOffset, (int)this.fEndOffset, (String)"__e_partitioning")) break block12;
                return false;
            }
            if (!this.fSelectedText.trim().isEmpty()) break block13;
            return false;
        }
        return !this.selectionContainsReturnStatement();
    }

    private boolean selectionContainsReturnStatement() {
        int possibleHasReturn = this.fSelectedText.indexOf("return");
        if (possibleHasReturn == -1) {
            return false;
        }
        return EQuickFixUtil.textContainsStatement(this.fDocument, "return", this.fStartOffset, this.fEndOffset);
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        List<DVTAbstractQuickAssistProposal> result = this.internalComputeProposal(false, EXTRACT_TO_METHOD);
        result.addAll(this.internalComputeProposal(true, EXTRACT_TO_TCM));
        return result;
    }

    private List<DVTAbstractQuickAssistProposal> internalComputeProposal(boolean isTCM, String displayString) {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        result.add(new QuickAssistExtractMethodProposal(displayString, this.fStartOffset, this.fEndOffset, this.fSelectedText, this.fClosestContainer, this.fFile, this.fDocument, this.fTextEditor, isTCM));
        return result;
    }

    protected boolean isSameScope() {
        return this.fStartScope == this.fEndScope || this.fStartOffset == this.fStartScope.getStartOffset() || this.fEndOffset == this.fEndScope.getEndOffset();
    }

    protected RfDefElement internalComputeClosestContainer() {
        Object[] enclosingMethod = EQuickFixUtil.getEnclosingLayer(this.fStartScope, (IProgressMonitor)new NullProgressMonitor(), RfMethodLayer.class);
        return enclosingMethod == null || enclosingMethod.length == 0 ? EQuickFixUtil.getEncompassingScopeInternal(this.fStartScope, this.fStartOffset, this.fEndOffset) : (RfDefElement)enclosingMethod[0];
    }

    protected abstract ISelection getSelection();
}

