/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickassist;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.EDTBasePlugin;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.refactoring.ExtractMethodWalker;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtil;
import ro.amiq.edt.base.utils.EASTUtils;

public abstract class QuickAssistExtractMethodProposalCommon
extends DVTAbstractQuickAssistProposal {
    private static final String NEWLINE = System.lineSeparator();
    private static final String FUNCTION_NAME = "extracted";
    private static final String EVENT_CATEGORY = "EVENT_CATEGORY";
    private static final String METHOD_NAME = "METHOD_NAME";
    private boolean isTCM;
    private String displayString;
    protected LinkedModeModel linkedProposalModel;
    protected DVTTextFileChange triggerChange;
    protected DVTLinkedPositionProvider linkedPositionMaker;
    private int startOffset;
    private int endOffset;
    private String selectedText;
    private RfDefElement triggerEnclContainerDefElement;
    private IFile triggerFile;
    protected String specifiedFunctionName = "";

    protected QuickAssistExtractMethodProposalCommon(String displayString, int startOffset, int endOffset, String selectedText, RfDefElement selectionEnclosingContainer, IFile file, IDocument document, ITextEditor fTextEditor, boolean isTCM) {
        this.displayString = displayString;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.selectedText = selectedText;
        this.triggerEnclContainerDefElement = selectionEnclosingContainer;
        this.triggerFile = file;
        this.isTCM = isTCM;
        this.document = document;
        this.linkedProposalModel = new LinkedModeModel();
        this.specifiedFunctionName = FUNCTION_NAME;
        this.editor = (DVTEditor)fTextEditor;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
    }

    protected CreateChangeStatus createChanges() throws Exception {
        RfNamedElement triggerEnclContainerNamedElement = this.triggerEnclContainerDefElement.getNamedElement();
        this.triggerChange = new DVTTextFileChange(this.triggerFile.getProjectRelativePath().toOSString(), this.triggerFile);
        int insertOffset = 0;
        IRegion startLineInfo = this.document.getLineInformationOfOffset(this.triggerEnclContainerDefElement.getStartOffset());
        insertOffset = startLineInfo.getOffset();
        if (triggerEnclContainerNamedElement == null) {
            return CreateChangeStatus.ERROR;
        }
        this.computeEdits(triggerEnclContainerNamedElement, insertOffset);
        return CreateChangeStatus.OK;
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        CreateChangeStatus status = this.createChanges();
        if (status != CreateChangeStatus.OK) {
            return status;
        }
        this.compositeChange = this.createCompositeChange();
        if (this.compositeChange == null) {
            return CreateChangeStatus.ERROR;
        }
        return CreateChangeStatus.OK;
    }

    private CompositeChange createCompositeChange() {
        CompositeChange compositeChange = new CompositeChange("Quick fix extract method");
        compositeChange.add((Change)this.triggerChange);
        return compositeChange;
    }

    private void computeEdits(RfNamedElement triggerEnclContainerElement, int insertOffset) throws Exception {
        RfDefElement enclosingContainerScope = this.triggerEnclContainerDefElement;
        if (!(triggerEnclContainerElement instanceof RfMethod)) {
            return;
        }
        String parentEvent = null;
        boolean isEnclosingMethodtcm = ((RfMethod)triggerEnclContainerElement).isTCM();
        if (isEnclosingMethodtcm) {
            parentEvent = ((RfMethod)triggerEnclContainerElement).getEvent();
        }
        RfDefElement methodLayer = enclosingContainerScope;
        while (methodLayer != null && !(methodLayer instanceof RfMethodLayer)) {
            methodLayer = (RfDefElement)((Object)methodLayer.getEnclosingScope());
        }
        if (methodLayer == null) {
            return;
        }
        IRfFileDef fileDef = methodLayer.getDefFile();
        if (!(fileDef instanceof RfModule)) {
            return;
        }
        RfModule module = (RfModule)fileDef;
        RfProject rfProject = methodLayer.getRfProject();
        if (rfProject == null) {
            return;
        }
        EModuleInfo moduleInfo = rfProject.getModuleInfo(module.getModuleReference());
        if (moduleInfo == null) {
            return;
        }
        AST moduleAST = moduleInfo.getModuleAST();
        if (moduleAST == null) {
            return;
        }
        AST layerAST = EASTUtils.getInstance().getLayerAST(moduleAST, methodLayer);
        if (layerAST == null) {
            return;
        }
        ExtractMethodWalker extractMethodWalker = new ExtractMethodWalker(this.startOffset, this.endOffset);
        extractMethodWalker.method_struct_member(layerAST);
        extractMethodWalker.computeInputsAndOutputs();
        Set<RfNamedElement> outputCandidates = extractMethodWalker.getOutputCandidates();
        RfNamedElement returnValue = this.computeReturnValue(outputCandidates, extractMethodWalker.getInputCandidates());
        String argsName = this.computeFunctionArgs(extractMethodWalker, false);
        String replaceFunction = this.computeReplacement(isEnclosingMethodtcm, extractMethodWalker, returnValue, argsName);
        int functionUsageChangeRelativeOffset = replaceFunction.indexOf(this.specifiedFunctionName);
        ReplaceEdit replaceEdit = new ReplaceEdit(this.startOffset, this.selectedText.length(), replaceFunction);
        Map<String, List<IRegion>> functionNameTrack = Collections.singletonMap(METHOD_NAME, Arrays.asList(new Region(functionUsageChangeRelativeOffset, this.specifiedFunctionName.length())));
        this.triggerChange.setEdit((TextEdit)new MultiTextEdit());
        this.triggerChange.addEdit((TextEdit)replaceEdit, functionNameTrack);
        String functionArguments = this.computeFunctionArgs(extractMethodWalker, true);
        this.addInsertEdit(this.triggerChange, functionArguments, insertOffset, returnValue, extractMethodWalker, parentEvent, methodLayer);
    }

    private String computeReplacement(boolean isEnclosingMethodtcm, ExtractMethodWalker extractMethodWalker, RfNamedElement returnValue, String argsName) {
        String replaceFunction = String.valueOf(this.specifiedFunctionName) + "(" + argsName + ");" + NEWLINE;
        if (this.isTCM && !isEnclosingMethodtcm) {
            replaceFunction = "start " + replaceFunction;
        } else if (returnValue != null) {
            replaceFunction = String.valueOf(returnValue.getName()) + " = " + replaceFunction;
        } else if (returnValue == null && extractMethodWalker.selectionContainsResultAssign() && extractMethodWalker.getResultType() != null) {
            replaceFunction = "result = " + replaceFunction;
        }
        return this.addIndent(replaceFunction);
    }

    private void addInsertEdit(DVTTextFileChange fileChange, String functionArguments, int insertOffset, RfNamedElement returnValue, ExtractMethodWalker inputOutputHidsVisitor, String parentEvent, RfDefElement methodLayer) {
        String event;
        String indent = DVTDocumentUtils.getIndent((int)this.startOffset, (IDocument)this.document);
        String indentStep = TextUtils.getIndentTab((boolean)this.editor.isInsertSpaces(EDTBasePlugin.getDefault().getCombinedPreferenceStore()), (int)this.editor.getTabWidth());
        StringBuilder functionSignature = new StringBuilder();
        functionSignature.append(NEWLINE).append(indentStep).append(this.specifiedFunctionName).append("(").append(functionArguments).append(")");
        String resultType = inputOutputHidsVisitor.getResultType();
        if (returnValue instanceof RfVar || inputOutputHidsVisitor.selectionContainsResultAssign() && resultType != null) {
            if (returnValue instanceof RfVar) {
                functionSignature.append(" : ").append(this.computeListDataType(returnValue));
            } else {
                functionSignature.append(" : ").append(this.computeListDataType(methodLayer.getNamedElement()));
            }
            String returnValueType = null;
            if (returnValue instanceof RfVar) {
                returnValueType = ((RfVar)returnValue).getTypeName() == null ? ((RfVar)returnValue).getAssociatedTypeName() : ((RfVar)returnValue).getTypeName();
            }
            functionSignature.append(returnValueType != null ? returnValueType : resultType);
        }
        String string = event = parentEvent == null ? "@sys.any" : "@" + parentEvent;
        if (this.isTCM) {
            functionSignature.append(" ").append(event);
        }
        functionSignature.append(" is {").append(NEWLINE);
        String functionSignatureFormatted = EQuickFixUtil.indentSelection(this.editor, this.selectedText, indent, indentStep);
        functionSignature.append(functionSignatureFormatted).append(NEWLINE);
        if (returnValue != null) {
            functionSignature.append(indentStep).append(indentStep).append("return ").append(returnValue.getName()).append(";").append(NEWLINE);
        }
        functionSignature.append(indentStep).append("};").append(NEWLINE).append(NEWLINE);
        String insertText = functionSignature.toString();
        int functionNameFirstRelativeOffset = insertText.indexOf(this.specifiedFunctionName);
        int functionNameLastRelativeOffset = insertText.lastIndexOf(this.specifiedFunctionName);
        List<IRegion> trackedMethodNames = Arrays.asList(new Region(functionNameFirstRelativeOffset, this.specifiedFunctionName.length()));
        if (functionNameFirstRelativeOffset != functionNameLastRelativeOffset) {
            trackedMethodNames.add((IRegion)new Region(functionNameLastRelativeOffset, this.specifiedFunctionName.length()));
        }
        HashMap<String, List<IRegion>> trackRegions = new HashMap<String, List<IRegion>>();
        trackRegions.put(METHOD_NAME, trackedMethodNames);
        if (this.isTCM) {
            trackRegions.put(EVENT_CATEGORY, Arrays.asList(new Region(insertText.indexOf(event), event.length())));
        }
        InsertEdit insertEdit = new InsertEdit(insertOffset, insertText);
        fileChange.addEdit((TextEdit)insertEdit, trackRegions);
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.compositeChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    protected void addLinkedPositions(IDocument documentWithLinkedPosition, DVTTextFileChange changeWithLinkedPosition) throws Exception {
        ArrayList allRegions = new ArrayList();
        Collection linkedPositionRegions = changeWithLinkedPosition.getAbsoluteRegionsByCategory(METHOD_NAME);
        if (linkedPositionRegions == null || linkedPositionRegions.isEmpty()) {
            return;
        }
        allRegions.addAll(linkedPositionRegions);
        this.linkedPositionMaker.addMultipleLinkedPosition(allRegions, documentWithLinkedPosition, -1);
        Collection eventRegions = changeWithLinkedPosition.getAbsoluteRegionsByCategory(EVENT_CATEGORY);
        if (eventRegions != null && !eventRegions.isEmpty()) {
            IRegion region = (IRegion)eventRegions.iterator().next();
            this.linkedPositionMaker.addMultipleLinkedPosition(eventRegions, documentWithLinkedPosition, region.getOffset());
        }
        this.linkedPositionMaker.enterLinkedMode(documentWithLinkedPosition, null);
    }

    protected String getDisplayStringInternal() throws Exception {
        return this.displayString;
    }

    protected String getProposalName() {
        return "Extract to " + (this.isTCM ? "TCM" : "method");
    }

    protected String getCategory() {
        return "QuickAssistProposalCategory_" + ((Object)((Object)this)).toString();
    }

    private RfNamedElement computeReturnValue(Set<RfNamedElement> outputCandidates, Set<RfNamedElement> inputCandidates) {
        RfNamedElement returnValue = null;
        if (outputCandidates == null) {
            return null;
        }
        for (RfNamedElement outputCandidate : outputCandidates) {
            if (inputCandidates.contains(outputCandidate) || outputCandidate instanceof RfVar && !this.shouldAddPredefinedVariable((RfVar)outputCandidate)) continue;
            if (returnValue != null) {
                return null;
            }
            returnValue = outputCandidate;
        }
        return returnValue;
    }

    private String computeFunctionArgs(ExtractMethodWalker inputOutputHidsVisitor, boolean includeType) {
        StringBuilder allArgs = new StringBuilder();
        ArrayList<String> functionArgsList = new ArrayList<String>();
        Set<RfNamedElement> inputCandidates = inputOutputHidsVisitor.getInputCandidates();
        if (inputCandidates != null && !inputCandidates.isEmpty()) {
            this.computeArguments(includeType, false, allArgs, functionArgsList, inputCandidates);
        }
        functionArgsList.clear();
        Set<RfNamedElement> outputCandidates = inputOutputHidsVisitor.getOutputCandidates();
        if (outputCandidates != null && !outputCandidates.isEmpty()) {
            this.computeArguments(includeType, outputCandidates.size() > 1, allArgs, functionArgsList, outputCandidates);
        }
        functionArgsList.clear();
        Set<RfNamedElement> refCandidates = inputOutputHidsVisitor.getRefCandidates();
        if (refCandidates != null && !refCandidates.isEmpty()) {
            this.computeArguments(includeType, true, allArgs, functionArgsList, refCandidates);
        }
        return allArgs.toString();
    }

    private void computeArguments(boolean includeType, boolean isRef, StringBuilder allArgs, ArrayList<String> functionArgsList, Set<RfNamedElement> candidates) {
        for (RfNamedElement candidate : candidates) {
            RfVar varCandidate;
            if (!(candidate instanceof RfVar) || !this.shouldAddPredefinedVariable(varCandidate = (RfVar)candidate)) continue;
            StringBuilder arg = new StringBuilder();
            arg.append(candidate.getName());
            if (includeType) {
                StringBuilder type = new StringBuilder();
                type.append(this.computeListDataType(candidate));
                if (type.length() == 0 && isRef) {
                    type.append("*");
                }
                String typeName = varCandidate.isIterator() || varCandidate.isIndex() || varCandidate.getTypeName() == null ? varCandidate.getAssociatedFullTypeName() : varCandidate.getTypeName();
                type.append(typeName);
                arg.append(" : ").append(type.toString());
            }
            if (arg.length() <= 0) continue;
            functionArgsList.add(arg.toString());
        }
        if (allArgs.length() != 0 && !functionArgsList.isEmpty()) {
            allArgs.append(", ");
        }
        allArgs.append(functionArgsList.size() == 1 ? functionArgsList.get(0) : DVTStringUtil.join((Object[])functionArgsList.toArray(), (String)", "));
    }

    private boolean shouldAddPredefinedVariable(RfVar varCandidate) {
        if (!varCandidate.isIterator() && !varCandidate.isIndex()) {
            return true;
        }
        RfDefElement firstLayer = varCandidate.getFirstLayer();
        if (firstLayer == null) {
            return true;
        }
        IRfScope enclosingScope = firstLayer.getEnclosingScope();
        if (!(enclosingScope instanceof RfActionBlockLayer)) {
            return true;
        }
        return ((RfActionBlockLayer)enclosingScope).getStartOffset() < this.startOffset;
    }

    private String computeListDataType(RfNamedElement namedElement) {
        StringBuilder listDataType = new StringBuilder();
        if (!(namedElement instanceof IRfAssociatedTypeElement)) {
            return "";
        }
        IRfNamedElement associatedType = ((IRfAssociatedTypeElement)namedElement).getAssociatedType();
        if (!(associatedType instanceof IRfAssociatedType)) {
            return "";
        }
        int typeListValue = ((IRfAssociatedType)associatedType).getAssociatedTypeList();
        while (typeListValue > 0) {
            listDataType.append("list of ");
            --typeListValue;
        }
        return listDataType.toString();
    }

    private String addIndent(String replaceFunction) {
        int leadingWhitespaces = DVTStringUtil.countLeadingWhitespaces((String)this.selectedText);
        int leadingTabs = DVTStringUtil.countLeadingTabs((String)this.selectedText);
        String originalIndent = String.valueOf(new String(new char[leadingTabs]).replace("\u0000", "\t")) + new String(new char[leadingWhitespaces - leadingTabs]).replace("\u0000", " ");
        return String.valueOf(originalIndent) + replaceFunction;
    }
}

