/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix;

import java.io.File;
import java.util.Map;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.quickfix.CreateImportedFileQuickFixCommon;

public class CreateImportedFileQuickFix
extends CreateImportedFileQuickFixCommon {
    public CreateImportedFileQuickFix(IEPluginConfig pluginConfig, IMarker marker, ITextViewer viewer, File fileToCreate, Image image) {
        super(pluginConfig, marker, viewer, fileToCreate, image);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        IPath projectLocation = this.project.getLocation();
        if (projectLocation == null) {
            return;
        }
        this.createFile(this.fileToCreate);
        if (projectLocation.isPrefixOf((IPath)this.filePath)) {
            IFile file = this.project.getFile(this.filePath.makeRelativeTo(projectLocation));
            file.refreshLocal(1, null);
            PropertiesManager.addSessionProperty((IResource)file, (String)PropertyTypes.QN_IMPORTED_FILE, (String)IBuildConfigParserConstants.LanguageSyntax.E_1647_2011.id);
            this.openFile(file);
            this.triggerReparse(this.pluginConfig, this.fileToCreate);
        } else {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                    public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                        Map autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots((IProject)CreateImportedFileQuickFix.this.project);
                        IFile file = DVTAutoLinkManager.getInstance().createAutoLink(CreateImportedFileQuickFix.this.project, (IPath)CreateImportedFileQuickFix.this.filePath, autoLinkedRoots, null, false);
                        if (file == null) {
                            return;
                        }
                        CreateImportedFileQuickFix.this.openFile(file);
                        CreateImportedFileQuickFix.this.triggerReparse(CreateImportedFileQuickFix.this.pluginConfig, CreateImportedFileQuickFix.this.fileToCreate);
                    }
                };
                DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(this.project, "QUICK_FIX", op, false);
            }, null);
        }
    }
}

