/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DVTDummyCreateFileChange;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.quickfix.BaseAbstractQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtil;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;

public abstract class CreateImportedFileQuickFixCommon
extends BaseAbstractQuickFix {
    protected static final String FILE_TEXT = "<'" + System.lineSeparator() + System.lineSeparator() + "'>";
    protected File fileToCreate;
    protected Path filePath;
    private Image image;
    protected IEPluginConfig pluginConfig;

    protected CreateImportedFileQuickFixCommon(IEPluginConfig pluginConfig, IMarker marker, ITextViewer viewer, File fileToCreate, Image image) {
        super(marker, viewer);
        this.fileToCreate = fileToCreate;
        this.filePath = new Path(fileToCreate.getAbsolutePath());
        this.image = image;
        this.pluginConfig = pluginConfig;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        super.preApplyQuickFix(document);
    }

    public void createFile(File file) {
        DVTFileUtils.getInstance().writeStringToFile(file, FILE_TEXT, false);
    }

    public IFile[] getAffectedFiles() throws Exception {
        return new ArrayList().toArray(new IFile[0]);
    }

    public void triggerReparse(IEPluginConfig pluginConfig, File newCreatedFile) {
        IEModule eModule = pluginConfig.getModelManager().getEModel().getOrCreateEModule((IFile)this.triggerResource);
        if (eModule == null) {
            return;
        }
        eModule.scheduleReparse(false, true, 0L, this.triggerDocument, false);
    }

    public void openFile(IFile file) {
        IEditorPart openEditor = EQuickFixUtil.getInstance().openEditor(file);
        if (!(openEditor instanceof DVTEditor)) {
            return;
        }
        this.targetEditor = (DVTEditor)openEditor;
        this.targetDocument = this.targetEditor.getDocument();
        this.targetEditor.doSave(null);
        try {
            this.targetEditor.setCursor(this.targetDocument.getLineOffset(1));
            ((AbstractEEditor)this.targetEditor).showContentAssistProposalsForCreatedFile();
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getDisplayString() {
        return "Create file '" + this.filePath.lastSegment() + "' in '" + this.filePath.removeLastSegments(1) + "'";
    }

    public Image getImage() {
        if (this.image == null) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FILE);
        }
        return this.image;
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        IRfSingleLangProject rfProject = this.enclosingScope.getRfProject();
        if (rfProject == null) {
            return;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return;
        }
        IFile file = DVTFileUtils.getInstance().getProjectFile(project, this.filePath.toOSString());
        if (file == null) {
            return;
        }
        if (this.fileToCreate.exists()) {
            EQuickFixUtil.getInstance().doProposeRebuild(project, this.filePath).thenAccept(wasRebuildStarted -> {
                if (!wasRebuildStarted.booleanValue()) {
                    return;
                }
                this.openFile(file);
            });
            return;
        }
        DVTDummyCreateFileChange createFileEdit = new DVTDummyCreateFileChange(this.triggerResource.getName(), (IFile)this.triggerResource, this.filePath);
        this.compositeTextChange = new CompositeChange("_new_file_");
        this.compositeTextChange.add((Change)createFileEdit);
        ETextFileChange newFileContentChange = new ETextFileChange("_new_file_content", file);
        newFileContentChange.setEdit((TextEdit)new InsertEdit(0, FILE_TEXT));
        this.compositeTextChange.add((Change)newFileContentChange);
    }

    public String getFileParentDir() {
        if (this.filePath == null) {
            return "";
        }
        return this.filePath.makeAbsolute().removeLastSegments(1).toOSString();
    }
}

