/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.ui.editor.quickfix.AbstractVariableQuickFix;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;

public abstract class DeclareEnumQuickFixCommon
extends AbstractVariableQuickFix {
    private RfScalarTypeLayer scalarTypeLayer;

    protected DeclareEnumQuickFixCommon(IMarker marker, ITextViewer viewer, RfScalarTypeLayer scalarTypeLayer) {
        super(marker, viewer);
        this.scalarTypeLayer = scalarTypeLayer;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        IRfFileDef module = this.scalarTypeLayer.getDefFile();
        IResource resourceToApplyFix = (IResource)module.getAdapter(IResource.class);
        if (resourceToApplyFix != this.marker.getResource()) {
            this.targetResource = resourceToApplyFix;
        }
    }

    public String getDisplayString() {
        return "Declare enumerated type constant '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_EXTEND);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.scalarTypeLayer.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    @Override
    protected void computeInsertOffset() throws Exception {
        int typeLayerStartOffset = this.scalarTypeLayer.getStartOffset();
        if (typeLayerStartOffset < 0) {
            this.insertOffset = -1;
            return;
        }
        int openBracketOffset = DVTDocumentUtils.getCharOffset((char)'[', (int)typeLayerStartOffset, (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__e_partitioning");
        if (openBracketOffset < 0) {
            this.insertOffset = -1;
            return;
        }
        this.insertOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)openBracketOffset, (DVTEditor)this.targetEditor, (IDocument)this.targetDocument) - 1;
    }

    @Override
    protected void computeReplacementString() {
        Collection<RfEnum> enums = this.scalarTypeLayer.getEnums();
        this.replacementString = String.valueOf(enums != null && !enums.isEmpty() ? ", " : "") + this.elementName;
    }

    @Override
    protected void computeTextEdits() throws Exception {
        RfModule targetFile = this.scalarTypeLayer.getLayerModule();
        if (targetFile == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IResource fileAdapter = targetFile.getFileAdapter();
        if (!(fileAdapter instanceof IFile)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.textFileChange = new ETextFileChange(fileAdapter.getProjectRelativePath().toOSString(), (IFile)fileAdapter);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }
}

