/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.ui.editor.quickfix.AbstractVariableQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtil;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;

public abstract class DeclareFieldQuickFixCommon
extends AbstractVariableQuickFix {
    protected RfDefElement enclosingStructLayer;
    private boolean isHierarchical;
    private boolean isStatic;
    protected boolean addTab;
    protected IEPluginConfig pluginConfig;

    protected DeclareFieldQuickFixCommon(IEPluginConfig pluginConfig, IMarker marker, ITextViewer viewer, RfDefElement enclosingStructLayer, boolean isStaticAccess) {
        super(marker, viewer);
        this.enclosingStructLayer = enclosingStructLayer;
        this.isHierarchical = marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        this.isStatic = isStaticAccess;
        this.pluginConfig = pluginConfig;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        IResource resourceToApplyFix;
        if (this.isHierarchical && (resourceToApplyFix = (IResource)this.enclosingStructLayer.getDefFile().getAdapter(IResource.class)) != this.marker.getResource()) {
            this.targetResource = resourceToApplyFix;
        }
    }

    @Override
    protected void computeInsertOffset() throws Exception {
        this.insertOffset = this.getInsertOffsetAfterPreviousField();
        if (this.insertOffset < 0) {
            this.addTab = true;
            int structBodyOffset = DVTDocumentUtils.getCharOffset((char)'{', (int)this.enclosingStructLayer.getStartOffset(), (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__e_partitioning") + 1;
            IRegion structDeclarationInfo = this.targetDocument.getLineInformationOfOffset(structBodyOffset);
            this.insertOffset = structDeclarationInfo != null ? structDeclarationInfo.getOffset() + structDeclarationInfo.getLength() : structBodyOffset;
        }
        if (this.insertOffset < 0) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    @Override
    protected void computeReplacementString() {
        String indent = DVTDocumentUtils.getIndent((int)this.insertOffset, (IDocument)this.targetDocument);
        String tabOrSpace = DVTDocumentUtils.getTabOrSpace((DVTEditor)this.targetEditor, (IPreferenceStore)this.pluginConfig.getCombinedPreferenceStore());
        String staticString = this.isStatic ? "static " : "";
        String varType = EQuickFixUtil.guessType(this.elementName, (RfDefElement)this.enclosingScope, this.offset);
        this.typeLength = varType.length();
        String elementNameWithPrefix = String.valueOf(EQuickFixUtil.NEW_LINE) + indent + (this.addTab ? tabOrSpace : "") + staticString + this.elementName + " : ";
        this.elementNamePrefixLength = elementNameWithPrefix.length();
        this.replacementString = String.valueOf(elementNameWithPrefix) + varType + ";";
    }

    @Override
    protected void computeTextEdits() throws Exception {
        RfModule targetFile = this.enclosingStructLayer.getLayerModule();
        if (targetFile == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IResource fileAdapter = targetFile.getFileAdapter();
        if (!(fileAdapter instanceof IFile)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.textFileChange = new ETextFileChange(fileAdapter.getProjectRelativePath().toOSString(), (IFile)fileAdapter);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit, (IRegion)new Region(this.elementNamePrefixLength, this.typeLength));
    }

    private int getInsertOffsetAfterPreviousField() {
        IRegion lineInformation;
        block6: {
            int lineOfpreviousField;
            block5: {
                try {
                    int errorLine = this.isHierarchical ? Integer.MAX_VALUE : this.targetDocument.getLineOfOffset(this.offset) + 1;
                    lineOfpreviousField = -1;
                    Collection structChildren = this.enclosingStructLayer.getChildren();
                    for (RfDefElement structChild : structChildren) {
                        if (!(structChild instanceof RfFieldLayer)) continue;
                        int fieldLine = structChild.getEndLine();
                        int n = lineOfpreviousField = fieldLine < errorLine ? fieldLine : lineOfpreviousField;
                    }
                    if (lineOfpreviousField >= 0) break block5;
                    return -1;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return -1;
                }
            }
            lineInformation = this.targetDocument.getLineInformation(lineOfpreviousField - 1);
            if (lineInformation != null) break block6;
            return -1;
        }
        return lineInformation.getOffset() + lineInformation.getLength();
    }

    protected void addLinkedPosition() throws BadLocationException, BadPositionCategoryException {
        Collection trackedRegions = this.textFileChange.getAbsoluteRegions();
        if (trackedRegions == null) {
            return;
        }
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        for (IRegion region : trackedRegions) {
            this.linkedPositionProvider.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.targetDocument);
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public String getDisplayString() {
        return "Declare field '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingStructLayer.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

