/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.ui.editor.quickfix.AbstractVariableQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtil;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;
import ro.amiq.etools.eparser.EAST;

public abstract class DeclareVariableQuickFixCommon
extends AbstractVariableQuickFix {
    private RfDefElement enclosingMethod;
    private static final String VAR = "var";
    private RfModule.IdentifierPosition singleIdentifierPosition;
    protected static final String NEWLINE = System.lineSeparator();
    private boolean isInline;
    private boolean isSingleIdentifier;
    private boolean insertBeforeExpression;
    private RfDefElement encompassingScope;
    private IEPluginConfig pluginConfig;
    private static final Set<Integer> ACTION_BLOCK_NODE_LIST = new HashSet<Integer>(Arrays.asList(143, 144, 147, 148, 149, 153, 156, 163));
    private static final Set<Integer> ACTION_NODE_LIST = new HashSet<Integer>(Arrays.asList(112, 115, 114, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 108));

    protected DeclareVariableQuickFixCommon(IEPluginConfig pluginConfig, IMarker marker, ITextViewer viewer, RfDefElement enclosingMethod, boolean isSingleIdentifier, RfModule.IdentifierPosition singleIdentifierPosition) {
        super(marker, viewer);
        this.enclosingMethod = enclosingMethod;
        this.isSingleIdentifier = isSingleIdentifier;
        this.singleIdentifierPosition = singleIdentifierPosition;
        this.pluginConfig = pluginConfig;
        this.linkedProposalModel = new LinkedModeModel();
    }

    @Override
    protected void computeInsertOffset() throws Exception {
        this.encompassingScope = EQuickFixUtil.getEncompassingScopeOfIdentifiers(this.elementName, this.enclosingMethod, (RfDefElement)this.enclosingScope);
        if (this.encompassingScope == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.isInline = this.isInline(this.encompassingScope);
        if (this.isInline) {
            this.insertOffset = this.position.offset;
        } else if (this.isSingleIdentifier) {
            this.insertOffset = this.getActionStartOffsetFromAST(this.singleIdentifierPosition.getIdAst());
            if (!this.encompassingScope.containsOffset(this.insertOffset)) {
                this.insertOffset = -1;
            }
            if (this.insertOffset >= 0) {
                this.insertBeforeExpression = true;
            }
        }
        if (this.insertOffset < 0) {
            int lineOffset = this.encompassingScope.getStartOffset() - 1;
            this.insertOffset = DVTDocumentUtils.getCharOffset((char)'{', (int)lineOffset, (boolean)true, (int)500, (IDocument)this.targetDocument, (String)"__e_partitioning") + 1;
        }
        if (this.insertOffset < 0) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private int getActionStartOffsetFromAST(AST idAst) {
        if (idAst == null) {
            return -1;
        }
        if (ACTION_BLOCK_NODE_LIST.contains(idAst.getType())) {
            return idAst.getOffset();
        }
        if (ACTION_NODE_LIST.contains(idAst.getType())) {
            AST firstChild = idAst.getFirstChild();
            if (firstChild != null) {
                return this.getMinOffsetChildAst(firstChild, firstChild.getOffset());
            }
            return -1;
        }
        int prevSibilingOffset = this.getActionStartOffsetFromAST((AST)((EAST)idAst).getPrevSibling());
        if (prevSibilingOffset != -1) {
            return prevSibilingOffset;
        }
        return this.getActionStartOffsetFromAST((AST)((EAST)idAst).getParent());
    }

    public int getMinOffsetChildAst(AST ast, int lastMin) {
        int nextSibilingOffset;
        AST nextSibiling;
        int childAstOffset;
        AST firstChild;
        if (ast == null) {
            return lastMin;
        }
        if (ast.getOffset() <= 0) {
            if (lastMin == 0) {
                lastMin = Integer.MAX_VALUE;
            }
        } else if (ast.getOffset() < lastMin) {
            lastMin = ast.getOffset();
        }
        if ((firstChild = ast.getFirstChild()) != null && (childAstOffset = this.getMinOffsetChildAst(firstChild, lastMin)) > 0 && childAstOffset < lastMin) {
            lastMin = childAstOffset;
        }
        if ((nextSibiling = ast.getNextSibling()) != null && (nextSibilingOffset = this.getMinOffsetChildAst(nextSibiling, lastMin)) > 0 && nextSibilingOffset < lastMin) {
            lastMin = nextSibilingOffset;
        }
        return lastMin;
    }

    @Override
    protected void computeReplacementString() {
        String indent = DVTDocumentUtils.getIndent((int)this.insertOffset, (IDocument)this.targetDocument);
        String tabOrSpace = DVTDocumentUtils.getTabOrSpace((DVTEditor)this.targetEditor, (IPreferenceStore)this.pluginConfig.getCombinedPreferenceStore());
        String varType = EQuickFixUtil.guessType(this.elementName, this.enclosingMethod, this.offset);
        this.typeLength = varType.length();
        String elementNameWithPrefix = "";
        if (!this.isInline && !this.insertBeforeExpression) {
            elementNameWithPrefix = String.valueOf(elementNameWithPrefix) + EQuickFixUtil.NEW_LINE + indent + tabOrSpace;
        }
        elementNameWithPrefix = String.valueOf(elementNameWithPrefix) + "var " + this.elementName + " : ";
        this.elementNamePrefixLength = elementNameWithPrefix.length();
        this.replacementString = String.valueOf(elementNameWithPrefix) + varType;
        if (!this.isInline) {
            this.replacementString = String.valueOf(this.replacementString) + ";";
        }
        if (this.insertBeforeExpression) {
            this.replacementString = String.valueOf(this.replacementString) + EQuickFixUtil.NEW_LINE + indent;
        }
    }

    @Override
    protected void computeTextEdits() throws Exception {
        RfModule targetFile = this.encompassingScope.getLayerModule();
        if (targetFile == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.textFileChange = new ETextFileChange(targetFile.getFileAdapter().getProjectRelativePath().toOSString(), (IFile)targetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        Region trackedRegion = new Region(this.elementNamePrefixLength, this.typeLength);
        if (this.isInline) {
            ReplaceEdit replaceEdit = new ReplaceEdit(this.insertOffset, this.elementName.length(), this.replacementString);
            this.textFileChange.addEdit((TextEdit)replaceEdit, (IRegion)trackedRegion);
        } else {
            InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
            this.textFileChange.addEdit((TextEdit)insertEdit, (IRegion)trackedRegion);
        }
    }

    private boolean isInline(RfDefElement encompassingScope) throws BadLocationException, BadPartitioningException {
        if (!this.isSingleIdentifier) {
            return false;
        }
        Collection methodMembers = ((RfMethodLayer)this.enclosingMethod).getChildren();
        if (methodMembers == null || methodMembers.isEmpty()) {
            return false;
        }
        RfDefElement methodIsScope = null;
        for (RfDefElement child : methodMembers) {
            if (!(child instanceof RfActionBlockLayer)) continue;
            methodIsScope = child;
            break;
        }
        if (methodIsScope == null) {
            return false;
        }
        int markerEndOffset = this.position.getOffset() + this.position.getLength();
        char nextChar = DVTDocumentUtils.nextCodeChar((IDocument)this.targetDocument, (int)markerEndOffset, (String)"__e_partitioning", (boolean)true);
        if (nextChar == '=') {
            int nextCharOffset = DVTDocumentUtils.getCharOffset((char)nextChar, (int)(markerEndOffset + 1), (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__e_partitioning");
            return (nextChar = DVTDocumentUtils.nextCodeChar((IDocument)this.targetDocument, (int)(nextCharOffset + 1), (String)"__e_partitioning", (boolean)true)) != '=';
        }
        return false;
    }

    protected void addLinkedPosition() throws Exception {
        Collection trackedRegions = this.textFileChange.getAbsoluteRegions();
        if (trackedRegions == null) {
            return;
        }
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        for (IRegion region : trackedRegions) {
            this.linkedPositionProvider.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.targetDocument);
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public String getDisplayString() {
        return "Declare variable '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VARIABLE);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

