/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.ui.editor.quickfix.BaseAbstractQuickFix;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;

public abstract class DidYouMeanQuickFixCommon
extends BaseAbstractQuickFix {
    RfModule fTargetFile;
    private String fProposalName;
    private Image fTypeImage;

    protected DidYouMeanQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    protected DidYouMeanQuickFixCommon(IMarker marker, ITextViewer viewer, String proposalName, Image typeImage, RfModule file) {
        super(marker, viewer);
        this.fTypeImage = typeImage;
        this.fTargetFile = file;
        this.fProposalName = proposalName;
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.textFileChange = new ETextFileChange(this.fTargetFile.getName(), (IFile)this.fTargetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        this.textFileChange.addEdit((TextEdit)new ReplaceEdit(this.position.getOffset(), this.position.getLength(), this.fProposalName));
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.textFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        return affectedFiles.toArray(new IFile[affectedFiles.size()]);
    }

    public String getDisplayString() {
        return "Did you mean '" + this.fProposalName + "'?";
    }

    public Image getImage() {
        return this.fTypeImage;
    }
}

